/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.codehaus.mojo.mrm.api.BaseFileSystem;
import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.impl.MemoryFileEntry;

public class MemoryFileSystem
extends BaseFileSystem {
    private final Map contents = new HashMap();

    public MemoryFileSystem() {
        this.contents.put(this.getRoot(), new ArrayList());
    }

    public synchronized Entry[] listEntries(DirectoryEntry directory) {
        List entries = (List)this.contents.get(directory == null ? this.getRoot() : directory);
        if (entries == null) {
            return null;
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public long getLastModified(DirectoryEntry entry) throws IOException {
        long lastModified = 0L;
        Entry[] entries = this.listEntries(entry);
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                lastModified = Math.max(lastModified, entries[i].getLastModified());
            }
        }
        return lastModified;
    }

    protected synchronized Entry get(DirectoryEntry parent, String name) {
        parent.getClass();
        List parentEntries = (List)this.contents.get(parent);
        if (parentEntries == null) {
            return null;
        }
        Iterator i = parentEntries.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            if (!name.equals(entry.getName())) continue;
            return entry;
        }
        return null;
    }

    public synchronized DirectoryEntry mkdir(DirectoryEntry parent, String name) {
        parent.getClass();
        parent = this.getNormalizedParent(parent);
        List entries = this.getEntriesList(parent);
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            if (!name.equals(entry.getName())) continue;
            if (entry instanceof DirectoryEntry) {
                return (DirectoryEntry)entry;
            }
            return null;
        }
        DefaultDirectoryEntry entry = new DefaultDirectoryEntry((FileSystem)this, parent, name);
        entries.add(entry);
        return entry;
    }

    public synchronized FileEntry put(DirectoryEntry parent, String name, InputStream content) throws IOException {
        parent.getClass();
        parent = this.getNormalizedParent(parent);
        List entries = this.getEntriesList(parent);
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            if (!name.equals(entry.getName())) continue;
            if (entry instanceof FileEntry) {
                i.remove();
                continue;
            }
            return null;
        }
        MemoryFileEntry entry = new MemoryFileEntry((FileSystem)this, parent, name, IOUtils.toByteArray((InputStream)content));
        entries.add(entry);
        return entry;
    }

    private DirectoryEntry getNormalizedParent(DirectoryEntry parent) {
        if (parent.getParent() == null) {
            return this.getRoot();
        }
        return this.mkdir(parent.getParent(), parent.getName());
    }

    private synchronized List getEntriesList(DirectoryEntry directory) {
        ArrayList entries = (ArrayList)this.contents.get(directory);
        if (entries == null) {
            entries = new ArrayList();
            this.contents.put(directory, entries);
        }
        return entries;
    }

    public synchronized void remove(Entry entry) {
        if (entry == null) {
            return;
        }
        DirectoryEntry parent = entry.getParent();
        if (parent == null) {
            return;
        }
        List entries = (List)this.contents.get(parent);
        if (entries == null) {
            return;
        }
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            if (!entry.equals(e)) continue;
            if (e instanceof DirectoryEntry) {
                Entry[] children = this.listEntries((DirectoryEntry)e);
                for (int j = children.length - 1; j >= 0; --j) {
                    this.remove(children[j]);
                }
                this.contents.remove(e);
            }
            i.remove();
            return;
        }
    }
}

