/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.model.Model;

public final class Utils {
    private Utils() {
        throw new IllegalAccessError("Utility class");
    }

    public static InputStream asInputStream(Object content) throws IOException {
        if (content instanceof byte[]) {
            return new ByteArrayInputStream((byte[])content);
        }
        if (content instanceof File) {
            return new FileInputStream((File)content);
        }
        return new ByteArrayInputStream(content.toString().getBytes("UTF-8"));
    }

    public static byte[] newEmptyJarContent() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue("Archiver-Version", "1.0");
        manifest.getMainAttributes().putValue("Created-By", "Mock Repository Maven Plugin");
        JarOutputStream jos = new JarOutputStream((OutputStream)bos, manifest);
        jos.close();
        bos.close();
        byte[] emptyJar = bos.toByteArray();
        return emptyJar;
    }

    public static byte[] newEmptyMavenPluginJarContent(String groupId, String artifactId, String version) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue("Archiver-Version", "1.0");
        manifest.getMainAttributes().putValue("Created-By", "Mock Repository Maven Plugin");
        JarOutputStream jos = new JarOutputStream((OutputStream)bos, manifest);
        JarEntry entry = new JarEntry("META-INF/maven/plugin.xml");
        jos.putNextEntry(entry);
        jos.write(("<plugin><groupId>" + groupId + "</groupId><artifactId>" + artifactId + "</artifactId><version>" + version + "</version></plugin>").getBytes());
        jos.closeEntry();
        jos.close();
        bos.close();
        byte[] emptyJar = bos.toByteArray();
        return emptyJar;
    }

    public static String getGAVPathName(String groupId, String artifactId, String version) {
        return Utils.getGAVPath(groupId, artifactId, version) + '/' + artifactId + '-' + version;
    }

    public static String getGAVPath(String groupId, String artifactId, String version) {
        return groupId.replace('.', '/') + (artifactId != null ? '/' + artifactId + (version != null ? '/' + version : "") : "");
    }

    public static String getVersion(Model model) {
        String version = model.getVersion();
        if (version == null) {
            version = model.getParent().getVersion();
        }
        return version;
    }

    public static String getArtifactId(Model model) {
        String artifactId = model.getArtifactId();
        if (artifactId == null) {
            artifactId = model.getParent().getArtifactId();
        }
        return artifactId;
    }

    public static String getGroupId(Model model) {
        String groupId = model.getGroupId();
        if (groupId == null) {
            groupId = model.getParent().getGroupId();
        }
        return groupId;
    }

    public static String urlEncodePath(String path) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer(path.length() + 64);
        int last = 0;
        int i = path.indexOf(47);
        while (i != -1) {
            buf.append(Utils.urlEncodePathSegment(path.substring(last, i)));
            buf.append(path.substring(i, Math.min(path.length(), i + 1)));
            last = i + 1;
            i = path.indexOf(47, last);
        }
        buf.append(path.substring(last));
        return buf.toString();
    }

    public static String urlEncodePathSegment(String pathSegment) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer(pathSegment.length() + 64);
        byte[] chars = pathSegment.getBytes("UTF-8");
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case 33: 
                case 36: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 44: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    buf.append((char)chars[i]);
                    continue block4;
                }
                case 32: {
                    buf.append('+');
                    continue block4;
                }
                default: {
                    buf.append('%');
                    if ((chars[i] & 0xF0) == 0) {
                        buf.append('0');
                    }
                    buf.append(Integer.toHexString(chars[i] & 0xFF));
                }
            }
        }
        return buf.toString();
    }
}

