/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.digest;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.mrm.api.BaseFileSystem;
import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.impl.GenerateOnErrorFileEntry;
import org.codehaus.mojo.mrm.impl.LinkFileEntry;
import org.codehaus.mojo.mrm.impl.digest.DigestFileEntryFactory;
import org.codehaus.mojo.mrm.impl.digest.MD5DigestFileEntry;
import org.codehaus.mojo.mrm.impl.digest.SHA1DigestFileEntry;

public class AutoDigestFileSystem
extends BaseFileSystem {
    private final FileSystem backing;
    private final Map digestFactories;

    public AutoDigestFileSystem(FileSystem backing) {
        this(backing, new DigestFileEntryFactory[]{new MD5DigestFileEntry.Factory(), new SHA1DigestFileEntry.Factory()});
    }

    public AutoDigestFileSystem(FileSystem backing, DigestFileEntryFactory[] digestFactories) {
        this.backing = backing;
        HashMap<String, DigestFileEntryFactory> map = new HashMap<String, DigestFileEntryFactory>(digestFactories.length);
        for (int i = 0; i < digestFactories.length; ++i) {
            map.put(digestFactories[i].getType(), digestFactories[i]);
        }
        this.digestFactories = Collections.unmodifiableMap(map);
    }

    public Entry[] listEntries(DirectoryEntry directory) {
        TreeMap<String, LinkFileEntry> result = new TreeMap<String, LinkFileEntry>();
        HashMap<String, Entry> missing = new HashMap<String, Entry>();
        HashSet<String> present = new HashSet<String>();
        Entry[] entries = this.backing.listEntries(DefaultDirectoryEntry.equivalent((FileSystem)this.backing, (DirectoryEntry)directory));
        for (int i = 0; i < entries.length; ++i) {
            String name = entries[i].getName();
            if (entries[i] instanceof FileEntry) {
                Iterator j = this.digestFactories.keySet().iterator();
                while (j.hasNext()) {
                    String type = (String)j.next();
                    if (name.endsWith(type)) {
                        present.add(name);
                        continue;
                    }
                    missing.put(name + type, entries[i]);
                }
                result.put(name, new LinkFileEntry((FileSystem)this, directory, (FileEntry)entries[i]));
                continue;
            }
            if (!(entries[i] instanceof DirectoryEntry)) continue;
            result.put(name, (LinkFileEntry)DefaultDirectoryEntry.equivalent((FileSystem)this, (DirectoryEntry)((DirectoryEntry)entries[i])));
        }
        missing.keySet().removeAll(present);
        Iterator i = missing.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            FileEntry fileEntry = (FileEntry)entry.getValue();
            Iterator j = this.digestFactories.values().iterator();
            while (j.hasNext()) {
                DigestFileEntryFactory factory = (DigestFileEntryFactory)j.next();
                if (!name.endsWith(factory.getType())) continue;
                result.put(name, (LinkFileEntry)factory.create((FileSystem)this, directory, fileEntry));
            }
        }
        return result.values().toArray(new Entry[result.size()]);
    }

    public long getLastModified(DirectoryEntry entry) throws IOException {
        return this.backing.getLastModified(DefaultDirectoryEntry.equivalent((FileSystem)this.backing, (DirectoryEntry)entry));
    }

    public Entry get(String path) {
        Entry entry = this.backing.get(path);
        if (entry == null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.length() == 0) {
                return this.getRoot();
            }
            String[] parts = path.split("/");
            if (parts.length == 0) {
                return this.getRoot();
            }
            DirectoryEntry parent = this.getRoot();
            for (int i = 0; i < parts.length - 1; ++i) {
                parent = new DefaultDirectoryEntry((FileSystem)this, parent, parts[i]);
            }
            String name = parts[parts.length - 1];
            Iterator j = this.digestFactories.values().iterator();
            while (j.hasNext()) {
                DigestFileEntryFactory factory = (DigestFileEntryFactory)j.next();
                if (!name.endsWith(factory.getType())) continue;
                Entry shadow = this.backing.get(parent.toPath() + "/" + StringUtils.removeEnd((String)name, (String)factory.getType()));
                return factory.create((FileSystem)this, parent, (FileEntry)shadow);
            }
            return this.get(parent, name);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() == 0) {
            return this.getRoot();
        }
        String[] parts = path.split("/");
        if (parts.length == 0) {
            return this.getRoot();
        }
        DirectoryEntry parent = this.getRoot();
        for (int i = 0; i < parts.length - 1; ++i) {
            parent = new DefaultDirectoryEntry((FileSystem)this, parent, parts[i]);
        }
        if (entry instanceof FileEntry) {
            Iterator j = this.digestFactories.values().iterator();
            while (j.hasNext()) {
                DigestFileEntryFactory factory = (DigestFileEntryFactory)j.next();
                if (!entry.getName().endsWith(factory.getType())) continue;
                Entry shadow = this.backing.get(parent.toPath() + "/" + StringUtils.removeEnd((String)entry.getName(), (String)factory.getType()));
                return new GenerateOnErrorFileEntry((FileSystem)this, parent, (FileEntry)entry, factory.create((FileSystem)this, parent, (FileEntry)shadow));
            }
            return new LinkFileEntry((FileSystem)this, parent, (FileEntry)entry);
        }
        if (entry instanceof DirectoryEntry) {
            Iterator j = this.digestFactories.values().iterator();
            while (j.hasNext()) {
                DigestFileEntryFactory factory = (DigestFileEntryFactory)j.next();
                if (!entry.getName().endsWith(factory.getType())) continue;
                Entry shadow = this.backing.get(parent.toPath() + "/" + StringUtils.removeEnd((String)entry.getName(), (String)factory.getType()));
                return factory.create((FileSystem)this, parent, (FileEntry)shadow);
            }
            return new DefaultDirectoryEntry((FileSystem)this, parent, entry.getName());
        }
        return null;
    }
}

