/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.mrm.api.BaseFileEntry;
import org.codehaus.mojo.mrm.api.BaseFileSystem;
import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;
import org.codehaus.mojo.mrm.impl.maven.ArtifactFileEntry;
import org.codehaus.mojo.mrm.impl.maven.MetadataFileEntry;

public class ArtifactStoreFileSystem
extends BaseFileSystem {
    private static final String GROUP_ID_PATH_REGEX = "/((?:[^/]+/)+)";
    private static final String ARTIFACT_ID_PATH_REGEX = "([^/]+)/";
    private static final String VERSION_REGEX = "([^/]+)/";
    private static final String SNAPSHOT_VERSION_REGEX = "([^/]+)-SNAPSHOT/";
    static final Pattern METADATA = Pattern.compile("/((?:[^/]+/)+)(maven-metadata\\.xml)");
    static final Pattern ARTIFACT = Pattern.compile("/((?:[^/]+/)+)([^/]+)/([^/]+)/(\\2-\\3(-[^.]+)?\\.([^/]*))");
    static final Pattern SNAPSHOT_ARTIFACT = Pattern.compile("/((?:[^/]+/)+)([^/]+)/([^/]+)-SNAPSHOT/(\\2-(?:\\3-(?:SNAPSHOT|\\d{8}\\.\\d{6}-\\d+))(-[^.]+)?\\.([^/]*))");
    private final ArtifactStore store;

    public ArtifactStoreFileSystem(ArtifactStore store) {
        this.store = store;
    }

    public Entry[] listEntries(DirectoryEntry directory) {
        String name;
        if (this.getRoot().equals(directory)) {
            TreeSet rootGroupIds = new TreeSet(this.store.getGroupIds(""));
            Entry[] result = new Entry[rootGroupIds.size()];
            int index = 0;
            Iterator i = rootGroupIds.iterator();
            while (i.hasNext()) {
                result[index++] = new DefaultDirectoryEntry((FileSystem)this, this.getRoot(), (String)i.next());
            }
            return result;
        }
        ArrayList<BaseFileEntry> result = new ArrayList<BaseFileEntry>();
        HashSet<String> names = new HashSet<String>();
        String path = directory.toPath().substring(1);
        try {
            this.store.getMetadataLastModified(path);
            MetadataFileEntry entry = new MetadataFileEntry((FileSystem)this, directory, path, this.store);
            if (!names.contains(entry.getName())) {
                result.add(entry);
                names.add(entry.getName());
            }
        }
        catch (MetadataNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        String groupId = path.replace('/', '.');
        String groupIdPrefix = groupId + ".";
        TreeSet groupIds = new TreeSet(this.store.getGroupIds(groupId));
        Iterator i = groupIds.iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            if (names.contains(name)) continue;
            result.add((BaseFileEntry)new DefaultDirectoryEntry((FileSystem)this, directory, name));
            names.add(name);
        }
        i = this.store.getArtifactIds(groupId).iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            if (names.contains(name)) continue;
            result.add((BaseFileEntry)new DefaultDirectoryEntry((FileSystem)this, directory, name));
            names.add(name);
        }
        DirectoryEntry parent = directory.getParent();
        if (parent != null && !this.getRoot().equals(parent)) {
            groupId = parent.toPath().substring(1).replace('/', '.');
            String artifactId = directory.getName();
            Iterator i2 = this.store.getVersions(groupId, artifactId).iterator();
            while (i2.hasNext()) {
                String name2 = (String)i2.next();
                if (names.contains(name2)) continue;
                result.add((BaseFileEntry)new DefaultDirectoryEntry((FileSystem)this, directory, name2));
                names.add(name2);
            }
            DirectoryEntry grandParent = parent.getParent();
            if (grandParent != null && !this.getRoot().equals(grandParent)) {
                groupId = grandParent.toPath().substring(1).replace('/', '.');
                artifactId = parent.getName();
                String version = directory.getName();
                Iterator i3 = this.store.getArtifacts(groupId, artifactId, version).iterator();
                while (i3.hasNext()) {
                    ArtifactFileEntry entry = new ArtifactFileEntry((FileSystem)this, directory, (Artifact)i3.next(), this.store);
                    if (names.contains(entry.getName())) continue;
                    result.add(entry);
                    names.add(entry.getName());
                }
            }
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Entry)o1).getName().compareTo(((Entry)o2).getName());
            }
        });
        return result.toArray(new Entry[result.size()]);
    }

    protected Entry get(DirectoryEntry parent, String name) {
        String path = parent.toPath() + "/" + name;
        if ("favicon.ico".equals(name)) {
            return null;
        }
        if (METADATA.matcher(path).matches()) {
            MetadataFileEntry entry = new MetadataFileEntry((FileSystem)this, parent, parent.toPath(), this.store);
            try {
                entry.getLastModified();
                return entry;
            }
            catch (IOException e) {
                return null;
            }
        }
        Matcher snapshotArtifact = SNAPSHOT_ARTIFACT.matcher(path);
        if (snapshotArtifact.matches()) {
            String groupId = StringUtils.stripEnd((String)snapshotArtifact.group(1), (String)"/").replace('/', '.');
            String artifactId = snapshotArtifact.group(2);
            String version = snapshotArtifact.group(3) + "-SNAPSHOT";
            Pattern rule = Pattern.compile("\\Q" + artifactId + "\\E-(?:\\Q" + StringUtils.removeEnd((String)version, (String)"-SNAPSHOT") + "\\E-(SNAPSHOT|(\\d{4})(\\d{2})(\\d{2})\\.(\\d{2})(\\d{2})(\\d{2})-(\\d+)))(?:-([^.]+))?\\.([^/]*)");
            Matcher matcher = rule.matcher(name);
            if (!matcher.matches()) {
                String classifier = snapshotArtifact.group(5);
                String type = snapshotArtifact.group(6);
                if (classifier != null) {
                    classifier = classifier.substring(1);
                }
                if (StringUtils.isEmpty((String)classifier)) {
                    classifier = null;
                }
                return new ArtifactFileEntry((FileSystem)this, parent, new Artifact(groupId, artifactId, version, classifier, type), this.store);
            }
            if (matcher.group(1).equals("SNAPSHOT")) {
                return new ArtifactFileEntry((FileSystem)this, parent, new Artifact(groupId, artifactId, version, matcher.group(9), matcher.group(10)), this.store);
            }
            try {
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
                cal.set(1, Integer.parseInt(matcher.group(2)));
                cal.set(2, Integer.parseInt(matcher.group(3)) - 1);
                cal.set(5, Integer.parseInt(matcher.group(4)));
                cal.set(11, Integer.parseInt(matcher.group(5)));
                cal.set(12, Integer.parseInt(matcher.group(6)));
                cal.set(13, Integer.parseInt(matcher.group(7)));
                long timestamp = cal.getTimeInMillis();
                int buildNumber = Integer.parseInt(matcher.group(8));
                return new ArtifactFileEntry((FileSystem)this, parent, new Artifact(groupId, artifactId, version, matcher.group(9), matcher.group(10), timestamp, buildNumber), this.store);
            }
            catch (NullPointerException e) {
                return new DefaultDirectoryEntry((FileSystem)this, parent, name);
            }
        }
        Matcher artifact = ARTIFACT.matcher(path);
        if (artifact.matches()) {
            String groupId = StringUtils.stripEnd((String)artifact.group(1), (String)"/").replace('/', '.');
            String artifactId = artifact.group(2);
            String version = artifact.group(3);
            String classifier = artifact.group(5);
            String type = artifact.group(6);
            if (classifier != null) {
                classifier = classifier.substring(1);
            }
            if (StringUtils.isEmpty((String)classifier)) {
                classifier = null;
            }
            return new ArtifactFileEntry((FileSystem)this, parent, new Artifact(groupId, artifactId, version, classifier, type), this.store);
        }
        return new DefaultDirectoryEntry((FileSystem)this, parent, name);
    }

    public long getLastModified(DirectoryEntry entry) throws IOException {
        return System.currentTimeMillis();
    }
}

