/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.ArtifactStore;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;

public class CompositeArtifactStore
extends BaseArtifactStore {
    private final ArtifactStore[] stores;

    public CompositeArtifactStore(ArtifactStore[] stores) {
        stores.getClass();
        this.stores = stores;
    }

    public Set getGroupIds(String parentGroupId) {
        TreeSet result = new TreeSet();
        for (int i = 0; i < this.stores.length; ++i) {
            Set groupIds = this.stores[i].getGroupIds(parentGroupId);
            if (groupIds == null) continue;
            result.addAll(groupIds);
        }
        return result;
    }

    public Set getArtifactIds(String groupId) {
        TreeSet result = new TreeSet();
        for (int i = 0; i < this.stores.length; ++i) {
            Set artifactIds = this.stores[i].getArtifactIds(groupId);
            if (artifactIds == null) continue;
            result.addAll(artifactIds);
        }
        return result;
    }

    public Set getVersions(String groupId, String artifactId) {
        TreeSet result = new TreeSet();
        for (int i = 0; i < this.stores.length; ++i) {
            Set versions = this.stores[i].getVersions(groupId, artifactId);
            if (versions == null) continue;
            result.addAll(versions);
        }
        return result;
    }

    public Set getArtifacts(String groupId, String artifactId, String version) {
        TreeSet result = new TreeSet();
        for (int i = 0; i < this.stores.length; ++i) {
            Set artifacts = this.stores[i].getArtifacts(groupId, artifactId, version);
            if (artifacts == null) continue;
            result.addAll(artifacts);
        }
        return result;
    }

    public long getLastModified(Artifact artifact) throws IOException, ArtifactNotFoundException {
        for (int i = 0; i < this.stores.length; ++i) {
            try {
                return this.stores[i].getLastModified(artifact);
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
                continue;
            }
        }
        throw new ArtifactNotFoundException(artifact);
    }

    public long getSize(Artifact artifact) throws IOException, ArtifactNotFoundException {
        for (int i = 0; i < this.stores.length; ++i) {
            try {
                return this.stores[i].getSize(artifact);
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
                continue;
            }
        }
        throw new ArtifactNotFoundException(artifact);
    }

    public InputStream get(Artifact artifact) throws IOException, ArtifactNotFoundException {
        for (int i = 0; i < this.stores.length; ++i) {
            try {
                return this.stores[i].get(artifact);
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
                continue;
            }
        }
        throw new ArtifactNotFoundException(artifact);
    }

    public void set(Artifact artifact, InputStream content) throws IOException {
        throw new IOException("Read-only store");
    }

    public Metadata getMetadata(String path) throws IOException, MetadataNotFoundException {
        boolean found = false;
        Metadata result = new Metadata();
        HashSet<String> pluginArtifactIds = new HashSet<String>();
        HashSet<String> snapshotVersions = new HashSet<String>();
        for (int i = 0; i < this.stores.length; ++i) {
            try {
                Metadata partial = this.stores[i].getMetadata(path);
                if (StringUtils.isEmpty((String)result.getArtifactId()) && !StringUtils.isEmpty((String)partial.getArtifactId())) {
                    result.setArtifactId(partial.getArtifactId());
                    found = true;
                }
                if (StringUtils.isEmpty((String)result.getGroupId()) && !StringUtils.isEmpty((String)partial.getGroupId())) {
                    result.setGroupId(partial.getGroupId());
                    found = true;
                }
                if (StringUtils.isEmpty((String)result.getVersion()) && !StringUtils.isEmpty((String)partial.getVersion())) {
                    result.setVersion(partial.getVersion());
                    found = true;
                }
                if (partial.getPlugins() != null && !partial.getPlugins().isEmpty()) {
                    Iterator j = partial.getPlugins().iterator();
                    while (j.hasNext()) {
                        Plugin plugin = (Plugin)j.next();
                        if (pluginArtifactIds.contains(plugin.getArtifactId())) continue;
                        result.addPlugin(plugin);
                        pluginArtifactIds.add(plugin.getArtifactId());
                    }
                    found = true;
                }
                if (partial.getVersioning() == null) continue;
                Versioning rVers = result.getVersioning();
                if (rVers == null) {
                    rVers = new Versioning();
                }
                Versioning pVers = partial.getVersioning();
                String rLU = found ? rVers.getLastUpdated() : null;
                String pLU = pVers.getLastUpdated();
                if (pLU != null && (rLU == null || rLU.compareTo(pLU) < 0)) {
                    if (!StringUtils.isEmpty((String)pVers.getLatest())) {
                        rVers.setLatest(pVers.getLatest());
                    }
                    if (!StringUtils.isEmpty((String)pVers.getRelease())) {
                        rVers.setLatest(pVers.getRelease());
                    }
                    rVers.setLastUpdated(pVers.getLastUpdated());
                }
                Iterator j = pVers.getVersions().iterator();
                while (j.hasNext()) {
                    String version = (String)j.next();
                    if (rVers.getVersions().contains(version)) continue;
                    rVers.addVersion(version);
                }
                if (pVers.getSnapshot() != null && (rVers.getSnapshot() == null || pVers.getSnapshot().getBuildNumber() > rVers.getSnapshot().getBuildNumber())) {
                    Snapshot snapshot = new Snapshot();
                    snapshot.setBuildNumber(pVers.getSnapshot().getBuildNumber());
                    snapshot.setTimestamp(pVers.getSnapshot().getTimestamp());
                    rVers.setSnapshot(snapshot);
                }
                try {
                    if (pVers.getSnapshotVersions() != null && !pVers.getSnapshotVersions().isEmpty()) {
                        j = pVers.getSnapshotVersions().iterator();
                        while (j.hasNext()) {
                            SnapshotVersion snapshotVersion = (SnapshotVersion)j.next();
                            String key = snapshotVersion.getVersion() + "-" + snapshotVersion.getClassifier() + "." + snapshotVersion.getExtension();
                            if (snapshotVersions.contains(key)) continue;
                            rVers.addSnapshotVersion(snapshotVersion);
                            snapshotVersions.add(key);
                        }
                    }
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
                result.setVersioning(rVers);
                found = true;
                continue;
            }
            catch (MetadataNotFoundException e) {
                // empty catch block
            }
        }
        if (!found) {
            throw new MetadataNotFoundException(path);
        }
        return result;
    }

    public long getMetadataLastModified(String path) throws IOException, MetadataNotFoundException {
        boolean found = false;
        long lastModified = 0L;
        for (int i = 0; i < this.stores.length; ++i) {
            try {
                if (!found) {
                    lastModified = this.stores[i].getMetadataLastModified(path);
                    found = true;
                    continue;
                }
                lastModified = Math.max(lastModified, this.stores[i].getMetadataLastModified(path));
                continue;
            }
            catch (MetadataNotFoundException e) {
                // empty catch block
            }
        }
        if (!found) {
            throw new MetadataNotFoundException(path);
        }
        return lastModified;
    }
}

