/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DiskArtifactStore
extends BaseArtifactStore {
    private final File root;

    public DiskArtifactStore(File root) {
        this.root = root;
    }

    public Set getGroupIds(String parentGroupId) {
        File parentDir;
        File file = parentDir = StringUtils.isEmpty((String)parentGroupId) ? this.root : new File(this.root, parentGroupId.replace('.', '/'));
        if (!parentDir.isDirectory()) {
            return Collections.EMPTY_SET;
        }
        File[] groupDirs = parentDir.listFiles();
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < groupDirs.length; ++i) {
            if (!groupDirs[i].isDirectory()) continue;
            result.add(groupDirs[i].getName());
        }
        return result;
    }

    public Set getArtifactIds(String groupId) {
        File groupDir = new File(this.root, groupId.replace('.', '/'));
        if (!groupDir.isDirectory()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> result = new HashSet<String>();
        File[] artifactDirs = groupDir.listFiles();
        for (int i = 0; i < artifactDirs.length; ++i) {
            if (!artifactDirs[i].isDirectory()) continue;
            String artifactId = artifactDirs[i].getName();
            result.add(artifactId);
        }
        return result;
    }

    public Set getVersions(String groupId, String artifactId) {
        File groupDir = new File(this.root, groupId.replace('.', '/'));
        File artifactDir = new File(groupDir, artifactId);
        if (!artifactDir.isDirectory()) {
            return Collections.EMPTY_SET;
        }
        File[] dirs = artifactDir.listFiles();
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < dirs.length; ++i) {
            if (!dirs[i].isDirectory()) continue;
            result.add(dirs[i].getName());
        }
        return result;
    }

    public Set getArtifacts(final String groupId, final String artifactId, final String version) {
        abstract class ArtifactFactory {
            ArtifactFactory() {
            }

            abstract Artifact get(File var1);
        }
        ArtifactFactory factory;
        Pattern rule;
        File groupDir = new File(this.root, groupId.replace('.', '/'));
        File artifactDir = new File(groupDir, artifactId);
        File versionDir = new File(artifactDir, version);
        if (!versionDir.isDirectory()) {
            return Collections.EMPTY_SET;
        }
        if (version.endsWith("-SNAPSHOT")) {
            rule = Pattern.compile("\\Q" + artifactId + "\\E-(?:\\Q" + StringUtils.removeEnd((String)version, (String)"-SNAPSHOT") + "\\E-(SNAPSHOT|(\\d{4})(\\d{2})(\\d{2})\\.(\\d{2})(\\d{2})(\\d{2})-(\\d+)))(?:-([^.]+))?\\.([^/]*)");
            factory = new ArtifactFactory(){
                {
                }

                public Artifact get(File file) {
                    Matcher matcher = rule.matcher(file.getName());
                    if (!matcher.matches()) {
                        return null;
                    }
                    if (matcher.group(1).equals("SNAPSHOT")) {
                        return new Artifact(groupId, artifactId, version, matcher.group(9), matcher.group(10));
                    }
                    try {
                        GregorianCalendar cal = new GregorianCalendar();
                        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
                        cal.set(1, Integer.parseInt(matcher.group(2)));
                        cal.set(2, Integer.parseInt(matcher.group(3)) - 1);
                        cal.set(5, Integer.parseInt(matcher.group(4)));
                        cal.set(11, Integer.parseInt(matcher.group(5)));
                        cal.set(12, Integer.parseInt(matcher.group(6)));
                        cal.set(13, Integer.parseInt(matcher.group(7)));
                        long timestamp = cal.getTimeInMillis();
                        int buildNumber = Integer.parseInt(matcher.group(8));
                        return new Artifact(groupId, artifactId, version, matcher.group(9), matcher.group(10), timestamp, buildNumber);
                    }
                    catch (NullPointerException e) {
                        return null;
                    }
                }
            };
        } else {
            rule = Pattern.compile("\\Q" + artifactId + "\\E-\\Q" + version + "\\E(?:-([^.]+))?\\.(.+)");
            factory = new ArtifactFactory(){
                {
                }

                public Artifact get(File file) {
                    Matcher matcher = rule.matcher(file.getName());
                    if (!matcher.matches()) {
                        return null;
                    }
                    return new Artifact(groupId, artifactId, version, matcher.group(1), matcher.group(2));
                }
            };
        }
        File[] files = versionDir.listFiles();
        HashSet<Artifact> result = new HashSet<Artifact>(files.length);
        for (int i = 0; i < files.length; ++i) {
            Artifact artifact;
            if (!files[i].isFile() || !rule.matcher(files[i].getName()).matches() || (artifact = factory.get(files[i])) == null) continue;
            result.add(artifact);
        }
        return result;
    }

    public long getLastModified(Artifact artifact) throws IOException, ArtifactNotFoundException {
        File groupDir = new File(this.root, artifact.getGroupId().replace('.', '/'));
        File artifactDir = new File(groupDir, artifact.getArtifactId());
        File versionDir = new File(artifactDir, artifact.getVersion());
        File file = new File(versionDir, artifact.getName());
        if (!file.isFile()) {
            throw new ArtifactNotFoundException(artifact);
        }
        return file.lastModified();
    }

    public long getSize(Artifact artifact) throws IOException, ArtifactNotFoundException {
        File groupDir = new File(this.root, artifact.getGroupId().replace('.', '/'));
        File artifactDir = new File(groupDir, artifact.getArtifactId());
        File versionDir = new File(artifactDir, artifact.getVersion());
        File file = new File(versionDir, artifact.getName());
        if (!file.isFile()) {
            throw new ArtifactNotFoundException(artifact);
        }
        return file.length();
    }

    public InputStream get(Artifact artifact) throws IOException, ArtifactNotFoundException {
        File groupDir = new File(this.root, artifact.getGroupId().replace('.', '/'));
        File artifactDir = new File(groupDir, artifact.getArtifactId());
        File versionDir = new File(artifactDir, artifact.getVersion());
        File file = new File(versionDir, artifact.getName());
        if (!file.isFile()) {
            throw new ArtifactNotFoundException(artifact);
        }
        return new FileInputStream(file);
    }

    public void set(Artifact artifact, InputStream content) throws IOException {
        throw new UnsupportedOperationException("Read-only store");
    }

    public Metadata getMetadata(String path) throws IOException, MetadataNotFoundException {
        Metadata metadata;
        File file = this.root;
        String[] parts = StringUtils.strip((String)path, (String)"/").split("/");
        for (int i = 0; i < parts.length; ++i) {
            file = new File(file, parts[i]);
        }
        if (!(file = new File(file, "maven-metadata.xml")).isFile()) {
            throw new MetadataNotFoundException(path);
        }
        MetadataXpp3Reader reader = new MetadataXpp3Reader();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            metadata = reader.read((InputStream)inputStream);
        }
        catch (XmlPullParserException e) {
            try {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return metadata;
    }

    public long getMetadataLastModified(String path) throws IOException, MetadataNotFoundException {
        File file = this.root;
        String[] parts = StringUtils.strip((String)path, (String)"/").split("/");
        Stack<File> stack = new Stack<File>();
        for (int i = 0; i < parts.length; ++i) {
            if ("..".equals(parts[i])) {
                if (!stack.isEmpty()) {
                    file = (File)stack.pop();
                    continue;
                }
                file = this.root;
                continue;
            }
            if (".".equals(parts[i])) continue;
            file = new File(file, parts[i]);
            stack.push(file);
        }
        if (!(file = new File(file, "maven-metadata.xml")).isFile()) {
            throw new MetadataNotFoundException(path);
        }
        return file.lastModified();
    }
}

