/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.impl.DiskFileSystem;
import org.codehaus.mojo.mrm.impl.Utils;

public class FileSystemServlet
extends HttpServlet {
    private static final int NAME_COL_WIDTH = 50;
    private static final int SIZE_COL_WIDTH = 20;
    private FileSystem fileSystem;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String repositoryDir = config.getInitParameter("repository.dir");
        File repo = new File(repositoryDir);
        if (!repo.exists()) {
            throw new RuntimeException("The repository " + repo + " does not exist!");
        }
        System.out.println("<< Repository dir is: " + repo.getAbsolutePath() + " >>");
        this.fileSystem = new DiskFileSystem(repo, false);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String context;
        boolean doesRequestJson = req.getHeader("Accept").contains("application/json");
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
            context = req.getContextPath();
        } else {
            context = req.getContextPath() + req.getServletPath();
        }
        Entry entry = this.fileSystem.get(path);
        if (entry instanceof FileEntry) {
            FileEntry fileEntry = (FileEntry)entry;
            this.serverFileRaw(resp, fileEntry);
            return;
        }
        if (entry instanceof DirectoryEntry) {
            if (!path.endsWith("/")) {
                resp.sendRedirect(entry.getName() + "/");
                return;
            }
            DirectoryEntry dirEntry = (DirectoryEntry)entry;
            Entry[] entries = this.fileSystem.listEntries(dirEntry);
            if (doesRequestJson) {
                this.serverDirectoryAsJSON(req, resp, path, context, dirEntry, entries);
            } else {
                this.serveDirectoryAsHTML(resp, path, context, dirEntry, entries);
            }
            return;
        }
        resp.sendError(404);
    }

    private void serverDirectoryAsJSON(HttpServletRequest req, HttpServletResponse resp, String path, String context, DirectoryEntry dirEntry, Entry[] entries) throws IOException {
        resp.setContentType("application/json");
        PrintWriter w = resp.getWriter();
        if (entries != null) {
            w.write("[");
            for (int i = 0; i < entries.length; ++i) {
                String childName = entries[i].getName();
                boolean directory = entries[i] instanceof DirectoryEntry;
                String pathName = "http://" + req.getHeader("host") + context + "/" + path + Utils.urlEncodePathSegment(childName);
                if (directory) {
                    String dirName = childName + "/";
                    w.write("{");
                    w.write("type: 'dir',");
                    w.write("name: '" + dirName + "',");
                    w.write("link: '" + pathName + "'");
                    w.write("}");
                } else {
                    w.write("{");
                    w.write("type: 'file',");
                    w.write("name: '" + childName + "',");
                    w.write("link: '" + pathName + "'");
                    w.write("}");
                }
                if (i >= entries.length - 1) continue;
                w.write(",");
            }
            w.write("]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverFileRaw(HttpServletResponse resp, FileEntry fileEntry) throws IOException {
        long size = fileEntry.getSize();
        if (size >= 0L && size < Integer.MAX_VALUE) {
            resp.setContentLength((int)size);
        }
        resp.setContentType(this.getServletContext().getMimeType(fileEntry.getName()));
        InputStream source = null;
        ServletOutputStream destination = null;
        try {
            source = fileEntry.getInputStream();
            destination = resp.getOutputStream();
            IOUtils.copy((InputStream)source, (OutputStream)destination);
        }
        finally {
            IOUtils.closeQuietly((InputStream)source);
            IOUtils.closeQuietly((OutputStream)destination);
        }
    }

    private void serveDirectoryAsHTML(HttpServletResponse resp, String path, String context, DirectoryEntry dirEntry, Entry[] entries) throws IOException {
        resp.setContentType("text/html");
        PrintWriter w = resp.getWriter();
        w.println("<html>");
        w.println("  <head>");
        w.println("    <title>Index of " + context + path + "</title>");
        w.println("    <meta http-equiv=\"Content-Type\" repository=\"text/html; charset=utf-8\"/>");
        w.println("</head>");
        w.println("<body>");
        w.println("<h1>Index of " + context + path + "</h1>");
        w.println("  <hr/>");
        w.write("<pre>");
        if (dirEntry.getParent() != null) {
            w.println("<a href='../'>../</a>");
        }
        SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy hh:mm");
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                String childName = entries[i].getName();
                boolean directory = entries[i] instanceof DirectoryEntry;
                if (directory) {
                    String dirName = childName + "/";
                    w.write("<a href=\"./" + Utils.urlEncodePathSegment(childName) + "/\">" + FileSystemServlet.formatName(dirName) + "</a>" + StringUtils.repeat((String)" ", (int)Math.max(0, 50 - dirName.length())));
                } else {
                    w.write("<a href=\"./" + Utils.urlEncodePathSegment(childName) + "\">" + FileSystemServlet.formatName(childName) + "</a>" + StringUtils.repeat((String)" ", (int)Math.max(0, 50 - childName.length())));
                }
                long timestamp = 0L;
                try {
                    timestamp = entries[i].getLastModified();
                }
                catch (IOException e) {
                    // empty catch block
                }
                w.write(" ");
                w.write(format.format(timestamp != -1L ? new Date(timestamp) : new Date()));
                if (directory) {
                    w.println(StringUtils.leftPad((String)"-", (int)20));
                    continue;
                }
                if (entries[i] instanceof FileEntry) {
                    FileEntry fileEntry = (FileEntry)entries[i];
                    try {
                        long size = fileEntry.getSize();
                        if (size >= 0L) {
                            w.println(StringUtils.leftPad((String)Long.toString(size), (int)20));
                            continue;
                        }
                        w.println(StringUtils.leftPad((String)"-", (int)20));
                    }
                    catch (IOException e) {
                        w.println(StringUtils.leftPad((String)"-", (int)20));
                    }
                    continue;
                }
                w.println(StringUtils.leftPad((String)"-", (int)20));
            }
        }
        w.write("</pre>");
        w.println("  <hr/>");
        w.println("</body>");
        w.println("</html>");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String httpMethodOverride = req.getHeader("X-HTTP-Method-Override");
        if ("PUT".equals(httpMethodOverride)) {
            this._doPut(req, resp);
        } else if ("DELETE".equals(httpMethodOverride)) {
            this._doDelete(req, resp);
        } else {
            resp.sendError(405);
        }
    }

    protected void _doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        boolean outcome = false;
        outcome = path.endsWith("/") ? this.createFile(req, resp, path, true) : this.createFile(req, resp, path, false);
        if (!outcome) {
            resp.sendError(405);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean createFile(HttpServletRequest req, HttpServletResponse resp, String path, boolean isDirectory) throws IOException {
        block8: {
            block7: {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((parts = path.split("/")).length == 0) {
                    resp.sendError(405);
                    return true;
                }
                name = parts[parts.length - 1];
                if (StringUtils.isEmpty((String)name)) {
                    resp.sendError(405);
                    return true;
                }
                parent = this.fileSystem.getRoot();
                for (i = 0; i < parts.length - 1; ++i) {
                    parent = new DefaultDirectoryEntry(this.fileSystem, parent, parts[i]);
                }
                inputStream = null;
                try {
                    if (!isDirectory) ** GOTO lbl29
                    dir = this.fileSystem.mkdir(parent, name);
                    if (dir == null) break block7;
                    resp.setStatus(200);
                    var10_12 = true;
                }
                catch (Throwable var11_14) {
                    IOUtils.closeQuietly(inputStream);
                    throw var11_14;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                return var10_12;
            }
            break block8;
lbl29:
            // 1 sources

            inputStream = req.getInputStream();
            put = this.fileSystem.put(parent, name, (InputStream)inputStream);
            if (put == null) break block8;
            resp.setStatus(200);
            var10_13 = true;
            IOUtils.closeQuietly((InputStream)inputStream);
            return var10_13;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return false;
    }

    private void createDirectory(HttpServletResponse resp, String path) throws IOException {
        String[] parts = path.split("/");
        resp.sendError(405);
    }

    protected void _doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
            String context = req.getContextPath();
        } else {
            String context = req.getContextPath() + req.getServletPath();
        }
        Entry entry = this.fileSystem.get(path);
        if (entry == null) {
            resp.setStatus(200);
            return;
        }
        try {
            this.fileSystem.remove(entry);
            resp.setStatus(200);
        }
        catch (UnsupportedOperationException e) {
            resp.sendError(405);
        }
    }

    private static String formatName(String name) {
        if (name.length() < 50) {
            return name;
        }
        return name.substring(0, 49) + ">";
    }
}

