/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.digest;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.mrm.api.BaseFileSystem;
import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.impl.GenerateOnErrorFileEntry;
import org.codehaus.mojo.mrm.impl.LinkFileEntry;
import org.codehaus.mojo.mrm.impl.digest.DigestFileEntryFactory;
import org.codehaus.mojo.mrm.impl.digest.MD5DigestFileEntry;
import org.codehaus.mojo.mrm.impl.digest.SHA1DigestFileEntry;

public class AutoDigestFileSystem
extends BaseFileSystem {
    private final FileSystem backing;
    private final Map<String, DigestFileEntryFactory> digestFactories;

    public AutoDigestFileSystem(FileSystem backing) {
        this(backing, new DigestFileEntryFactory[]{new MD5DigestFileEntry.Factory(), new SHA1DigestFileEntry.Factory()});
    }

    public AutoDigestFileSystem(FileSystem backing, DigestFileEntryFactory[] digestFactories) {
        this.backing = backing;
        HashMap<String, DigestFileEntryFactory> map = new HashMap<String, DigestFileEntryFactory>(digestFactories.length);
        for (DigestFileEntryFactory factory : digestFactories) {
            map.put(factory.getType(), factory);
        }
        this.digestFactories = Collections.unmodifiableMap(map);
    }

    public Entry[] listEntries(DirectoryEntry directory) {
        TreeMap<String, LinkFileEntry> result = new TreeMap<String, LinkFileEntry>();
        HashMap<String, FileEntry> missing = new HashMap<String, FileEntry>();
        HashSet<String> present = new HashSet<String>();
        Entry[] entries = this.backing.listEntries(DefaultDirectoryEntry.equivalent((FileSystem)this.backing, (DirectoryEntry)directory));
        for (Entry entry : entries) {
            String name = entry.getName();
            if (entry instanceof FileEntry) {
                for (String type : this.digestFactories.keySet()) {
                    if (name.endsWith(type)) {
                        present.add(name);
                        continue;
                    }
                    missing.put(name + type, (FileEntry)entry);
                }
                result.put(name, new LinkFileEntry((FileSystem)this, directory, (FileEntry)entry));
                continue;
            }
            if (!(entry instanceof DirectoryEntry)) continue;
            result.put(name, (LinkFileEntry)DefaultDirectoryEntry.equivalent((FileSystem)this, (DirectoryEntry)((DirectoryEntry)entry)));
        }
        missing.keySet().removeAll(present);
        for (Map.Entry entry : missing.entrySet()) {
            String name = (String)entry.getKey();
            FileEntry fileEntry = (FileEntry)entry.getValue();
            for (DigestFileEntryFactory factory : this.digestFactories.values()) {
                if (!name.endsWith(factory.getType())) continue;
                result.put(name, (LinkFileEntry)factory.create((FileSystem)this, directory, fileEntry));
            }
        }
        return result.values().toArray(new Entry[result.size()]);
    }

    public long getLastModified(DirectoryEntry entry) throws IOException {
        return this.backing.getLastModified(DefaultDirectoryEntry.equivalent((FileSystem)this.backing, (DirectoryEntry)entry));
    }

    public Entry get(String path) {
        Entry entry = this.backing.get(path);
        if (entry == null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.length() == 0) {
                return this.getRoot();
            }
            String[] parts = path.split("/");
            if (parts.length == 0) {
                return this.getRoot();
            }
            DirectoryEntry parent = this.getRoot();
            for (int i = 0; i < parts.length - 1; ++i) {
                parent = new DefaultDirectoryEntry((FileSystem)this, parent, parts[i]);
            }
            String name = parts[parts.length - 1];
            for (DigestFileEntryFactory factory : this.digestFactories.values()) {
                if (!name.endsWith(factory.getType())) continue;
                Entry shadow = this.backing.get(parent.toPath() + "/" + StringUtils.removeEnd((String)name, (String)factory.getType()));
                return factory.create((FileSystem)this, parent, (FileEntry)shadow);
            }
            return this.get(parent, name);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() == 0) {
            return this.getRoot();
        }
        String[] parts = path.split("/");
        if (parts.length == 0) {
            return this.getRoot();
        }
        DirectoryEntry parent = this.getRoot();
        for (int i = 0; i < parts.length - 1; ++i) {
            parent = new DefaultDirectoryEntry((FileSystem)this, parent, parts[i]);
        }
        if (entry instanceof FileEntry) {
            for (DigestFileEntryFactory factory : this.digestFactories.values()) {
                if (!entry.getName().endsWith(factory.getType())) continue;
                Entry shadow = this.backing.get(parent.toPath() + "/" + StringUtils.removeEnd((String)entry.getName(), (String)factory.getType()));
                return new GenerateOnErrorFileEntry((FileSystem)this, parent, (FileEntry)entry, factory.create((FileSystem)this, parent, (FileEntry)shadow));
            }
            return new LinkFileEntry((FileSystem)this, parent, (FileEntry)entry);
        }
        if (entry instanceof DirectoryEntry) {
            for (DigestFileEntryFactory factory : this.digestFactories.values()) {
                if (!entry.getName().endsWith(factory.getType())) continue;
                Entry shadow = this.backing.get(parent.toPath() + "/" + StringUtils.removeEnd((String)entry.getName(), (String)factory.getType()));
                return factory.create((FileSystem)this, parent, (FileEntry)shadow);
            }
            return new DefaultDirectoryEntry((FileSystem)this, parent, entry.getName());
        }
        return null;
    }
}

