/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.codehaus.mojo.mrm.api.maven.ArtifactStore;
import org.codehaus.mojo.mrm.impl.maven.MockArtifactStore;
import org.codehaus.mojo.mrm.plugin.ArtifactStoreFactory;
import org.codehaus.mojo.mrm.plugin.FactoryHelper;
import org.codehaus.mojo.mrm.plugin.FactoryHelperRequired;

public class MockRepo
implements ArtifactStoreFactory,
FactoryHelperRequired {
    private FactoryHelper factoryHelper;
    private File source;
    private File cloneTo;
    private boolean cloneClean;
    private boolean lazyArchiver;

    public ArtifactStore newInstance() {
        if (this.factoryHelper == null) {
            throw new IllegalStateException("FactoryHelper has not been set");
        }
        if (this.source == null) {
            throw new IllegalStateException("Must provide the 'source' of the mock repository");
        }
        File root = this.source;
        if (this.cloneTo != null) {
            if (!this.cloneTo.mkdirs() && this.cloneClean) {
                try {
                    FileUtils.cleanDirectory((File)this.cloneTo);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to clean directory: " + e.getMessage());
                }
            }
            try {
                FileUtils.copyDirectory((File)this.source, (File)this.cloneTo);
                root = this.cloneTo;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to copy directory: " + e.getMessage());
            }
        }
        return new MockArtifactStore(this.factoryHelper.getLog(), root, this.lazyArchiver);
    }

    public void setFactoryHelper(FactoryHelper factoryHelper) {
        this.factoryHelper = factoryHelper;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Mock content (source: ").append(this.source);
        sb.append(')');
        return sb.toString();
    }
}

