/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Plugin;
import org.codehaus.mojo.mrm.api.maven.ArchetypeCatalogNotFoundException;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MemoryArtifactStore
extends BaseArtifactStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Map<String, Map<String, Map<Artifact, Content>>>> contents = new HashMap<String, Map<String, Map<String, Map<Artifact, Content>>>>();
    private Content archetypeCatalog;
    private static final Comparator<String> INSTANCE = new VersionComparator();

    public synchronized Set<String> getGroupIds(String parentGroupId) {
        TreeSet<String> result = new TreeSet<String>();
        if (StringUtils.isEmpty((String)parentGroupId)) {
            for (String groupId : this.contents.keySet()) {
                int index = groupId.indexOf(46);
                result.add(index == -1 ? groupId : groupId.substring(0, index));
            }
        } else {
            String prefix = parentGroupId + '.';
            int start = prefix.length();
            for (String groupId : this.contents.keySet()) {
                if (!groupId.startsWith(prefix)) continue;
                int index = groupId.indexOf(46, start);
                result.add(index == -1 ? groupId.substring(start) : groupId.substring(start, index));
            }
        }
        return result;
    }

    public synchronized Set<String> getArtifactIds(String groupId) {
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(groupId);
        return artifactMap == null ? Collections.emptySet() : new TreeSet<String>(artifactMap.keySet());
    }

    public synchronized Set<String> getVersions(String groupId, String artifactId) {
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(groupId);
        Map<String, Map<Artifact, Content>> versionMap = artifactMap == null ? null : artifactMap.get(artifactId);
        return versionMap == null ? Collections.emptySet() : new TreeSet<String>(versionMap.keySet());
    }

    public synchronized Set<Artifact> getArtifacts(String groupId, String artifactId, String version) {
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(groupId);
        Map<String, Map<Artifact, Content>> versionMap = artifactMap == null ? null : artifactMap.get(artifactId);
        Map<Artifact, Content> filesMap = versionMap == null ? null : versionMap.get(version);
        return filesMap == null ? Collections.emptySet() : new HashSet<Artifact>(filesMap.keySet());
    }

    public synchronized long getLastModified(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Content content;
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(artifact.getGroupId());
        Map<String, Map<Artifact, Content>> versionMap = artifactMap == null ? null : artifactMap.get(artifact.getArtifactId());
        Map<Artifact, Content> filesMap = versionMap == null ? null : versionMap.get(artifact.getVersion());
        Content content2 = content = filesMap == null ? null : filesMap.get(artifact);
        if (content == null) {
            if (artifact.isSnapshot() && artifact.getTimestamp() == null && filesMap != null) {
                Artifact best = null;
                for (Map.Entry<Artifact, Content> entry : filesMap.entrySet()) {
                    Artifact a = entry.getKey();
                    if (!artifact.equalSnapshots(a) || best != null && best.compareTo(a) >= 0) continue;
                    best = a;
                    content = entry.getValue();
                }
                if (content == null) {
                    throw new ArtifactNotFoundException(artifact);
                }
            } else {
                throw new ArtifactNotFoundException(artifact);
            }
        }
        return content.getLastModified();
    }

    public synchronized long getSize(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Content content;
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(artifact.getGroupId());
        Map<String, Map<Artifact, Content>> versionMap = artifactMap == null ? null : artifactMap.get(artifact.getArtifactId());
        Map<Artifact, Content> filesMap = versionMap == null ? null : versionMap.get(artifact.getVersion());
        Content content2 = content = filesMap == null ? null : filesMap.get(artifact);
        if (content == null) {
            if (artifact.isSnapshot() && artifact.getTimestamp() == null && filesMap != null) {
                Artifact best = null;
                for (Map.Entry<Artifact, Content> entry : filesMap.entrySet()) {
                    Artifact a = entry.getKey();
                    if (!artifact.equalSnapshots(a) || best != null && best.compareTo(a) >= 0) continue;
                    best = a;
                    content = entry.getValue();
                }
                if (content == null) {
                    throw new ArtifactNotFoundException(artifact);
                }
            } else {
                throw new ArtifactNotFoundException(artifact);
            }
        }
        return content.getBytes().length;
    }

    public synchronized InputStream get(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Content content;
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(artifact.getGroupId());
        Map<String, Map<Artifact, Content>> versionMap = artifactMap == null ? null : artifactMap.get(artifact.getArtifactId());
        Map<Artifact, Content> filesMap = versionMap == null ? null : versionMap.get(artifact.getVersion());
        Content content2 = content = filesMap == null ? null : filesMap.get(artifact);
        if (content == null) {
            if (artifact.isSnapshot() && artifact.getTimestamp() == null && filesMap != null) {
                Artifact best = null;
                for (Map.Entry<Artifact, Content> entry : filesMap.entrySet()) {
                    Artifact a = entry.getKey();
                    if (!artifact.equalSnapshots(a) || best != null && best.compareTo(a) >= 0) continue;
                    best = a;
                    content = entry.getValue();
                }
                if (content == null) {
                    throw new ArtifactNotFoundException(artifact);
                }
            } else {
                throw new ArtifactNotFoundException(artifact);
            }
        }
        return new ByteArrayInputStream(content.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void set(Artifact artifact, InputStream content) throws IOException {
        Map artifactMap = this.contents.computeIfAbsent(artifact.getGroupId(), k -> new HashMap());
        Map versionMap = artifactMap.computeIfAbsent(artifact.getArtifactId(), k -> new HashMap());
        Map filesMap = versionMap.computeIfAbsent(artifact.getVersion(), k -> new HashMap());
        try {
            filesMap.put(artifact, new Content(IOUtils.toByteArray((InputStream)content)));
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized Metadata getMetadata(String path) throws IOException, MetadataNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized long getMetadataLastModified(String path) throws IOException, MetadataNotFoundException {
        String string;
        String artifactId;
        int index;
        boolean haveResult = false;
        long result = 0L;
        String groupId = (path = StringUtils.stripEnd((String)StringUtils.stripStart((String)path, (String)"/"), (String)"/")).replace('/', '.');
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(groupId);
        if (artifactMap != null) {
            for (Map<String, Map<Artifact, Content>> versionMap : artifactMap.values()) {
                for (Map<Artifact, Content> map : versionMap.values()) {
                    for (Content content : map.values()) {
                        haveResult = true;
                        result = Math.max(result, content.getLastModified());
                    }
                }
            }
        }
        groupId = (index = path.lastIndexOf(47)) == -1 ? groupId : groupId.substring(0, index).replace('/', '.');
        String string2 = artifactId = index == -1 ? null : path.substring(index + 1);
        if (artifactId != null) {
            Map<String, Map<Artifact, Content>> versionMap;
            artifactMap = this.contents.get(groupId);
            Map<String, Map<Artifact, Content>> map = versionMap = artifactMap == null ? null : artifactMap.get(artifactId);
            if (versionMap != null) {
                for (Map<Artifact, Content> map2 : versionMap.values()) {
                    for (Content content : map2.values()) {
                        haveResult = true;
                        result = Math.max(result, content.getLastModified());
                    }
                }
            }
        }
        int index2 = index == -1 ? -1 : path.lastIndexOf(47, index - 1);
        groupId = index2 == -1 ? groupId : groupId.substring(0, index2).replace('/', '.');
        artifactId = index2 == -1 ? artifactId : path.substring(index2 + 1, index);
        String string3 = string = index2 == -1 ? null : path.substring(index + 1);
        if (string != null && string.endsWith("-SNAPSHOT")) {
            Map<Artifact, Content> map;
            artifactMap = this.contents.get(groupId);
            Map<String, Map<Artifact, Content>> map3 = artifactMap == null ? null : artifactMap.get(artifactId);
            Map<Artifact, Content> map4 = map = map3 == null ? null : map3.get(string);
            if (map != null) {
                for (Content content : map.values()) {
                    haveResult = true;
                    result = Math.max(result, content.getLastModified());
                }
            }
        }
        if (haveResult) {
            return result;
        }
        throw new MetadataNotFoundException(path);
    }

    public synchronized void setArchetypeCatalog(InputStream content) throws IOException {
        this.archetypeCatalog = new Content(IOUtils.toByteArray((InputStream)content));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ArchetypeCatalog getArchetypeCatalog() throws IOException, ArchetypeCatalogNotFoundException {
        if (this.archetypeCatalog == null) throw new ArchetypeCatalogNotFoundException();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(this.archetypeCatalog.getBytes());){
            ArchetypeCatalog archetypeCatalog = new ArchetypeCatalogXpp3Reader().read((InputStream)inputStream);
            return archetypeCatalog;
        }
        catch (XmlPullParserException e) {
            throw new ArchetypeCatalogNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized long getArchetypeCatalogLastModified() throws ArchetypeCatalogNotFoundException {
        if (this.archetypeCatalog != null) {
            return this.archetypeCatalog.getLastModified();
        }
        throw new ArchetypeCatalogNotFoundException();
    }

    private boolean setPluginGoalPrefixFromConfiguration(org.apache.maven.artifact.repository.metadata.Plugin plugin, List<Plugin> pluginConfigs) {
        for (Plugin def : pluginConfigs) {
            Xpp3Dom goalPrefix;
            if (def.getGroupId() != null && !StringUtils.equals((String)"org.apache.maven.plugins", (String)def.getGroupId()) || !StringUtils.equals((String)"maven-plugin-plugin", (String)def.getArtifactId())) continue;
            Xpp3Dom configuration = (Xpp3Dom)def.getConfiguration();
            if (configuration == null || (goalPrefix = configuration.getChild("goalPrefix")) == null) break;
            plugin.setPrefix(goalPrefix.getValue());
            return true;
        }
        return false;
    }

    private static class Maven3 {
        private Maven3() {
        }

        private static void addSnapshotVersion(List<SnapshotVersion> snapshotVersions, Artifact artifact, String lastUpdatedTime) {
            try {
                SnapshotVersion snapshotVersion = new SnapshotVersion();
                snapshotVersion.setExtension(artifact.getType());
                snapshotVersion.setClassifier(artifact.getClassifier() == null ? "" : artifact.getClassifier());
                snapshotVersion.setVersion(artifact.getTimestampVersion());
                snapshotVersion.setUpdated(lastUpdatedTime);
                snapshotVersions.add(snapshotVersion);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }

        private static void addSnapshotVersions(Versioning versioning, List<SnapshotVersion> snapshotVersions) {
            try {
                for (SnapshotVersion snapshotVersion : snapshotVersions) {
                    versioning.addSnapshotVersion(snapshotVersion);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }

        static /* synthetic */ void access$100(List x0, Artifact x1, String x2) {
            Maven3.addSnapshotVersion(x0, x1, x2);
        }

        static /* synthetic */ void access$200(Versioning x0, List x1) {
            Maven3.addSnapshotVersions(x0, x1);
        }
    }

    private static class Content
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long lastModified = System.currentTimeMillis();
        private final byte[] bytes;

        private Content(byte[] bytes) {
            this.bytes = bytes;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }

    private static class VersionComparator
    implements Comparator<String> {
        private VersionComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            DefaultArtifactVersion v1 = new DefaultArtifactVersion(o1);
            DefaultArtifactVersion v2 = new DefaultArtifactVersion(o2);
            return v1.compareTo((Object)v2);
        }
    }
}

