/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.codehaus.mojo.mrm.api.maven.ArchetypeCatalogNotFoundException;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.ArtifactStore;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;

public class CompositeArtifactStore
extends BaseArtifactStore {
    private final ArtifactStore[] stores;

    public CompositeArtifactStore(ArtifactStore[] stores) {
        this.stores = stores;
    }

    public Set<String> getGroupIds(String parentGroupId) {
        TreeSet<String> result = new TreeSet<String>();
        for (ArtifactStore store : this.stores) {
            Set groupIds = store.getGroupIds(parentGroupId);
            if (groupIds == null) continue;
            result.addAll(groupIds);
        }
        return result;
    }

    public Set<String> getArtifactIds(String groupId) {
        TreeSet<String> result = new TreeSet<String>();
        for (ArtifactStore store : this.stores) {
            Set artifactIds = store.getArtifactIds(groupId);
            if (artifactIds == null) continue;
            result.addAll(artifactIds);
        }
        return result;
    }

    public Set<String> getVersions(String groupId, String artifactId) {
        TreeSet<String> result = new TreeSet<String>();
        for (ArtifactStore store : this.stores) {
            Set versions = store.getVersions(groupId, artifactId);
            if (versions == null) continue;
            result.addAll(versions);
        }
        return result;
    }

    public Set<Artifact> getArtifacts(String groupId, String artifactId, String version) {
        TreeSet<Artifact> result = new TreeSet<Artifact>();
        for (ArtifactStore store : this.stores) {
            Set artifacts = store.getArtifacts(groupId, artifactId, version);
            if (artifacts == null) continue;
            result.addAll(artifacts);
        }
        return result;
    }

    public long getLastModified(Artifact artifact) throws IOException, ArtifactNotFoundException {
        for (ArtifactStore store : this.stores) {
            try {
                return store.getLastModified(artifact);
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
            }
        }
        throw new ArtifactNotFoundException(artifact);
    }

    public long getSize(Artifact artifact) throws IOException, ArtifactNotFoundException {
        for (ArtifactStore store : this.stores) {
            try {
                return store.getSize(artifact);
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
            }
        }
        throw new ArtifactNotFoundException(artifact);
    }

    public InputStream get(Artifact artifact) throws IOException, ArtifactNotFoundException {
        for (ArtifactStore store : this.stores) {
            try {
                return store.get(artifact);
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
            }
        }
        throw new ArtifactNotFoundException(artifact);
    }

    public void set(Artifact artifact, InputStream content) throws IOException {
        throw new IOException("Read-only store");
    }

    public Metadata getMetadata(String path) throws IOException, MetadataNotFoundException {
        boolean found = false;
        Metadata result = new Metadata();
        HashSet<String> pluginArtifactIds = new HashSet<String>();
        HashSet<String> snapshotVersions = new HashSet<String>();
        for (ArtifactStore store : this.stores) {
            try {
                Metadata partial = store.getMetadata(path);
                if (StringUtils.isEmpty((String)result.getArtifactId()) && !StringUtils.isEmpty((String)partial.getArtifactId())) {
                    result.setArtifactId(partial.getArtifactId());
                    found = true;
                }
                if (StringUtils.isEmpty((String)result.getGroupId()) && !StringUtils.isEmpty((String)partial.getGroupId())) {
                    result.setGroupId(partial.getGroupId());
                    found = true;
                }
                if (StringUtils.isEmpty((String)result.getVersion()) && !StringUtils.isEmpty((String)partial.getVersion())) {
                    result.setVersion(partial.getVersion());
                    found = true;
                }
                if (partial.getPlugins() != null && !partial.getPlugins().isEmpty()) {
                    for (Plugin plugin : partial.getPlugins()) {
                        if (pluginArtifactIds.contains(plugin.getArtifactId())) continue;
                        result.addPlugin(plugin);
                        pluginArtifactIds.add(plugin.getArtifactId());
                    }
                    found = true;
                }
                if (partial.getVersioning() == null) continue;
                Versioning rVers = result.getVersioning();
                if (rVers == null) {
                    rVers = new Versioning();
                }
                Versioning pVers = partial.getVersioning();
                String rLU = found ? rVers.getLastUpdated() : null;
                String pLU = pVers.getLastUpdated();
                if (pLU != null && (rLU == null || rLU.compareTo(pLU) < 0)) {
                    if (!StringUtils.isEmpty((String)pVers.getLatest())) {
                        rVers.setLatest(pVers.getLatest());
                    }
                    if (!StringUtils.isEmpty((String)pVers.getRelease())) {
                        rVers.setRelease(pVers.getRelease());
                    }
                    rVers.setLastUpdated(pVers.getLastUpdated());
                }
                for (String version : pVers.getVersions()) {
                    if (rVers.getVersions().contains(version)) continue;
                    rVers.addVersion(version);
                }
                if (pVers.getSnapshot() != null && (rVers.getSnapshot() == null || pVers.getSnapshot().getBuildNumber() > rVers.getSnapshot().getBuildNumber())) {
                    Snapshot snapshot = new Snapshot();
                    snapshot.setBuildNumber(pVers.getSnapshot().getBuildNumber());
                    snapshot.setTimestamp(pVers.getSnapshot().getTimestamp());
                    rVers.setSnapshot(snapshot);
                }
                try {
                    if (pVers.getSnapshotVersions() != null && !pVers.getSnapshotVersions().isEmpty()) {
                        for (SnapshotVersion snapshotVersion : pVers.getSnapshotVersions()) {
                            String key = snapshotVersion.getVersion() + "-" + snapshotVersion.getClassifier() + "." + snapshotVersion.getExtension();
                            if (snapshotVersions.contains(key)) continue;
                            rVers.addSnapshotVersion(snapshotVersion);
                            snapshotVersions.add(key);
                        }
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                result.setVersioning(rVers);
                found = true;
            }
            catch (MetadataNotFoundException metadataNotFoundException) {
                // empty catch block
            }
        }
        if (!found) {
            throw new MetadataNotFoundException(path);
        }
        return result;
    }

    public long getMetadataLastModified(String path) throws IOException, MetadataNotFoundException {
        boolean found = false;
        long lastModified = 0L;
        for (ArtifactStore store : this.stores) {
            try {
                if (!found) {
                    lastModified = store.getMetadataLastModified(path);
                    found = true;
                    continue;
                }
                lastModified = Math.max(lastModified, store.getMetadataLastModified(path));
            }
            catch (MetadataNotFoundException metadataNotFoundException) {
                // empty catch block
            }
        }
        if (!found) {
            throw new MetadataNotFoundException(path);
        }
        return lastModified;
    }

    public ArchetypeCatalog getArchetypeCatalog() throws IOException, ArchetypeCatalogNotFoundException {
        boolean found = false;
        ArchetypeCatalog result = new ArchetypeCatalog();
        for (ArtifactStore store : this.stores) {
            try {
                ArchetypeCatalog partial = store.getArchetypeCatalog();
                result.getArchetypes().addAll(partial.getArchetypes());
                found = true;
            }
            catch (ArchetypeCatalogNotFoundException archetypeCatalogNotFoundException) {
                // empty catch block
            }
        }
        if (!found) {
            throw new ArchetypeCatalogNotFoundException();
        }
        return result;
    }

    public long getArchetypeCatalogLastModified() throws IOException, ArchetypeCatalogNotFoundException {
        boolean found = false;
        long lastModified = 0L;
        for (ArtifactStore store : this.stores) {
            try {
                if (!found) {
                    lastModified = store.getArchetypeCatalogLastModified();
                    found = true;
                    continue;
                }
                lastModified = Math.max(lastModified, store.getArchetypeCatalogLastModified());
            }
            catch (ArchetypeCatalogNotFoundException archetypeCatalogNotFoundException) {
                // empty catch block
            }
        }
        if (!found) {
            throw new ArchetypeCatalogNotFoundException();
        }
        return lastModified;
    }
}

