/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.mrm.api.maven.ArchetypeCatalogNotFoundException;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;
import org.codehaus.mojo.mrm.impl.Utils;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MockArtifactStore
extends BaseArtifactStore {
    private final Log log;
    private final boolean lazyArchiver;
    public static final String[] POM_EXTENSIONS = new String[]{"pom"};
    private Map<String, Map<String, Map<String, Map<Artifact, Content>>>> contents = new HashMap<String, Map<String, Map<String, Map<Artifact, Content>>>>();
    private Content archetypeCatalog;
    private static final Comparator<String> INSTANCE = new VersionComparator();

    public MockArtifactStore(File root) {
        this(null, root);
    }

    public MockArtifactStore(Log log, File root) {
        this(log, root, true);
    }

    public MockArtifactStore(Log log, File root, boolean lazyArchiver) {
        this.log = log;
        this.lazyArchiver = lazyArchiver;
        if (root.isDirectory()) {
            MavenXpp3Reader pomReader = new MavenXpp3Reader();
            Collection poms = org.apache.commons.io.FileUtils.listFiles((File)root, (String[])POM_EXTENSIONS, (boolean)true);
            for (File file : poms) {
                try {
                    FileReader fileReader = new FileReader(file);
                    Throwable throwable = null;
                    try {
                        File[] classifiedFiles;
                        Model model = pomReader.read((Reader)fileReader);
                        String groupId = model.getGroupId() != null ? model.getGroupId() : model.getParent().getGroupId();
                        String version = model.getVersion() != null ? model.getVersion() : model.getParent().getVersion();
                        this.set(new Artifact(groupId, model.getArtifactId(), version, "pom"), new FileContent(file));
                        String basename = FilenameUtils.getBaseName((String)file.getName());
                        if (StringUtils.isEmpty((String)model.getPackaging()) || "jar".equals(model.getPackaging())) {
                            File mainFile = new File(file.getParentFile(), basename + ".jar");
                            Content content = mainFile.isDirectory() ? new DirectoryContent(mainFile, lazyArchiver) : new BytesContent(Utils.newEmptyJarContent());
                            this.set(new Artifact(groupId, model.getArtifactId(), version, "jar"), content);
                        } else if ("maven-plugin".equals(model.getPackaging())) {
                            this.set(new Artifact(groupId, model.getArtifactId(), version, "jar"), new BytesContent(Utils.newEmptyMavenPluginJarContent(groupId, model.getArtifactId(), version)));
                        }
                        for (File classifiedFile : classifiedFiles = file.getParentFile().listFiles((dir, name) -> FilenameUtils.getBaseName((String)name).startsWith(basename + '-'))) {
                            String type = FileUtils.extension((String)classifiedFile.getName());
                            String classifier = FilenameUtils.getBaseName((String)classifiedFile.getName()).substring(basename.length() + 1);
                            Content content = classifiedFile.isDirectory() ? new DirectoryContent(classifiedFile, lazyArchiver) : new FileContent(classifiedFile);
                            this.set(new Artifact(groupId, model.getArtifactId(), version, classifier, type), content);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileReader == null) continue;
                        if (throwable != null) {
                            try {
                                fileReader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileReader.close();
                    }
                }
                catch (IOException e) {
                    if (log == null) continue;
                    log.warn((CharSequence)("Could not read from " + file), (Throwable)e);
                }
                catch (XmlPullParserException e) {
                    if (log == null) continue;
                    log.warn((CharSequence)("Could not parse " + file), (Throwable)e);
                }
            }
            File archetypeCatalogFile = new File(root, "archetype-catalog.xml");
            if (archetypeCatalogFile.isFile()) {
                this.archetypeCatalog = new FileContent(archetypeCatalogFile);
            }
        }
    }

    public synchronized Set<String> getGroupIds(String parentGroupId) {
        TreeSet<String> result = new TreeSet<String>();
        if (StringUtils.isEmpty((String)parentGroupId)) {
            for (String groupId : this.contents.keySet()) {
                int index = groupId.indexOf(46);
                result.add(index == -1 ? groupId : groupId.substring(0, index));
            }
        } else {
            String prefix = parentGroupId + '.';
            int start = prefix.length();
            for (String groupId : this.contents.keySet()) {
                if (!groupId.startsWith(prefix)) continue;
                int index = groupId.indexOf(46, start);
                result.add(index == -1 ? groupId.substring(start) : groupId.substring(start, index));
            }
        }
        return result;
    }

    public synchronized Set<String> getArtifactIds(String groupId) {
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(groupId);
        return artifactMap == null ? Collections.emptySet() : new TreeSet<String>(artifactMap.keySet());
    }

    public synchronized Set<String> getVersions(String groupId, String artifactId) {
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(groupId);
        Map<String, Map<Artifact, Content>> versionMap = artifactMap == null ? null : artifactMap.get(artifactId);
        return versionMap == null ? Collections.emptySet() : new TreeSet<String>(versionMap.keySet());
    }

    public synchronized Set<Artifact> getArtifacts(String groupId, String artifactId, String version) {
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(groupId);
        Map<String, Map<Artifact, Content>> versionMap = artifactMap == null ? null : artifactMap.get(artifactId);
        Map<Artifact, Content> filesMap = versionMap == null ? null : versionMap.get(version);
        return filesMap == null ? Collections.emptySet() : new HashSet<Artifact>(filesMap.keySet());
    }

    public synchronized long getLastModified(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Content content;
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(artifact.getGroupId());
        Map<String, Map<Artifact, Content>> versionMap = artifactMap == null ? null : artifactMap.get(artifact.getArtifactId());
        Map<Artifact, Content> filesMap = versionMap == null ? null : versionMap.get(artifact.getVersion());
        Content content2 = content = filesMap == null ? null : filesMap.get(artifact);
        if (content == null) {
            if (artifact.isSnapshot() && artifact.getTimestamp() == null && filesMap != null) {
                Artifact best = null;
                for (Map.Entry<Artifact, Content> entry : filesMap.entrySet()) {
                    Artifact a = entry.getKey();
                    if (!artifact.equalSnapshots(a) || best != null && best.compareTo(a) >= 0) continue;
                    best = a;
                    content = entry.getValue();
                }
                if (content == null) {
                    throw new ArtifactNotFoundException(artifact);
                }
            } else {
                throw new ArtifactNotFoundException(artifact);
            }
        }
        return content.getLastModified();
    }

    public synchronized long getSize(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Content content;
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(artifact.getGroupId());
        Map<String, Map<Artifact, Content>> versionMap = artifactMap == null ? null : artifactMap.get(artifact.getArtifactId());
        Map<Artifact, Content> filesMap = versionMap == null ? null : versionMap.get(artifact.getVersion());
        Content content2 = content = filesMap == null ? null : filesMap.get(artifact);
        if (content == null) {
            if (artifact.isSnapshot() && artifact.getTimestamp() == null && filesMap != null) {
                Artifact best = null;
                for (Map.Entry<Artifact, Content> entry : filesMap.entrySet()) {
                    Artifact a = entry.getKey();
                    if (!artifact.equalSnapshots(a) || best != null && best.compareTo(a) >= 0) continue;
                    best = a;
                    content = entry.getValue();
                }
                if (content == null) {
                    throw new ArtifactNotFoundException(artifact);
                }
            } else {
                throw new ArtifactNotFoundException(artifact);
            }
        }
        return content.getLength();
    }

    public synchronized InputStream get(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Content content;
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(artifact.getGroupId());
        Map<String, Map<Artifact, Content>> versionMap = artifactMap == null ? null : artifactMap.get(artifact.getArtifactId());
        Map<Artifact, Content> filesMap = versionMap == null ? null : versionMap.get(artifact.getVersion());
        Content content2 = content = filesMap == null ? null : filesMap.get(artifact);
        if (content == null) {
            if (artifact.isSnapshot() && artifact.getTimestamp() == null && filesMap != null) {
                Artifact best = null;
                for (Map.Entry<Artifact, Content> entry : filesMap.entrySet()) {
                    Artifact a = entry.getKey();
                    if (!artifact.equalSnapshots(a) || best != null && best.compareTo(a) >= 0) continue;
                    best = a;
                    content = entry.getValue();
                }
                if (content == null) {
                    throw new ArtifactNotFoundException(artifact);
                }
            } else {
                throw new ArtifactNotFoundException(artifact);
            }
        }
        return content.getInputStream();
    }

    public synchronized void set(Artifact artifact, InputStream content) throws IOException {
        try {
            this.set(artifact, new BytesContent(IOUtils.toByteArray((InputStream)content)));
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    private synchronized void set(Artifact artifact, Content content) {
        Map artifactMap = this.contents.computeIfAbsent(artifact.getGroupId(), k -> new HashMap());
        Map versionMap = artifactMap.computeIfAbsent(artifact.getArtifactId(), k -> new HashMap());
        Map filesMap = versionMap.computeIfAbsent(artifact.getVersion(), k -> new HashMap());
        filesMap.put(artifact, content);
    }

    public synchronized Metadata getMetadata(String path) throws IOException, MetadataNotFoundException {
        String version;
        Set<String> artifactVersions;
        String artifactId;
        int index;
        Object object;
        Object versions;
        Metadata metadata = new Metadata();
        boolean foundMetadata = false;
        String groupId = (path = StringUtils.stripEnd((String)StringUtils.stripStart((String)path, (String)"/"), (String)"/")).replace('/', '.');
        Set<String> pluginArtifactIds = this.getArtifactIds(groupId);
        if (pluginArtifactIds != null) {
            ArrayList<Plugin> plugins = new ArrayList<Plugin>();
            block20: for (String artifactId2 : pluginArtifactIds) {
                Set<String> pluginVersions = this.getVersions(groupId, artifactId2);
                if (pluginVersions == null || pluginVersions.isEmpty()) continue;
                versions = pluginVersions.toArray(new String[0]);
                Arrays.sort(versions, INSTANCE);
                for (int j = ((String[])versions).length - 1; j >= 0; --j) {
                    try {
                        InputStream inputStream = this.get(new Artifact(groupId, artifactId2, versions[j], "pom"));
                        object = null;
                        try {
                            Model model = new MavenXpp3Reader().read((Reader)new XmlStreamReader(inputStream));
                            if (model == null || !"maven-plugin".equals(model.getPackaging())) continue;
                            Plugin plugin = new Plugin();
                            plugin.setArtifactId(artifactId2);
                            plugin.setName(model.getName());
                            boolean havePrefix = false;
                            Build build = model.getBuild();
                            if (build != null && build.getPlugins() != null) {
                                havePrefix = this.setPluginGoalPrefixFromConfiguration(plugin, build.getPlugins());
                            }
                            if (!havePrefix && build != null && build.getPluginManagement() != null && build.getPluginManagement().getPlugins() != null) {
                                havePrefix = this.setPluginGoalPrefixFromConfiguration(plugin, build.getPluginManagement().getPlugins());
                            }
                            if (!havePrefix && artifactId2.startsWith("maven-") && artifactId2.endsWith("-plugin")) {
                                plugin.setPrefix(StringUtils.removeStart((String)StringUtils.removeEnd((String)artifactId2, (String)"-plugin"), (String)"maven-"));
                                havePrefix = true;
                            }
                            if (!havePrefix && artifactId2.endsWith("-maven-plugin")) {
                                plugin.setPrefix(StringUtils.removeEnd((String)artifactId2, (String)"-maven-plugin"));
                                havePrefix = true;
                            }
                            if (!havePrefix) {
                                plugin.setPrefix(artifactId2);
                            }
                            plugins.add(plugin);
                            foundMetadata = true;
                            continue block20;
                        }
                        catch (Throwable model) {
                            object = model;
                            throw model;
                        }
                        finally {
                            if (inputStream == null) continue block20;
                            if (object != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                continue block20;
                            }
                            inputStream.close();
                            continue block20;
                        }
                    }
                    catch (ArtifactNotFoundException | XmlPullParserException inputStream) {
                        // empty catch block
                    }
                }
            }
            if (!plugins.isEmpty()) {
                metadata.setPlugins(plugins);
            }
        }
        groupId = ((index = path.lastIndexOf(47)) == -1 ? groupId : groupId.substring(0, index)).replace('/', '.');
        String string = artifactId = index == -1 ? null : path.substring(index + 1);
        if (artifactId != null && (artifactVersions = this.getVersions(groupId, artifactId)) != null && !artifactVersions.isEmpty()) {
            metadata.setGroupId(groupId);
            metadata.setArtifactId(artifactId);
            Versioning versioning = new Versioning();
            versions = new ArrayList<String>(artifactVersions);
            versions.sort(INSTANCE);
            long lastUpdated = 0L;
            object = versions.iterator();
            while (object.hasNext()) {
                String version2 = (String)object.next();
                try {
                    long lastModified = this.getLastModified(new Artifact(groupId, artifactId, version2, "pom"));
                    versioning.addVersion(version2);
                    if (lastModified < lastUpdated) continue;
                    lastUpdated = lastModified;
                    versioning.setLastUpdatedTimestamp(new Date(lastModified));
                    versioning.setLatest(version2);
                    if (version2.endsWith("-SNAPSHOT")) continue;
                    versioning.setRelease(version2);
                }
                catch (ArtifactNotFoundException lastModified) {}
            }
            metadata.setVersioning(versioning);
            foundMetadata = true;
        }
        int index2 = index == -1 ? -1 : path.lastIndexOf(47, index - 1);
        groupId = index2 == -1 ? groupId : groupId.substring(0, index2).replace('/', '.');
        artifactId = index2 == -1 ? artifactId : path.substring(index2 + 1, index);
        String string2 = version = index2 == -1 ? null : path.substring(index + 1);
        if (version != null && version.endsWith("-SNAPSHOT")) {
            Map<Artifact, Content> filesMap;
            Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(groupId);
            Map<String, Map<Artifact, Content>> versionMap = artifactMap == null ? null : artifactMap.get(artifactId);
            Map<Artifact, Content> map = filesMap = versionMap == null ? null : versionMap.get(version);
            if (filesMap != null) {
                ArrayList snapshotVersions = new ArrayList();
                int maxBuildNumber = 0;
                long lastUpdated = 0L;
                String timestamp = null;
                boolean found = false;
                for (Map.Entry<Artifact, Content> entry : filesMap.entrySet()) {
                    Artifact artifact = entry.getKey();
                    Content content = entry.getValue();
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss");
                    fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
                    String lastUpdatedTime = fmt.format(new Date(content.getLastModified()));
                    try {
                        Maven3.addSnapshotVersion(snapshotVersions, artifact, lastUpdatedTime);
                    }
                    catch (LinkageError linkageError) {
                        // empty catch block
                    }
                    if (!"pom".equals(artifact.getType())) continue;
                    if (artifact.getBuildNumber() != null && maxBuildNumber < artifact.getBuildNumber()) {
                        maxBuildNumber = artifact.getBuildNumber();
                        timestamp = artifact.getTimestampString();
                    } else {
                        maxBuildNumber = Math.max(1, maxBuildNumber);
                    }
                    lastUpdated = Math.max(lastUpdated, content.getLastModified());
                    found = true;
                }
                if (!snapshotVersions.isEmpty() || found) {
                    Versioning versioning = metadata.getVersioning();
                    if (versioning == null) {
                        versioning = new Versioning();
                    }
                    metadata.setGroupId(groupId);
                    metadata.setArtifactId(artifactId);
                    metadata.setVersion(version);
                    try {
                        Maven3.addSnapshotVersions(versioning, snapshotVersions);
                    }
                    catch (LinkageError entry) {
                        // empty catch block
                    }
                    if (maxBuildNumber > 0) {
                        Snapshot snapshot = new Snapshot();
                        snapshot.setBuildNumber(maxBuildNumber);
                        snapshot.setTimestamp(timestamp);
                        versioning.setSnapshot(snapshot);
                    }
                    versioning.setLastUpdatedTimestamp(new Date(lastUpdated));
                    metadata.setVersioning(versioning);
                    foundMetadata = true;
                }
            }
        }
        if (!foundMetadata) {
            throw new MetadataNotFoundException(path);
        }
        return metadata;
    }

    public synchronized long getMetadataLastModified(String path) throws IOException, MetadataNotFoundException {
        String string;
        String artifactId;
        int index;
        boolean haveResult = false;
        long result = 0L;
        String groupId = (path = StringUtils.stripEnd((String)StringUtils.stripStart((String)path, (String)"/"), (String)"/")).replace('/', '.');
        Map<String, Map<String, Map<Artifact, Content>>> artifactMap = this.contents.get(groupId);
        if (artifactMap != null) {
            for (Map<String, Map<Artifact, Content>> versionMap : artifactMap.values()) {
                for (Map<Artifact, Content> map : versionMap.values()) {
                    for (Content content : map.values()) {
                        haveResult = true;
                        result = Math.max(result, content.getLastModified());
                    }
                }
            }
        }
        groupId = (index = path.lastIndexOf(47)) == -1 ? groupId : groupId.substring(0, index).replace('/', '.');
        String string2 = artifactId = index == -1 ? null : path.substring(index + 1);
        if (artifactId != null) {
            Map<String, Map<Artifact, Content>> versionMap;
            artifactMap = this.contents.get(groupId);
            Map<String, Map<Artifact, Content>> map = versionMap = artifactMap == null ? null : artifactMap.get(artifactId);
            if (versionMap != null) {
                for (Map<Artifact, Content> map2 : versionMap.values()) {
                    for (Content content : map2.values()) {
                        haveResult = true;
                        result = Math.max(result, content.getLastModified());
                    }
                }
            }
        }
        int index2 = index == -1 ? -1 : path.lastIndexOf(47, index - 1);
        groupId = index2 == -1 ? groupId : groupId.substring(0, index2).replace('/', '.');
        artifactId = index2 == -1 ? artifactId : path.substring(index2 + 1, index);
        String string3 = string = index2 == -1 ? null : path.substring(index + 1);
        if (string != null && string.endsWith("-SNAPSHOT")) {
            Map<Artifact, Content> map;
            artifactMap = this.contents.get(groupId);
            Map<String, Map<Artifact, Content>> map3 = artifactMap == null ? null : artifactMap.get(artifactId);
            Map<Artifact, Content> map4 = map = map3 == null ? null : map3.get(string);
            if (map != null) {
                for (Content content : map.values()) {
                    haveResult = true;
                    result = Math.max(result, content.getLastModified());
                }
            }
        }
        if (haveResult) {
            return result;
        }
        throw new MetadataNotFoundException(path);
    }

    public ArchetypeCatalog getArchetypeCatalog() throws IOException, ArchetypeCatalogNotFoundException {
        block5: {
            if (this.archetypeCatalog != null) {
                ArchetypeCatalogXpp3Reader reader = new ArchetypeCatalogXpp3Reader();
                try {
                    return reader.read(this.archetypeCatalog.getInputStream());
                }
                catch (IOException e) {
                    if (this.log != null) {
                        this.log.warn((CharSequence)"Could not read from archetype-catalog.xml", (Throwable)e);
                    }
                }
                catch (XmlPullParserException e) {
                    if (this.log == null) break block5;
                    this.log.warn((CharSequence)"Could not parse archetype-catalog.xml", (Throwable)e);
                }
            }
        }
        throw new ArchetypeCatalogNotFoundException();
    }

    public long getArchetypeCatalogLastModified() throws ArchetypeCatalogNotFoundException {
        if (this.archetypeCatalog != null) {
            return this.archetypeCatalog.getLastModified();
        }
        throw new ArchetypeCatalogNotFoundException();
    }

    private boolean setPluginGoalPrefixFromConfiguration(Plugin plugin, List<org.apache.maven.model.Plugin> pluginConfigs) {
        for (org.apache.maven.model.Plugin def : pluginConfigs) {
            Xpp3Dom goalPrefix;
            if (def.getGroupId() != null && !StringUtils.equals((String)"org.apache.maven.plugins", (String)def.getGroupId()) || !StringUtils.equals((String)"maven-plugin-plugin", (String)def.getArtifactId())) continue;
            Xpp3Dom configuration = (Xpp3Dom)def.getConfiguration();
            if (configuration == null || (goalPrefix = configuration.getChild("goalPrefix")) == null) break;
            plugin.setPrefix(goalPrefix.getValue());
            return true;
        }
        return false;
    }

    private static class Maven3 {
        private Maven3() {
        }

        private static void addSnapshotVersion(List<SnapshotVersion> snapshotVersions, Artifact artifact, String lastUpdatedTime) {
            try {
                SnapshotVersion snapshotVersion = new SnapshotVersion();
                snapshotVersion.setExtension(artifact.getType());
                snapshotVersion.setClassifier(artifact.getClassifier() == null ? "" : artifact.getClassifier());
                snapshotVersion.setVersion(artifact.getTimestampVersion());
                snapshotVersion.setUpdated(lastUpdatedTime);
                snapshotVersions.add(snapshotVersion);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }

        private static void addSnapshotVersions(Versioning versioning, List<SnapshotVersion> snapshotVersions) {
            try {
                for (SnapshotVersion snapshotVersion : snapshotVersions) {
                    versioning.addSnapshotVersion(snapshotVersion);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private static class DirectoryContent
    implements Content {
        private final File directory;
        private File archivedFile;

        private DirectoryContent(File directory, boolean lazy) {
            this.directory = directory;
            if (!lazy) {
                this.createArchive();
            }
        }

        private void createArchive() {
            JarArchiver archiver = new JarArchiver();
            this.archivedFile = new File(this.directory.getParentFile(), "_" + this.directory.getName());
            archiver.setDestFile(this.archivedFile);
            archiver.addDirectory(this.directory);
            try {
                archiver.createArchive();
            }
            catch (IOException | ArchiverException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public long getLastModified() {
            if (this.archivedFile == null) {
                this.createArchive();
            }
            return this.archivedFile.lastModified();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.archivedFile == null) {
                this.createArchive();
            }
            return new FileInputStream(this.archivedFile);
        }

        @Override
        public long getLength() {
            if (this.archivedFile == null) {
                this.createArchive();
            }
            return this.archivedFile.length();
        }
    }

    private static class FileContent
    implements Content {
        private final File file;

        private FileContent(File file) {
            this.file = file;
        }

        @Override
        public long getLastModified() {
            return this.file.lastModified();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public long getLength() {
            return this.file.length();
        }
    }

    private static class BytesContent
    implements Content {
        private final long lastModified = System.currentTimeMillis();
        private final byte[] bytes;

        private BytesContent(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public long getLength() {
            return this.bytes.length;
        }
    }

    private static interface Content {
        public long getLastModified();

        public InputStream getInputStream() throws IOException;

        public long getLength();
    }

    private static class VersionComparator
    implements Comparator<String> {
        private VersionComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            DefaultArtifactVersion v1 = new DefaultArtifactVersion(o1);
            DefaultArtifactVersion v2 = new DefaultArtifactVersion(o2);
            return v1.compareTo((Object)v2);
        }
    }
}

