/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.c;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.linker.AbstractLinker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.mojo.natives.util.FileUtil;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class CLinker
extends AbstractLinker {
    protected Commandline createLinkerCommandLine(List objectFiles, LinkerConfiguration config) throws NativeBuildException {
        String linkerOutputOption;
        if (config.getExecutable() == null) {
            config.setExecutable("gcc");
        }
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        cl.setExecutable(config.getExecutable());
        if (config.getStartOptions() != null) {
            cl.addArguments(config.getStartOptions());
        }
        if ((linkerOutputOption = this.getLinkerOutputOption()).endsWith(" ")) {
            cl.createArg().setValue(linkerOutputOption.substring(0, linkerOutputOption.length() - 1));
            cl.createArg().setFile(config.getOutputFile());
        } else {
            cl.createArg().setValue(linkerOutputOption + config.getOutputFile());
        }
        if (config.isUsingLinkerResponseFile()) {
            try {
                File linkerFile = new File(config.getWorkingDirectory(), "objectsFile");
                FileWriter linkerFileWriter = new FileWriter(linkerFile, false);
                for (int i = 0; i < objectFiles.size(); ++i) {
                    File objFile = (File)objectFiles.get(i);
                    linkerFileWriter.write(objFile.getPath() + "\n");
                }
                linkerFileWriter.close();
            }
            catch (IOException error) {
                throw new NativeBuildException("Error creating linker response file", (Throwable)error);
            }
            cl.createArg().setValue("@objectsFile");
        } else {
            for (int i = 0; i < objectFiles.size(); ++i) {
                File objFile = (File)objectFiles.get(i);
                String objFilePath = FileUtil.truncatePath((String)objFile.getPath(), (String)config.getWorkingDirectory().getPath());
                cl.createArg().setValue(objFilePath);
            }
        }
        if (config.getMiddleOptions() != null) {
            cl.addArguments(config.getMiddleOptions());
        }
        this.setCommandLineForExternalLibraries(cl, config);
        if (config.getEndOptions() != null) {
            cl.addArguments(config.getEndOptions());
        }
        return cl;
    }

    protected String getLinkerOutputOption() {
        return "-o ";
    }

    protected void setCommandLineForExternalLibraries(Commandline cl, LinkerConfiguration config) throws NativeBuildException {
        String ext;
        String libFileName;
        if (config.getExternalLibFileNames().size() == 0) {
            return;
        }
        boolean hasUnixLinkage = false;
        Iterator iter = config.getExternalLibFileNames().iterator();
        while (iter.hasNext()) {
            libFileName = (String)iter.next();
            ext = FileUtils.getExtension((String)libFileName);
            if ("o".equals(ext) || "obj".equals(ext) || "lib".equals(ext) || "dylib".equals(ext)) {
                File libFile = new File(config.getExternalLibDirectory(), libFileName);
                String relativeLibFile = FileUtil.truncatePath((String)libFile.getPath(), (String)config.getWorkingDirectory().getPath());
                cl.createArg().setValue(relativeLibFile);
                continue;
            }
            if (!"a".equals(ext) && !"so".equals(ext) && !"sl".equals(ext)) continue;
            hasUnixLinkage = true;
        }
        if (hasUnixLinkage) {
            cl.createArg().setValue("-L" + config.getExternalLibDirectory());
        }
        iter = config.getExternalLibFileNames().iterator();
        while (iter.hasNext()) {
            libFileName = (String)iter.next();
            ext = FileUtils.getExtension((String)libFileName);
            if (!"a".equals(ext) && !"so".equals(ext) && !"sl".equals(ext)) continue;
            String libName = FileUtils.removeExtension((String)libFileName);
            if (libFileName.startsWith("lib")) {
                libName = libName.substring("lib".length());
            }
            cl.createArg().setValue("-l" + libName);
        }
    }
}

