/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.manager;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.natives.compiler.MessageCompiler;
import org.codehaus.mojo.natives.manager.MessageCompilerManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

@Component(role=MessageCompilerManager.class, hint="native-message-compiler-provider-manager")
public class DefaultMessageCompilerManager
extends AbstractLogEnabled
implements MessageCompilerManager,
Initializable {
    @Requirement(role=MessageCompiler.class)
    private Map providers;

    public void initialize() {
        if (this.providers == null) {
            this.providers = new HashMap();
        }
        if (this.providers.size() == 0) {
            this.getLogger().warn("No compiler providers configured.");
        }
    }

    @Override
    public MessageCompiler getMessageCompiler(String providerType) throws NoSuchNativeProviderException {
        MessageCompiler provider = (MessageCompiler)this.providers.get(providerType);
        if (provider == null) {
            throw new NoSuchNativeProviderException(providerType);
        }
        return provider;
    }
}

