/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm.repository;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Mojo(name="download", aggregator=true, requiresProject=false)
public class DownloadIndexMojo
extends AbstractMojo
implements Contextualizable {
    @Parameter(required=true, property="repositoryUrl")
    private String repositoryUrl;
    @Parameter(required=true, property="nexusIndexDirectory")
    private File nexusIndexDirectory;
    @Component
    IndexUpdater remoteIndexUpdater;
    @Component
    NexusIndexer indexer;
    PlexusContainer container;
    @Component
    WagonManager wagonManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            ArrayList creators = new ArrayList();
            creators.addAll(this.container.lookupList(IndexCreator.class));
            String indexurl = this.repositoryUrl + (!this.repositoryUrl.endsWith("/") ? "/" : "") + ".index";
            IndexingContext indexingContext = this.indexer.addIndexingContextForced("central", "central", null, this.nexusIndexDirectory, this.repositoryUrl, indexurl, creators);
            String protocol = URI.create(this.repositoryUrl).getScheme();
            ProxyInfo wagonProxy = this.wagonManager.getProxy(protocol);
            TransferListener tr = new TransferListener(){

                public void transferInitiated(TransferEvent transferEvent) {
                    DownloadIndexMojo.this.getLog().info((CharSequence)("Initiated connection to " + DownloadIndexMojo.this.repositoryUrl));
                }

                public void transferStarted(TransferEvent transferEvent) {
                    DownloadIndexMojo.this.getLog().info((CharSequence)("Started transfer of " + DownloadIndexMojo.this.repositoryUrl + "/.index/" + transferEvent.getResource().toString()));
                }

                public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
                }

                public void transferCompleted(TransferEvent transferEvent) {
                    DownloadIndexMojo.this.getLog().info((CharSequence)("Finished transfer of " + DownloadIndexMojo.this.repositoryUrl + "/.index/" + transferEvent.getResource().toString()));
                }

                public void transferError(TransferEvent transferEvent) {
                    DownloadIndexMojo.this.getLog().error((CharSequence)("Failed transfer of " + DownloadIndexMojo.this.repositoryUrl + "/.index/" + transferEvent.getResource().toString()), (Throwable)transferEvent.getException());
                }

                public void debug(String message) {
                }
            };
            Wagon wagon = (Wagon)this.container.lookup(Wagon.class, protocol);
            if (wagon instanceof HttpWagon) {
                HttpWagon httpwagon = (HttpWagon)wagon;
                Properties p = new Properties();
                p.setProperty("User-Agent", "mojo/nb-repository-plugin");
                httpwagon.setHttpHeaders(p);
            }
            WagonHelper.WagonFetcher fetcher = new WagonHelper.WagonFetcher(wagon, tr, null, wagonProxy);
            IndexUpdateRequest iur = new IndexUpdateRequest(indexingContext, (ResourceFetcher)fetcher);
            this.remoteIndexUpdater.fetchAndUpdateIndex(iur);
            this.indexer.removeIndexingContext(indexingContext, false);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Cannot download index", ex);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

