package org.codehaus.mojo.freeform.analyser;

/*
* Copyright 2001-2005 The Apache Software Foundation.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/**
 * This class is the <packaging>Analyser used to analyse MavenProjects when the
 * MavenProject's packaging is "maven-plugin".
 *
 * @author <a href="mailto:raphaelpieroni@gmail.com">Raphaël Piéroni</a>
 */
class MavenPluginAnalyser
    extends BaseAnalyser
{

    /**
     * Sets the run ant target.
     */
    protected void setTargetRun()
    {
        // ide-action-run = install
        addAntTarget( "run", "install", "-DupdateReleaseInfo=true", "Install Locally" );
    }
}
