/*
 * $Id$
 */

package org.codehaus.mojo.freeform.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class CompilationUnit.
 * 
 * @version $Revision$ $Date$
 */
public class CompilationUnit implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field packageRoot
     */
    private java.util.List packageRoot;

    /**
     * Field classpath
     */
    private java.util.List classpath;

    /**
     * Field builtTo
     */
    private String builtTo;

    /**
     * Field sourceLevel
     */
    private String sourceLevel;

    /**
     * Field unitTest
     */
    private boolean unitTest = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addClasspath
     * 
     * @param string
     */
    public void addClasspath(String string)
    {
        getClasspath().add( string );
    } //-- void addClasspath(String) 

    /**
     * Method addPackageRoot
     * 
     * @param string
     */
    public void addPackageRoot(String string)
    {
        getPackageRoot().add( string );
    } //-- void addPackageRoot(String) 

    /**
     * Method getBuiltTo
     */
    public String getBuiltTo()
    {
        return this.builtTo;
    } //-- String getBuiltTo() 

    /**
     * Method getClasspath
     */
    public java.util.List getClasspath()
    {
        if ( this.classpath == null )
        {
            this.classpath = new java.util.ArrayList();
        }
        
        return this.classpath;
    } //-- java.util.List getClasspath() 

    /**
     * Method getPackageRoot
     */
    public java.util.List getPackageRoot()
    {
        if ( this.packageRoot == null )
        {
            this.packageRoot = new java.util.ArrayList();
        }
        
        return this.packageRoot;
    } //-- java.util.List getPackageRoot() 

    /**
     * Method getSourceLevel
     */
    public String getSourceLevel()
    {
        return this.sourceLevel;
    } //-- String getSourceLevel() 

    /**
     * Method isUnitTest
     */
    public boolean isUnitTest()
    {
        return this.unitTest;
    } //-- boolean isUnitTest() 

    /**
     * Method removeClasspath
     * 
     * @param string
     */
    public void removeClasspath(String string)
    {
        getClasspath().remove( string );
    } //-- void removeClasspath(String) 

    /**
     * Method removePackageRoot
     * 
     * @param string
     */
    public void removePackageRoot(String string)
    {
        getPackageRoot().remove( string );
    } //-- void removePackageRoot(String) 

    /**
     * Method setBuiltTo
     * 
     * @param builtTo
     */
    public void setBuiltTo(String builtTo)
    {
        this.builtTo = builtTo;
    } //-- void setBuiltTo(String) 

    /**
     * Method setClasspath
     * 
     * @param classpath
     */
    public void setClasspath(java.util.List classpath)
    {
        this.classpath = classpath;
    } //-- void setClasspath(java.util.List) 

    /**
     * Method setPackageRoot
     * 
     * @param packageRoot
     */
    public void setPackageRoot(java.util.List packageRoot)
    {
        this.packageRoot = packageRoot;
    } //-- void setPackageRoot(java.util.List) 

    /**
     * Method setSourceLevel
     * 
     * @param sourceLevel
     */
    public void setSourceLevel(String sourceLevel)
    {
        this.sourceLevel = sourceLevel;
    } //-- void setSourceLevel(String) 

    /**
     * Method setUnitTest
     * 
     * @param unitTest
     */
    public void setUnitTest(boolean unitTest)
    {
        this.unitTest = unitTest;
    } //-- void setUnitTest(boolean) 

}
