/*
 * $Id$
 */

package org.codehaus.mojo.freeform.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class FreeformProject.
 * 
 * @version $Revision$ $Date$
 */
public class FreeformProject implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field useOutputDirectory
     */
    private boolean useOutputDirectory = false;

    /**
     * Field properties
     */
    private java.util.List properties;

    /**
     * Field sourceFolders
     */
    private java.util.List sourceFolders;

    /**
     * Field netbeansActions
     */
    private java.util.List netbeansActions;

    /**
     * Field viewItems
     */
    private java.util.List viewItems;

    /**
     * Field contextMenuItems
     */
    private java.util.List contextMenuItems;

    /**
     * Field subprojects
     */
    private java.util.List subprojects;

    /**
     * Field compilationUnits
     */
    private java.util.List compilationUnits;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addCompilationUnit
     * 
     * @param compilationUnit
     */
    public void addCompilationUnit(CompilationUnit compilationUnit)
    {
        getCompilationUnits().add( compilationUnit );
    } //-- void addCompilationUnit(CompilationUnit) 

    /**
     * Method addContextMenuItem
     * 
     * @param contextMenuItem
     */
    public void addContextMenuItem(ContextMenuItem contextMenuItem)
    {
        getContextMenuItems().add( contextMenuItem );
    } //-- void addContextMenuItem(ContextMenuItem) 

    /**
     * Method addNetbeansAction
     * 
     * @param netbeansAction
     */
    public void addNetbeansAction(NetbeansAction netbeansAction)
    {
        getNetbeansActions().add( netbeansAction );
    } //-- void addNetbeansAction(NetbeansAction) 

    /**
     * Method addProperty
     * 
     * @param property
     */
    public void addProperty(Property property)
    {
        getProperties().add( property );
    } //-- void addProperty(Property) 

    /**
     * Method addSourceFolder
     * 
     * @param sourceFolder
     */
    public void addSourceFolder(SourceFolder sourceFolder)
    {
        getSourceFolders().add( sourceFolder );
    } //-- void addSourceFolder(SourceFolder) 

    /**
     * Method addSubproject
     * 
     * @param subproject
     */
    public void addSubproject(Subproject subproject)
    {
        getSubprojects().add( subproject );
    } //-- void addSubproject(Subproject) 

    /**
     * Method addViewItem
     * 
     * @param viewItem
     */
    public void addViewItem(ViewItem viewItem)
    {
        getViewItems().add( viewItem );
    } //-- void addViewItem(ViewItem) 

    /**
     * Method getCompilationUnits
     */
    public java.util.List getCompilationUnits()
    {
        if ( this.compilationUnits == null )
        {
            this.compilationUnits = new java.util.ArrayList();
        }
        
        return this.compilationUnits;
    } //-- java.util.List getCompilationUnits() 

    /**
     * Method getContextMenuItems
     */
    public java.util.List getContextMenuItems()
    {
        if ( this.contextMenuItems == null )
        {
            this.contextMenuItems = new java.util.ArrayList();
        }
        
        return this.contextMenuItems;
    } //-- java.util.List getContextMenuItems() 

    /**
     * Method getName
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method getNetbeansActions
     */
    public java.util.List getNetbeansActions()
    {
        if ( this.netbeansActions == null )
        {
            this.netbeansActions = new java.util.ArrayList();
        }
        
        return this.netbeansActions;
    } //-- java.util.List getNetbeansActions() 

    /**
     * Method getProperties
     */
    public java.util.List getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.ArrayList();
        }
        
        return this.properties;
    } //-- java.util.List getProperties() 

    /**
     * Method getSourceFolders
     */
    public java.util.List getSourceFolders()
    {
        if ( this.sourceFolders == null )
        {
            this.sourceFolders = new java.util.ArrayList();
        }
        
        return this.sourceFolders;
    } //-- java.util.List getSourceFolders() 

    /**
     * Method getSubprojects
     */
    public java.util.List getSubprojects()
    {
        if ( this.subprojects == null )
        {
            this.subprojects = new java.util.ArrayList();
        }
        
        return this.subprojects;
    } //-- java.util.List getSubprojects() 

    /**
     * Method getViewItems
     */
    public java.util.List getViewItems()
    {
        if ( this.viewItems == null )
        {
            this.viewItems = new java.util.ArrayList();
        }
        
        return this.viewItems;
    } //-- java.util.List getViewItems() 

    /**
     * Method isUseOutputDirectory
     */
    public boolean isUseOutputDirectory()
    {
        return this.useOutputDirectory;
    } //-- boolean isUseOutputDirectory() 

    /**
     * Method removeCompilationUnit
     * 
     * @param compilationUnit
     */
    public void removeCompilationUnit(CompilationUnit compilationUnit)
    {
        getCompilationUnits().remove( compilationUnit );
    } //-- void removeCompilationUnit(CompilationUnit) 

    /**
     * Method removeContextMenuItem
     * 
     * @param contextMenuItem
     */
    public void removeContextMenuItem(ContextMenuItem contextMenuItem)
    {
        getContextMenuItems().remove( contextMenuItem );
    } //-- void removeContextMenuItem(ContextMenuItem) 

    /**
     * Method removeNetbeansAction
     * 
     * @param netbeansAction
     */
    public void removeNetbeansAction(NetbeansAction netbeansAction)
    {
        getNetbeansActions().remove( netbeansAction );
    } //-- void removeNetbeansAction(NetbeansAction) 

    /**
     * Method removeProperty
     * 
     * @param property
     */
    public void removeProperty(Property property)
    {
        getProperties().remove( property );
    } //-- void removeProperty(Property) 

    /**
     * Method removeSourceFolder
     * 
     * @param sourceFolder
     */
    public void removeSourceFolder(SourceFolder sourceFolder)
    {
        getSourceFolders().remove( sourceFolder );
    } //-- void removeSourceFolder(SourceFolder) 

    /**
     * Method removeSubproject
     * 
     * @param subproject
     */
    public void removeSubproject(Subproject subproject)
    {
        getSubprojects().remove( subproject );
    } //-- void removeSubproject(Subproject) 

    /**
     * Method removeViewItem
     * 
     * @param viewItem
     */
    public void removeViewItem(ViewItem viewItem)
    {
        getViewItems().remove( viewItem );
    } //-- void removeViewItem(ViewItem) 

    /**
     * Method setCompilationUnits
     * 
     * @param compilationUnits
     */
    public void setCompilationUnits(java.util.List compilationUnits)
    {
        this.compilationUnits = compilationUnits;
    } //-- void setCompilationUnits(java.util.List) 

    /**
     * Method setContextMenuItems
     * 
     * @param contextMenuItems
     */
    public void setContextMenuItems(java.util.List contextMenuItems)
    {
        this.contextMenuItems = contextMenuItems;
    } //-- void setContextMenuItems(java.util.List) 

    /**
     * Method setName
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Method setNetbeansActions
     * 
     * @param netbeansActions
     */
    public void setNetbeansActions(java.util.List netbeansActions)
    {
        this.netbeansActions = netbeansActions;
    } //-- void setNetbeansActions(java.util.List) 

    /**
     * Method setProperties
     * 
     * @param properties
     */
    public void setProperties(java.util.List properties)
    {
        this.properties = properties;
    } //-- void setProperties(java.util.List) 

    /**
     * Method setSourceFolders
     * 
     * @param sourceFolders
     */
    public void setSourceFolders(java.util.List sourceFolders)
    {
        this.sourceFolders = sourceFolders;
    } //-- void setSourceFolders(java.util.List) 

    /**
     * Method setSubprojects
     * 
     * @param subprojects
     */
    public void setSubprojects(java.util.List subprojects)
    {
        this.subprojects = subprojects;
    } //-- void setSubprojects(java.util.List) 

    /**
     * Method setUseOutputDirectory
     * 
     * @param useOutputDirectory
     */
    public void setUseOutputDirectory(boolean useOutputDirectory)
    {
        this.useOutputDirectory = useOutputDirectory;
    } //-- void setUseOutputDirectory(boolean) 

    /**
     * Method setViewItems
     * 
     * @param viewItems
     */
    public void setViewItems(java.util.List viewItems)
    {
        this.viewItems = viewItems;
    } //-- void setViewItems(java.util.List) 

}
