/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.freeform.analyser;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.freeform.FreeformPluginException;
import org.codehaus.mojo.freeform.analyser.BaseAnalyser;
import org.codehaus.mojo.freeform.analyser.JarAnalyser;
import org.codehaus.mojo.freeform.analyser.MavenPluginAnalyser;
import org.codehaus.mojo.freeform.project.AntTarget;
import org.codehaus.mojo.freeform.project.CustomisedContextMenuItem;
import org.codehaus.mojo.freeform.project.FileViewItem;
import org.codehaus.mojo.freeform.project.FolderViewItem;
import org.codehaus.mojo.freeform.project.FreeformProject;

public abstract class Analyser {
    protected ArtifactRepository localRepository;
    protected FreeformProject freeformProject;
    protected List antTargets;
    protected Log log;
    protected MavenProject mavenExecutedProject;
    protected MavenProject mavenProject;
    protected String mavenpath;

    public final void analyseProject() throws FreeformPluginException {
        this.analyseProject(false);
    }

    public final void analyseTargets() throws FreeformPluginException {
        this.analyseTargets(false);
    }

    public abstract void analyseProject(boolean var1) throws FreeformPluginException;

    public abstract void analyseTargets(boolean var1) throws FreeformPluginException;

    public static Analyser getAnalyser(MavenProject mavenProject, MavenProject executedProject, ArtifactRepository localRepository, Log log, String mavenpath) {
        BaseAnalyser analyser = null;
        analyser = mavenProject.getPackaging() != null && mavenProject.getPackaging().equalsIgnoreCase("jar") ? new JarAnalyser() : (mavenProject.getPackaging() != null && mavenProject.getPackaging().equalsIgnoreCase("maven-plugin") ? new MavenPluginAnalyser() : new JarAnalyser());
        analyser.setMavenProject(mavenProject);
        analyser.setMavenExecutedProject(executedProject);
        analyser.setLocalRepository(localRepository);
        analyser.setLog(log);
        analyser.setMavenPath(mavenpath);
        log.info((CharSequence)(analyser + " found"));
        return analyser;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setMavenExecutedProject(MavenProject executedProject) {
        this.mavenExecutedProject = executedProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public void setMavenPath(String mavenpath) {
        this.mavenpath = mavenpath;
    }

    public FreeformProject getProject() {
        return this.freeformProject;
    }

    public List getTargets() {
        return this.antTargets;
    }

    public void addAdditionalActions(List actions) throws FreeformPluginException {
        if (this.freeformProject == null) {
            this.log.error((CharSequence)"The project is not analysed");
            throw new FreeformPluginException("The project is not analysed");
        }
        Iterator iterator = actions.iterator();
        while (iterator.hasNext()) {
            String action = (String)iterator.next();
            CustomisedContextMenuItem contextMenuItem = new CustomisedContextMenuItem();
            contextMenuItem.setName(action);
            contextMenuItem.setScript("${ant.script}");
            contextMenuItem.addTarget(action);
            this.freeformProject.addContextMenuItem(contextMenuItem);
            this.log.debug((CharSequence)("action" + action + " added"));
        }
        this.log.info((CharSequence)"actions added");
    }

    public void addAdditionalFiles(List files, boolean useOutputDirectory) throws FreeformPluginException {
        if (this.freeformProject == null) {
            this.log.error((CharSequence)"The project is not analysed");
            throw new FreeformPluginException("The project is not analysed");
        }
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            String file = (String)iterator.next();
            FileViewItem viewItem = new FileViewItem();
            viewItem.setLabel(file.substring(file.lastIndexOf(47) + 1));
            viewItem.setLocation((useOutputDirectory ? "${project.directory}/" : "") + file);
            this.freeformProject.addViewItem(viewItem);
            this.log.debug((CharSequence)("viewItem" + file + " added"));
        }
        this.log.info((CharSequence)"files added");
    }

    public void addAdditionalFolders(List folders, boolean useOutputDirectory) throws FreeformPluginException {
        if (this.freeformProject == null) {
            this.log.error((CharSequence)"The project is not analysed");
            throw new FreeformPluginException("The project is not analysed");
        }
        Iterator iterator = folders.iterator();
        while (iterator.hasNext()) {
            String folder = (String)iterator.next();
            FolderViewItem viewItem = new FolderViewItem();
            viewItem.setLabel(folder);
            viewItem.setLocation((useOutputDirectory ? "${project.directory}/" : "") + folder);
            viewItem.setStyle("tree");
            this.freeformProject.addViewItem(viewItem);
            this.log.debug((CharSequence)("viewItem" + folder + " added"));
        }
        this.log.info((CharSequence)"folders added");
    }

    public void addAdditionalTargets(List targets) throws FreeformPluginException {
        if (this.antTargets == null) {
            this.log.error((CharSequence)"The targets are not analysed");
            throw new FreeformPluginException("The targets are not analysed");
        }
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            String target = (String)iterator.next();
            AntTarget antTarget = new AntTarget();
            antTarget.setName(target);
            antTarget.addGoal(target);
            this.antTargets.add(antTarget);
            this.log.debug((CharSequence)("target" + target + " added"));
        }
        this.log.info((CharSequence)"targets added");
    }

    public String toString() {
        String fullName = this.getClass().getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    protected void Analyser() {
    }

    protected void createProject(boolean useOutputDirectory) {
        this.freeformProject = new FreeformProject();
        this.freeformProject.setUseOutputDirectory(useOutputDirectory);
    }

    protected void createTargets() {
        this.antTargets = new ArrayList();
    }

    protected static String toRelative(File basedir, String absolutePath) {
        String basedirPath;
        String path = absolutePath.replace('\\', '/');
        String relative = path.startsWith(basedirPath = basedir.getAbsolutePath().replace('\\', '/')) ? path.substring(basedirPath.length() + 1) : path;
        return relative;
    }
}

