/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.freeform.writer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.freeform.FreeformPluginException;
import org.codehaus.mojo.freeform.project.AntTarget;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class MavencallWriter {
    private File mavencallFile;
    private List antTargets;
    private Log log;
    private MavenProject mavenProject;
    private boolean useOutputDirectory;

    public MavencallWriter(List antTargets, File mavencallFile, MavenProject mavenProject, boolean useOutputDirectory, Log log) {
        this.mavenProject = mavenProject;
        this.mavencallFile = mavencallFile;
        this.antTargets = antTargets;
        this.log = log;
        this.useOutputDirectory = useOutputDirectory;
    }

    public void write() throws FreeformPluginException {
        FileWriter fileWriter;
        try {
            fileWriter = new FileWriter(this.mavencallFile);
        }
        catch (IOException ioe) {
            throw new FreeformPluginException("Exception while opening file.", ioe);
        }
        PrettyPrintXMLWriter xMLWriter = new PrettyPrintXMLWriter((Writer)fileWriter);
        this.writeMavenCallXml((XMLWriter)xMLWriter);
        this.close(fileWriter);
        this.log.debug((CharSequence)("Wrote mavencall.xml for " + this.mavenProject.getName()));
        this.log.debug((CharSequence)("Use maven executable : " + this.getMavenExecutable()));
    }

    protected void writeAntTarget(AntTarget antTarget, XMLWriter writer) throws FreeformPluginException {
        writer.startElement("target");
        writer.addAttribute("name", antTarget.getName());
        if (antTarget.getComment() != null) {
            writer.addAttribute("description", antTarget.getComment());
        }
        writer.startElement("exec");
        writer.addAttribute("dir", this.useOutputDirectory ? "${project.directory}" : "${basedir}");
        writer.addAttribute("executable", this.getMavenExecutable());
        writer.startElement("arg");
        String line = "";
        Iterator optionIterator = antTarget.getOption().iterator();
        while (optionIterator.hasNext()) {
            line = line + optionIterator.next() + " ";
        }
        Iterator goalIterator = antTarget.getGoal().iterator();
        while (goalIterator.hasNext()) {
            line = line + goalIterator.next() + " ";
        }
        writer.addAttribute("line", line.trim());
        writer.endElement();
        writer.endElement();
        writer.endElement();
        this.log.debug((CharSequence)("Ant target " + antTarget.getName() + " wrote"));
    }

    private String getMavenExecutable() {
        return "${mvn.path}";
    }

    protected void writeMavenCallXml(XMLWriter writer) throws FreeformPluginException {
        boolean hasAnyTarget = this.antTargets.size() != 0;
        writer.startElement("project");
        writer.addAttribute("name", this.mavenProject.getArtifactId());
        if (hasAnyTarget) {
            writer.addAttribute("default", ((AntTarget)this.antTargets.get(0)).getName());
        }
        if (this.useOutputDirectory) {
            writer.startElement("property");
            writer.addAttribute("file", "project.properties");
            writer.endElement();
        } else {
            writer.addAttribute("basedir", "..");
        }
        Iterator iterator = this.antTargets.iterator();
        while (iterator.hasNext()) {
            this.writeAntTarget((AntTarget)iterator.next(), writer);
        }
        writer.endElement();
    }

    private void close(Writer closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            this.log.warn((CharSequence)("The closure of " + this.mavencallFile + " can not be done"), (Throwable)e);
        }
    }
}

