/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.freeform.writer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.freeform.FreeformPluginException;
import org.codehaus.mojo.freeform.project.CompilationUnit;
import org.codehaus.mojo.freeform.project.ContextMenuItem;
import org.codehaus.mojo.freeform.project.CustomisedContextMenuItem;
import org.codehaus.mojo.freeform.project.FileProperty;
import org.codehaus.mojo.freeform.project.FileViewItem;
import org.codehaus.mojo.freeform.project.FolderViewItem;
import org.codehaus.mojo.freeform.project.FreeformProject;
import org.codehaus.mojo.freeform.project.IdeContextMenuItem;
import org.codehaus.mojo.freeform.project.NamedNetbeansAction;
import org.codehaus.mojo.freeform.project.NamedProperty;
import org.codehaus.mojo.freeform.project.NetbeansAction;
import org.codehaus.mojo.freeform.project.Property;
import org.codehaus.mojo.freeform.project.SourceFolder;
import org.codehaus.mojo.freeform.project.Subproject;
import org.codehaus.mojo.freeform.project.ViewItem;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class ProjectWriter {
    private File projectFile;
    private FreeformProject freeformProject;
    private Log log;
    private MavenProject mavenProject;

    public ProjectWriter(FreeformProject freeformProject, File projectFile, MavenProject mavenProject, Log log) {
        this.mavenProject = mavenProject;
        this.projectFile = projectFile;
        this.freeformProject = freeformProject;
        this.log = log;
    }

    public void write() throws FreeformPluginException {
        FileWriter fileWriter;
        try {
            fileWriter = new FileWriter(this.projectFile);
        }
        catch (IOException ioe) {
            throw new FreeformPluginException("Exception while opening file.", ioe);
        }
        PrettyPrintXMLWriter xMLWriter = new PrettyPrintXMLWriter((Writer)fileWriter);
        this.writeProjectXml((XMLWriter)xMLWriter);
        this.close(fileWriter);
        this.log.debug((CharSequence)("Wrote project.xml for " + this.mavenProject.getName()));
    }

    protected void writeCompilationUnit(CompilationUnit compilationUnit, XMLWriter writer) throws FreeformPluginException {
        writer.startElement("compilation-unit");
        Iterator packageRoots = compilationUnit.getPackageRoot().iterator();
        while (packageRoots.hasNext()) {
            writer.startElement("package-root");
            writer.writeText((String)packageRoots.next());
            writer.endElement();
        }
        if (compilationUnit.isUnitTest()) {
            writer.startElement("unit-tests");
            writer.endElement();
        }
        writer.startElement("classpath");
        writer.addAttribute("mode", "compile");
        String classpath = "";
        Iterator iterator = compilationUnit.getClasspath().iterator();
        while (iterator.hasNext()) {
            if (classpath.length() > 0) {
                classpath = classpath + ":";
            }
            classpath = classpath + (String)iterator.next();
        }
        writer.writeText(classpath);
        writer.endElement();
        writer.startElement("built-to");
        writer.writeText(compilationUnit.getBuiltTo());
        writer.endElement();
        writer.startElement("source-level");
        writer.writeText(compilationUnit.getSourceLevel());
        writer.endElement();
        writer.endElement();
        this.log.debug((CharSequence)("compilationUnit " + compilationUnit.getPackageRoot() + " wrote"));
    }

    protected void writeCompilationUnits(List compilationUnits, XMLWriter writer) throws FreeformPluginException {
        Iterator iterator = compilationUnits.iterator();
        while (iterator.hasNext()) {
            CompilationUnit compilationUnit = (CompilationUnit)iterator.next();
            this.writeCompilationUnit(compilationUnit, writer);
        }
    }

    protected void writeContextMenuItem(ContextMenuItem contextMenuItem, XMLWriter writer) throws FreeformPluginException {
        this.log.warn((CharSequence)("contextMenuItem " + contextMenuItem + " unknown"));
    }

    protected void writeContextMenuItem(IdeContextMenuItem contextMenuItem, XMLWriter writer) throws FreeformPluginException {
        writer.startElement("ide-action");
        writer.addAttribute("name", contextMenuItem.getName());
        writer.endElement();
        this.log.debug((CharSequence)("contextMenuItem " + contextMenuItem.getName() + " wrote"));
    }

    protected void writeContextMenuItem(CustomisedContextMenuItem contextMenuItem, XMLWriter writer) throws FreeformPluginException {
        writer.startElement("action");
        writer.startElement("script");
        writer.writeText(contextMenuItem.getScript());
        writer.endElement();
        writer.startElement("label");
        writer.writeText(contextMenuItem.getName());
        writer.endElement();
        Iterator iterator = contextMenuItem.getTarget().iterator();
        while (iterator.hasNext()) {
            writer.startElement("target");
            writer.writeText((String)iterator.next());
            writer.endElement();
        }
        writer.endElement();
        this.log.debug((CharSequence)("contextMenuItem " + contextMenuItem.getName() + " wrote"));
    }

    protected void writeContextMenuItems(List contextMenuItems, XMLWriter writer) throws FreeformPluginException {
        Iterator iterator = contextMenuItems.iterator();
        while (iterator.hasNext()) {
            ContextMenuItem contextMenuItem = (ContextMenuItem)iterator.next();
            if (contextMenuItem instanceof IdeContextMenuItem) {
                this.writeContextMenuItem((IdeContextMenuItem)contextMenuItem, writer);
                continue;
            }
            if (contextMenuItem instanceof CustomisedContextMenuItem) {
                this.writeContextMenuItem((CustomisedContextMenuItem)contextMenuItem, writer);
                continue;
            }
            this.writeContextMenuItem(contextMenuItem, writer);
        }
    }

    protected void writeIdeAction(NetbeansAction netbeansAction, XMLWriter writer) throws FreeformPluginException {
        this.log.warn((CharSequence)("netbeansAction " + netbeansAction + " unknown"));
    }

    protected void writeIdeAction(NamedNetbeansAction netbeansAction, XMLWriter writer) throws FreeformPluginException {
        writer.startElement("action");
        writer.addAttribute("name", netbeansAction.getName());
        writer.startElement("script");
        writer.writeText(netbeansAction.getScript());
        writer.endElement();
        Iterator iterator = netbeansAction.getTarget().iterator();
        while (iterator.hasNext()) {
            writer.startElement("target");
            writer.writeText((String)iterator.next());
            writer.endElement();
        }
        writer.endElement();
        this.log.debug((CharSequence)("netbeansAction " + netbeansAction.getName() + " wrote"));
    }

    protected void writeIdeActions(List netbeansActions, XMLWriter writer) throws FreeformPluginException {
        Iterator iterator = netbeansActions.iterator();
        while (iterator.hasNext()) {
            NetbeansAction netbeansAction = (NetbeansAction)iterator.next();
            if (netbeansAction instanceof NamedNetbeansAction) {
                this.writeIdeAction((NamedNetbeansAction)netbeansAction, writer);
                continue;
            }
            this.writeIdeAction(netbeansAction, writer);
        }
    }

    protected void writeName(String name, XMLWriter writer) throws FreeformPluginException {
        writer.startElement("name");
        writer.writeText(name);
        writer.endElement();
        this.log.debug((CharSequence)("name " + name + " wrote"));
    }

    protected void writeProjectXml(XMLWriter writer) throws FreeformPluginException {
        writer.startElement("project");
        writer.addAttribute("xmlns", "http://www.netbeans.org/ns/project/1");
        writer.startElement("type");
        writer.writeText("org.netbeans.modules.ant.freeform");
        writer.endElement();
        writer.startElement("configuration");
        writer.startElement("general-data");
        writer.addAttribute("xmlns", "http://www.netbeans.org/ns/freeform-project/1");
        this.writeName(this.freeformProject.getName(), writer);
        writer.startElement("properties");
        this.writeProperties(this.freeformProject.getProperties(), writer);
        writer.endElement();
        writer.startElement("folders");
        this.writeSourceFolders(this.freeformProject.getSourceFolders(), writer);
        writer.endElement();
        writer.startElement("ide-actions");
        this.writeIdeActions(this.freeformProject.getNetbeansActions(), writer);
        writer.endElement();
        writer.startElement("view");
        writer.startElement("items");
        this.writeViewItems(this.freeformProject.getViewItems(), writer);
        writer.endElement();
        writer.startElement("context-menu");
        this.writeContextMenuItems(this.freeformProject.getContextMenuItems(), writer);
        writer.endElement();
        writer.endElement();
        writer.startElement("subprojects");
        this.writeSubprojects(this.freeformProject.getSubprojects(), writer);
        writer.endElement();
        writer.endElement();
        writer.startElement("java-data");
        writer.addAttribute("xmlns", "http://www.netbeans.org/ns/freeform-project-java/2");
        this.writeCompilationUnits(this.freeformProject.getCompilationUnits(), writer);
        writer.endElement();
        writer.endElement();
        writer.endElement();
    }

    protected void writeProperties(List properties, XMLWriter writer) throws FreeformPluginException {
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (property instanceof NamedProperty) {
                this.writeProperty((NamedProperty)property, writer);
                continue;
            }
            if (property instanceof FileProperty) {
                this.writeProperty((FileProperty)property, writer);
                continue;
            }
            this.writeProperty(property, writer);
        }
    }

    protected void writeProperty(Property property, XMLWriter writer) throws FreeformPluginException {
        this.log.warn((CharSequence)("property " + property + " unknown"));
    }

    protected void writeProperty(NamedProperty property, XMLWriter writer) throws FreeformPluginException {
        writer.startElement("property");
        writer.addAttribute("name", property.getName());
        writer.writeText(property.getValue());
        writer.endElement();
        this.log.debug((CharSequence)("property " + property.getName() + " wrote"));
    }

    protected void writeProperty(FileProperty property, XMLWriter writer) throws FreeformPluginException {
        writer.startElement("property-file");
        writer.writeText(property.getLocation());
        writer.endElement();
        this.log.debug((CharSequence)("property " + property.getLocation() + " wrote"));
    }

    protected void writeSourceFolder(SourceFolder sourceFolder, XMLWriter writer) throws FreeformPluginException {
        writer.startElement("source-folder");
        writer.startElement("label");
        writer.writeText(sourceFolder.getLabel());
        writer.endElement();
        writer.startElement("type");
        writer.writeText(sourceFolder.getType());
        writer.endElement();
        writer.startElement("location");
        writer.writeText(sourceFolder.getLocation());
        writer.endElement();
        writer.endElement();
        this.log.debug((CharSequence)("sourceFolder " + sourceFolder.getLabel() + " wrote"));
    }

    protected void writeSourceFolders(List sourceFolders, XMLWriter writer) throws FreeformPluginException {
        Iterator iterator = sourceFolders.iterator();
        while (iterator.hasNext()) {
            SourceFolder sourceFolder = (SourceFolder)iterator.next();
            this.writeSourceFolder(sourceFolder, writer);
        }
    }

    protected void writeSubprojects(List subprojects, XMLWriter writer) throws FreeformPluginException {
        Iterator iterator = subprojects.iterator();
        while (iterator.hasNext()) {
            Subproject subproject = (Subproject)iterator.next();
            writer.startElement("project");
            writer.writeText(subproject.getSubproject());
            writer.endElement();
            this.log.debug((CharSequence)("subproject " + subproject.getSubproject() + " wrote"));
        }
    }

    protected void writeViewItem(ViewItem viewItem, XMLWriter writer) throws FreeformPluginException {
        this.log.warn((CharSequence)("viewItem " + viewItem + " unknown"));
    }

    protected void writeViewItem(FileViewItem viewItem, XMLWriter writer) throws FreeformPluginException {
        writer.startElement("source-file");
        writer.startElement("label");
        writer.writeText(viewItem.getLabel());
        writer.endElement();
        writer.startElement("location");
        writer.writeText(viewItem.getLocation());
        writer.endElement();
        writer.endElement();
        this.log.debug((CharSequence)("viewItem " + viewItem.getLabel() + " wrote"));
    }

    protected void writeViewItem(FolderViewItem viewItem, XMLWriter writer) throws FreeformPluginException {
        writer.startElement("source-folder");
        writer.addAttribute("style", viewItem.getStyle());
        writer.startElement("label");
        writer.writeText(viewItem.getLabel());
        writer.endElement();
        writer.startElement("location");
        writer.writeText(viewItem.getLocation());
        writer.endElement();
        writer.endElement();
        this.log.debug((CharSequence)("viewItem " + viewItem.getLabel() + " wrote"));
    }

    protected void writeViewItems(List viewItems, XMLWriter writer) throws FreeformPluginException {
        Iterator iterator = viewItems.iterator();
        while (iterator.hasNext()) {
            ViewItem viewItem = (ViewItem)iterator.next();
            if (viewItem instanceof FileViewItem) {
                this.writeViewItem((FileViewItem)viewItem, writer);
                continue;
            }
            if (viewItem instanceof FolderViewItem) {
                this.writeViewItem((FolderViewItem)viewItem, writer);
                continue;
            }
            this.writeViewItem(viewItem, writer);
        }
    }

    private void close(Writer closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            this.log.warn((CharSequence)("The closure of " + this.projectFile + " can not be done"), (Throwable)e);
        }
    }
}

