/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.openjpa;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.openjpa.lib.util.Options;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractOpenJpaMojo
extends AbstractMojo {
    protected File classes;
    private String includes;
    private String excludes;
    private Properties toolProperties;
    private String persistenceXmlFile;
    private String connectionDriverName;
    protected static final String OPTION_CONNECTION_DRIVER_NAME = "ConnectionDriverName";
    private String connectionProperties;
    protected static final String OPTION_CONNECTION_PROPERTIES = "ConnectionProperties";
    protected List compileClasspathElements;
    private boolean forceMojoExecution;
    protected MavenProject project;
    protected static final String OPTION_PROPERTIES_FILE = "propertiesFile";
    protected static final String OPTION_PROPERTIES = "properties";
    private boolean skip;

    protected File getEntityClasses() {
        return this.classes;
    }

    protected List getClasspathElements() {
        return this.compileClasspathElements;
    }

    protected abstract Options getOptions();

    protected boolean skipMojo() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip sql execution");
            return true;
        }
        if (!this.forceMojoExecution && this.project != null && "pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping sql execution for project with packaging type 'pom'");
            return true;
        }
        return false;
    }

    protected Options createOptions() {
        Options opts = new Options();
        if (this.toolProperties != null) {
            opts.putAll((Map)this.toolProperties);
        }
        if (this.persistenceXmlFile != null) {
            opts.put((Object)OPTION_PROPERTIES_FILE, (Object)this.persistenceXmlFile);
            this.getLog().debug((CharSequence)("using special persistence XML file: " + this.persistenceXmlFile));
        }
        if (this.connectionDriverName != null) {
            opts.put((Object)OPTION_CONNECTION_DRIVER_NAME, (Object)this.connectionDriverName);
        }
        if (this.connectionProperties != null) {
            opts.put((Object)OPTION_CONNECTION_PROPERTIES, (Object)this.connectionProperties);
        }
        return opts;
    }

    protected void extendRealmClasspath() throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator itor = this.getClasspathElements().iterator();
        while (itor.hasNext()) {
            File pathElem = new File((String)itor.next());
            try {
                URL url = pathElem.toURI().toURL();
                urls.add(url);
                this.getLog().debug((CharSequence)("Added classpathElement URL " + url));
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Error in adding the classpath " + pathElem, (Exception)e);
            }
        }
        URLClassLoader jpaRealm = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(jpaRealm);
    }

    protected List findEntityClassFiles() throws MojoExecutionException {
        List files = new ArrayList();
        try {
            files = FileUtils.getFiles((File)this.getEntityClasses(), (String)this.includes, (String)this.excludes);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while scanning for '" + this.includes + "' in " + "'" + this.getEntityClasses().getAbsolutePath() + "'.", (Exception)e);
        }
        return files;
    }

    protected String[] getFilePaths(List files) {
        String[] args = new String[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            args[i] = file.getAbsolutePath();
        }
        return args;
    }
}

