/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.pde;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.pde.AbstractEclipsePDEMojo;
import org.codehaus.mojo.pde.descriptor.DescriptorUtil;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class EclipsePDECleanMojo
extends AbstractEclipsePDEMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        File buildXml = new File(this.pdeDirectory, "build.xml");
        if (buildXml.exists()) {
            super.execute();
            try {
                this.clean();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to clean", (Exception)e);
            }
            this.clean(buildXml);
            File buildPropertiesFile = new File(this.pdeDirectory, "build.properties");
            if (buildPropertiesFile.exists()) {
                Properties properties = new Properties();
                try {
                    properties.load(new FileInputStream(buildPropertiesFile));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error loading: " + buildPropertiesFile);
                }
                if (properties.getProperty("custom", "false").equals("false")) {
                    buildXml.delete();
                }
            }
        }
    }

    private void clean() throws MojoExecutionException, IOException {
        String id = this.descriptor.getId();
        File pdeBuildDirectory = this.getPDEBuildDirectory();
        if ("feature".equals(DescriptorUtil.getPDEType(this.descriptor))) {
            File file = new File(pdeBuildDirectory, "package." + id + ".all.xml");
            file.delete();
            file = new File(pdeBuildDirectory, "package." + id + ".xml");
            file.delete();
            file = new File(pdeBuildDirectory, "assemble." + id + ".all.xml");
            file.delete();
            file = new File(pdeBuildDirectory, "assemble." + id + ".xml");
            file.delete();
        } else if ("product".equals(DescriptorUtil.getPDEType(this.descriptor))) {
            String buildLabel = this.buildConfigurationProperties.getString("buildLabel");
            String config = this.convertPdeConfigsToFilenameSuffix(this.buildConfigurationProperties.getString("configs"));
            String configWithUnderscores = config.replace('.', '_');
            File file = new File(pdeBuildDirectory, "assemble.org.eclipse.pde.build.container.feature.all.xml");
            file.delete();
            file = new File(pdeBuildDirectory, "assemble.org.eclipse.pde.build.container.feature." + config + ".xml");
            file.delete();
            file = new File(pdeBuildDirectory, "finalFeaturesVersions.properties");
            file.delete();
            file = new File(pdeBuildDirectory, "finalFeaturesVersions." + configWithUnderscores + ".properties");
            file.delete();
            file = new File(pdeBuildDirectory, "finalPluginsVersions.properties");
            file.delete();
            file = new File(pdeBuildDirectory, "finalPluginsVersions." + configWithUnderscores + ".properties");
            file.delete();
            file = new File(pdeBuildDirectory, "package.org.eclipse.pde.build.container.feature.all.xml");
            file.delete();
            file = new File(pdeBuildDirectory, "package.org.eclipse.pde.build.container.feature." + config + ".xml");
            file.delete();
            file = new File(pdeBuildDirectory, buildLabel);
            FileUtils.deleteDirectory((File)file);
            file = new File(this.pdeDirectory, "temp.folder");
            FileUtils.deleteDirectory((File)file);
            file = new File(this.pdeDirectory, "javaCompiler...args");
            file.delete();
        }
    }

    private void clean(File antFile) throws MojoExecutionException {
        Commandline cl = this.createCommandLine(antFile, "clean");
        this.executeCommandLine(cl);
    }
}

