/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.project.archive;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.project.archive.ProjectSourceContext;
import org.codehaus.mojo.tools.fs.archive.manager.ArchiverManager;
import org.codehaus.mojo.tools.project.extras.DerivedArtifact;
import org.codehaus.mojo.tools.project.extras.ProjectReleaseInfoUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class AbstractProjectSourcesMojo
extends AbstractMojo
implements Contextualizable {
    private String sourceArtifactClassifier;
    private String sourceArtifactType;
    private MavenProject project;
    private MavenSession session;
    private ArtifactRepository localRepository;
    private Artifact projectArtifact;
    private ArchiverManager archiverManager;
    private PlexusContainer container;

    protected String getSourceArtifactType() {
        return this.sourceArtifactType;
    }

    protected String getSourceArtifactClassifier() {
        return this.sourceArtifactClassifier;
    }

    protected ProjectSourceContext loadContext() throws ComponentLookupException {
        ProjectSourceContext pc = (ProjectSourceContext)this.container.lookup(ProjectSourceContext.ROLE, "default");
        pc.read(this.session);
        return pc;
    }

    protected void storeContext(ProjectSourceContext context) throws ComponentLookupException {
        context.store(this.session);
    }

    protected Artifact getProjectSourcesArtifact() throws MojoExecutionException {
        return this.getProjectSourcesArtifact(this.sourceArtifactType);
    }

    protected Artifact getProjectSourcesArtifact(String type) {
        ArtifactHandler handler;
        try {
            handler = (ArtifactHandler)this.getContainer().lookup(ArtifactHandler.ROLE, type);
        }
        catch (ComponentLookupException e) {
            this.getLog().debug((CharSequence)("Cannot lookup ArtifactHandler for archive type: " + type + "; constructing stub artifact handler."));
            handler = new DefaultArtifactHandler(type);
        }
        String baseVersion = ProjectReleaseInfoUtils.getBaseVersion((String)this.getProjectArtifact().getVersion());
        return new DerivedArtifact(this.getProjectArtifact(), baseVersion, this.sourceArtifactClassifier, this.sourceArtifactType, handler);
    }

    protected Artifact getProjectArtifact() {
        return this.projectArtifact;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    protected ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }

    protected PlexusContainer getContainer() {
        return this.container;
    }

    protected MavenSession getSession() {
        return this.session;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected void setArchiverManager(ArchiverManager archiverManager) {
        this.archiverManager = archiverManager;
    }

    protected void setContainer(PlexusContainer container) {
        this.container = container;
    }

    protected void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    protected void setProject(MavenProject project) {
        this.project = project;
    }

    protected void setProjectArtifact(Artifact projectArtifact) {
        this.projectArtifact = projectArtifact;
    }

    protected void setSession(MavenSession session) {
        this.session = session;
    }

    protected void setSourceArtifactClassifier(String sourceArtifactClassifier) {
        this.sourceArtifactClassifier = sourceArtifactClassifier;
    }

    protected void setSourceArtifactType(String sourceArtifactType) {
        this.sourceArtifactType = sourceArtifactType;
    }
}

