/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class CircularDefinitionPreventer {
    private final List<VisitedProperty> entriesVisited = new LinkedList<VisitedProperty>();
    private final Map<String, Boolean> keysUsed = new HashMap<String, Boolean>();

    CircularDefinitionPreventer() {
    }

    public CircularDefinitionPreventer visited(String key, String value) {
        this.entriesVisited.add(new VisitedProperty(key, value));
        if (value != null && this.isValueResolved(value)) {
            this.keysUsed.replaceAll((k, resolvable) -> true);
        } else if (this.keysUsed.containsKey(key) && Boolean.FALSE.equals(this.keysUsed.get(key))) {
            this.circularDefinition();
        }
        this.keysUsed.putIfAbsent(key, false);
        return this;
    }

    private void circularDefinition() {
        StringBuilder buffer = new StringBuilder("Circular property definition: ");
        Iterator<VisitedProperty> iterator = this.entriesVisited.iterator();
        while (iterator.hasNext()) {
            VisitedProperty visited = iterator.next();
            buffer.append(visited.key).append("=").append(visited.value);
            if (!iterator.hasNext()) continue;
            buffer.append(" -> ");
        }
        throw new IllegalArgumentException(buffer.toString());
    }

    private boolean isValueResolved(String value) {
        int prefixPos = value.indexOf("${");
        int suffixPos = value.indexOf("}");
        return prefixPos < 0 || suffixPos <= prefixPos;
    }

    private static class VisitedProperty {
        private final String key;
        private final String value;

        private VisitedProperty(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

