/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:rpm-cbuild-maven-plugin:1.0-beta-1", 0);
        this.append(sb, "", 0);
        this.append(sb, "RPM Plugin", 0);
        this.append(sb, "These plugins are designed to convert tarballs of typical non-java open source project and with patch/autoconf/configure/make/install prepare a directory for packaging with RPM. Stuffing a java project into an RPM is also supported.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 8 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "build".equals(this.goal)) {
            this.append(sb, "rpm-cbuild:build", 0);
            this.append(sb, "Harvest a RPM from the project binaries and the generated spec file.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "destDir (Default: ${project.build.directory}/rpm-basedir)", 2);
                this.append(sb, "The Make DESTDIR, to let the RPM harvester know where the staged installation directory is located for packaging", 3);
                this.append(sb, "", 0);
                this.append(sb, "platformPostfix", 2);
                this.append(sb, "Override for platform postfix on RPM release number", 3);
                this.append(sb, "", 0);
                this.append(sb, "prefix", 2);
                this.append(sb, "The configure prefix, to let the RPM harvester know how to build the dir structure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "release", 2);
                this.append(sb, "The RPM releaes level or build number", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpmName", 2);
                this.append(sb, "Override parameter for the name of this RPM", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpmrcIncludes", 2);
                this.append(sb, "This is a list of locations to include in the generated rpmrc file that contains the ref to the macro definitions that specify the topdir to be used here.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpmVersion", 2);
                this.append(sb, "The RPM version, typically set in a Dynamic Maven Property in the platform-detect goal during the validate phase.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipBuild (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipPlatformPostfix (Default: false)", 2);
                this.append(sb, "Whether to skip postfix on RPM release number rhoover - we can't use null on platformPostfix as an indication to skip the postfix until this bug is fixed (http://jira.codehaus.org/browse/MNG-1959) because currently specifying an empty string for a parameter in the POM yields null instead of an empty string.", 3);
                this.append(sb, "", 0);
                this.append(sb, "topDir (Default: ${project.build.directory}/rpm-topdir)", 2);
                this.append(sb, "Top directory of the RPM filesystem structure.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate-spec".equals(this.goal)) {
            this.append(sb, "rpm-cbuild:generate-spec", 0);
            this.append(sb, "Build a RPM spec file and save it to disk for subsequent harvesting.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dependsExclusions", 2);
                this.append(sb, "List of dependencies in the form 'groupId:artifactId' which should be excluded from the list of dependency functionality.", 3);
                this.append(sb, "", 0);
                this.append(sb, "destDir (Default: ${project.build.directory}/rpm-basedir)", 2);
                this.append(sb, "The Make DESTDIR, to let the RPM harvester know where the software staged installation directory is located for packaging", 3);
                this.append(sb, "", 0);
                this.append(sb, "platformPostfix", 2);
                this.append(sb, "Override for platform postfix on RPM release number.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postInstallFile", 2);
                this.append(sb, "Create a simple RPM post install mechanism If defined, the RPM will insert the named file into the spec file that the pluggin is building (some claim this is weak, but make the script a .sh.in file and let autoconf do some expanding)", 3);
                this.append(sb, "", 0);
                this.append(sb, "postUninstallFile", 2);
                this.append(sb, "Create a simple RPM post un install mechanism If defined, the RPM will insert the named file into the spec file that the pluggin is building (this is weak in the sense that template expansion is not occuring)", 3);
                this.append(sb, "", 0);
                this.append(sb, "prefix", 2);
                this.append(sb, "The configure prefix, to let the RPM harvester know how to build the dir structure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preInstallFile", 2);
                this.append(sb, "Create a simple RPM pre install mechanism If defined, the RPM will insert the named file into the spec file that the pluggin is building (this is weak in the sense that template expansion is not occuring)", 3);
                this.append(sb, "", 0);
                this.append(sb, "preUninstallFile", 2);
                this.append(sb, "Create a simple RPM pre un install mechanism If defined, the RPM will insert the named file into the spec file that the pluggin is building (this is weak in the sense that template expansion is not occuring)", 3);
                this.append(sb, "", 0);
                this.append(sb, "providesExclusions", 2);
                this.append(sb, "List of dependencies in the form 'groupId:artifactId' which should be excluded from the list of provided functionality.", 3);
                this.append(sb, "", 0);
                this.append(sb, "release", 2);
                this.append(sb, "The build number of the RPM, so you get versions like 1.2-4 which would be the fourth build of the 1.2 tarball. This is typically set during the platform-detect goal in the validate phase.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpmName", 2);
                this.append(sb, "Override parameter for the name of the RPM to be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpmNoStrip (Default: false)", 2);
                this.append(sb, "Turn off RPM compression and symbol stripping - this is very much manditory for binary sources like Sybase, Oracle, and the SunJDK. Usually you want this copression, so the default is false.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpmVersion", 2);
                this.append(sb, "The RPM version, typically set in a Dynamic Maven Property in the platform-detect goal during the validate phase.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Whether to skip RPM spec file generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipPlatformPostfix (Default: false)", 2);
                this.append(sb, "Whether to skip postfix on RPM release number. When this is set, the RPM BuildArch: will be set to noarch and the RPM Release: will only have the release number established by the platform-detect goal. When set to true, no BuildArch: will be set in the RPM and the release will have a release number and a platform postfix in it so you can tell what operating system distro was used when the RPM was created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "topDir (Default: ${project.build.directory}/rpm-topdir)", 2);
                this.append(sb, "The top directory of the RPM harvesting structure.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "rpm-cbuild:help", 0);
            this.append(sb, "Display help information on rpm-cbuild-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0rpm-cbuild:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "install".equals(this.goal)) {
            this.append(sb, "rpm-cbuild:install", 0);
            this.append(sb, "Used to install the RPM onto the OS. This is critical for multimodule builds, since dependent compiles need RPMs installed.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "forceAllInstalls (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceInstall (Default: false)", 2);
                this.append(sb, "This will attempt to override an error which will usually abort an RPM install", 3);
                this.append(sb, "", 0);
                this.append(sb, "noParentDirs (Default: false)", 2);
                this.append(sb, "RPM 4.4.6 introduced a feature that the parent directories of a package must be provided by another package as a dependency. This usually isn't what you want so set this to false if you are getting installation failures on a directory dependency. You can check your system for orphanced dependencies with rpm -Va --orphandirs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "release", 2);
                this.append(sb, "The build number of the RPM, so you get versions like 1.2-4 which would be the fourth build of the 1.2 tarball.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpmDbPath", 2);
                this.append(sb, "Use this if your RPM database is not installed in the typical location, usually /var/lib/rpm", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpmVersion", 2);
                this.append(sb, "The RPM version, typically set in a Dynamic Maven Property in the platform-detect goal during the validate phase.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipInstall (Default: false)", 2);
                this.append(sb, "Use this flag to skip the install phase of an RPM. Useful if you want to create an RPM but not install it on your build machine.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useSudo (Default: true)", 2);
                this.append(sb, "Flag to determine when to use sudo to execute the rpm command.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "install-dependencies".equals(this.goal)) {
            this.append(sb, "rpm-cbuild:install-dependencies", 0);
            this.append(sb, "Used to install the RPM onto the OS. This is critical for multimodule builds, since dependent compiles need RPMs installed.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "forceAllInstalls (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceDependencyInstalls (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "noParentDirs (Default: false)", 2);
                this.append(sb, "RPM 4.4.6 introduced a feature that the parent directories of a package must be provided by another package as a dependency. This usually isn't what you want so set this to false if you are getting installation failures on a directory dependency. You can check your system for orphanced dependencies with rpm -Va --orphandirs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpmDbPath", 2);
                this.append(sb, "Use this if your RPM database is not installed in the typical location, usually /var/lib/rpm", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipDependencies (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "useSudo (Default: true)", 2);
                this.append(sb, "Flag to determine when to use sudo to execute the rpm command.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "platform-detect".equals(this.goal)) {
            this.append(sb, "rpm-cbuild:platform-detect", 0);
            this.append(sb, "This goal will do basic validation of the project for use with the rpm-cbuild-maven-plugin and set Maven dynamic properties which will be needed in later rpm-cbuild goals", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archProperty (Default: DYNAMIC.CBUILDPROP.ARCH)", 2);
                this.append(sb, "platform-detect will set a Maven property during runtime which the project's POM may utilize after this plugin runs. The system architecture (i386, x86_64, etc) will be the value and the value of archProperty will be the name of the dynamic Maven property.", 3);
                this.append(sb, "", 0);
                this.append(sb, "osProperty (Default: DYNAMIC.CBUILDPROP.OS)", 2);
                this.append(sb, "platform-detect will set a Maven property during runtime which the project's POM may utilize after this plugin runs. The system os name (rhel3, fc10, osx5, etc) will be the value and the value of osProperty will be the name of the dynamic Maven property.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpmReleaseProperty (Default: DYNAMIC.CBUILDPROP.RPM.RELEASE)", 2);
                this.append(sb, "platform-detect will set a Maven property during runtime which the project's POM may utilize after this plugin runs. The declared maven project's version will be parsed to derive an RPM release number. This will be concatenated in the rpm-cbuild-maven-plugin with the platform distro (rhel3, osx5, centos5, etc) to get you a full rpm release named something like 4.rhel3. The release will be the string to the right of the last dash and must be SNAPSHOT or a numeric value, otherwise an error will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rpmVersionProperty (Default: DYNAMIC.CBUILDPROP.RPM.VERSION)", 2);
                this.append(sb, "platform-detect will set a Maven property during runtime which the project's POM may utilize after this plugin runs. The declared maven project's version will be parsed to derive an RPM version. Many legal maven version will generate an error as they introduce compatibility problems with RPM version numbers. Legal maven versions are similar to 1.2.3-SNAPSHOT and 1.2.3-4. The version will be the string to the left of the last dash. Maven keywords like ALPHA, BETA, RC, and the like will generate an error. Don't use maven milestone versioning either such as 2.1.0-M1-1 as this will not do what you expect when put into RPM packaging. If you run into one of these Maven projects that you want to put in an RPM, best to version it as either 2.1.0-SNAPSHOT or 2.0.999-1.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Whether to skip RPM platform-detect file generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipPlatformPostfix (Default: false)", 2);
                this.append(sb, "Whether to skip postfix on RPM release number. When this is set, the RPM BuildArch: will be set to noarch and the RPM Release: will only have the release number established by this platform-detect goal. When set to true, no BuildArch: will be set in the RPM and the release will have a release number and a platform postfix in it so you can tell what operating system distro was used when the RPM was created.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "remove".equals(this.goal)) {
            this.append(sb, "rpm-cbuild:remove", 0);
            this.append(sb, "Used to install the RPM onto the OS. This is critical for multimodule builds, since dependent compiles need RPMs installed.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "rpmDbPath", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipRemove (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "useSudo (Default: true)", 2);
                this.append(sb, "Flag to determine when to use sudo to execute the rpm command.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "remove-project-references".equals(this.goal)) {
            this.append(sb, "rpm-cbuild:remove-project-references", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

