/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.ActiveProjectArtifact;
import org.codehaus.mojo.rpm.AbstractRpmInstallMojo;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInstallException;

public class InstallDependencyRpmsMojo
extends AbstractRpmInstallMojo {
    private boolean skipDependencies;
    private Set<Artifact> artifacts;
    private boolean forceDependencyInstalls;
    private String projectPackaging;
    private ArtifactRepository localRepository;
    private List<String> remoteRepositories;
    private ArtifactFactory artifactFactory;
    private MavenProjectBuilder projectBuilder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.projectPackaging)) {
            this.getLog().info((CharSequence)"Skipping RPM-dependency installation for POM project.");
            return;
        }
        if (this.skipDependencies) {
            this.getLog().info((CharSequence)"Skipping RPM dependency install (per configuration).");
            return;
        }
        for (Artifact artifact : this.artifacts) {
            this.getLog().debug((CharSequence)("Processing dependency: " + artifact.getId()));
            try {
                Artifact dummy = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                MavenProject project = this.projectBuilder.buildFromRepository(dummy, this.remoteRepositories, this.localRepository);
                if (!(artifact instanceof ActiveProjectArtifact)) {
                    project.setArtifact(artifact);
                }
                this.install(project, this.forceDependencyInstalls);
            }
            catch (RpmInstallException e) {
                throw new MojoExecutionException("Failed to install dependency RPM: " + artifact.getId(), (Exception)e);
            }
            catch (RpmFormattingException e) {
                throw new MojoExecutionException("Failed to install dependency RPM: " + artifact.getId(), (Exception)e);
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("Failed to retrieve POM information for dependency RPM: " + artifact.getId(), (Exception)((Object)e));
            }
        }
    }
}

