/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tools.platform.PlatformDetectionException;
import org.codehaus.mojo.tools.platform.detective.PlatformDetective;
import org.codehaus.mojo.tools.project.extras.ProjectReleaseInfoUtils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class ValidateRpmMojo
extends AbstractMojo {
    private boolean skip;
    private String osProperty;
    private String archProperty;
    private String rpmVersionProperty;
    private String rpmReleaseProperty;
    private boolean skipPlatformPostfix;
    private PlatformDetective detective;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        String origVersion;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping generation of RPM spec file (per configuration).");
            return;
        }
        List licenses = this.project.getLicenses();
        if (licenses == null || licenses.isEmpty()) {
            throw new MojoExecutionException("You need to specify the project license in your POM.");
        }
        String description = this.project.getDescription();
        if (description == null || description.trim().length() < 1) {
            throw new MojoExecutionException("You need to write a description of the project in your POM.");
        }
        Properties projectProps = this.project.getProperties();
        String myprop = projectProps.getProperty(this.archProperty);
        if (myprop == null) {
            try {
                String archToken = this.detective.getArchitectureToken();
                this.getLog().debug((CharSequence)("Injecting architecture token: {key: '" + this.archProperty + "', value: '" + archToken + "'}."));
                projectProps.put(this.archProperty, archToken);
            }
            catch (PlatformDetectionException e) {
                throw new MojoExecutionException("Error scanning for platform architecture information.\n    This usually happens when you don't have the rpm binary in your path.", (Exception)e);
            }
        }
        if ((myprop = projectProps.getProperty(this.osProperty)) == null) {
            if (this.skipPlatformPostfix) {
                projectProps.put(this.osProperty, "noarch");
            } else {
                try {
                    String osToken = this.detective.getOperatingSystemToken();
                    this.getLog().debug((CharSequence)("Setting Dynamic Property for OS token: {key: '" + this.osProperty + "', value: '" + osToken + "'}."));
                    projectProps.put(this.osProperty, osToken);
                }
                catch (PlatformDetectionException e) {
                    throw new MojoExecutionException("Error scanning for platform distribution information.", (Exception)e);
                }
                catch (ComponentLookupException e) {
                    throw new MojoExecutionException("Error scanning for platform distribution information.", (Exception)((Object)e));
                }
            }
        }
        if ((origVersion = this.project.getVersion()).toLowerCase().contains("-alpha") || origVersion.toLowerCase().contains("-beta") || origVersion.toLowerCase().contains("-rc-")) {
            throw new MojoExecutionException("Illegal version encountered, see http://jira.codehaus.org/browse/CBUILDS-38.");
        }
        String[] splitVersion = ProjectReleaseInfoUtils.splitVersionBaseAndRelease((String)origVersion, (boolean)false);
        if (splitVersion[1] == null) {
            throw new MojoExecutionException("No release in version encountered, see http://jira.codehaus.org/browse/CBUILDS-38.");
        }
        if (splitVersion[1] != "SNAPSHOT") {
            int releaseNum;
            try {
                releaseNum = Integer.parseInt(splitVersion[1]);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Illegal release encountered, see http://jira.codehaus.org/browse/CBUILDS-38.");
            }
            if (releaseNum < 1) {
                throw new MojoExecutionException("Release number must be greater than zero, see http://jira.codehaus.org/browse/CBUILDS-38.");
            }
        }
        if ((myprop = projectProps.getProperty(this.rpmReleaseProperty)) == null) {
            if (splitVersion[1] == "SNAPSHOT") {
                projectProps.put(this.rpmReleaseProperty, "0.0.SNAPSHOT");
            } else {
                projectProps.put(this.rpmReleaseProperty, splitVersion[1]);
            }
        }
        if ((myprop = projectProps.getProperty(this.rpmVersionProperty)) == null) {
            projectProps.put(this.rpmVersionProperty, splitVersion[0]);
        }
    }
}

