/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tools.antcall.AntCallLogger;
import org.codehaus.mojo.tools.antcall.MojoLogAdapter;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;
import org.codehaus.mojo.tools.rpm.RpmInstallException;
import org.codehaus.mojo.tools.rpm.RpmMediator;
import org.codehaus.mojo.tools.rpm.RpmQueryException;

public abstract class AbstractRpmInstallMojo
extends AbstractMojo {
    private boolean useSudo;
    private String rpmDbPath;
    private boolean forceAllInstalls;
    private RpmInfoFormatter rpmInfoFormatter;
    private RpmMediator rpmMediator;

    protected AbstractRpmInstallMojo() {
    }

    private void initializeRpmMediator() {
        if (this.rpmMediator == null) {
            this.rpmMediator = new RpmMediator(this.useSudo, (AntCallLogger)new MojoLogAdapter(this.getLog()));
        }
    }

    protected final void install(MavenProject project, boolean force) throws RpmFormattingException, RpmInstallException, MojoExecutionException {
        this.initializeRpmMediator();
        Artifact artifact = project.getArtifact();
        Properties properties = project.getProperties();
        String dbPath = this.rpmDbPath;
        if (dbPath == null && properties != null) {
            dbPath = properties.getProperty("rpmDbPath", this.rpmDbPath);
            this.getLog().info((CharSequence)("Using RPM database path from POM: '" + dbPath + "'."));
        } else {
            this.getLog().info((CharSequence)("Using RPM database path from plugin parameter: '" + dbPath + "'."));
        }
        String rpmName = this.rpmInfoFormatter.formatRpmNameWithoutVersion(project);
        try {
            if (force || !this.rpmMediator.isRpmInstalled(rpmName, project.getVersion(), dbPath)) {
                this.rpmMediator.install(rpmName, artifact.getFile(), dbPath, force || this.forceAllInstalls);
            }
        }
        catch (RpmQueryException e) {
            throw new MojoExecutionException("Error querying for the existence of: " + rpmName + " in RPM database: " + dbPath);
        }
    }
}

