/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.optional.Rpm;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.mojo.rpm.ProjectRpmFileManager;
import org.codehaus.mojo.tools.antcall.AntCallLogger;
import org.codehaus.mojo.tools.antcall.AntCaller;
import org.codehaus.mojo.tools.antcall.AntExecutionException;
import org.codehaus.mojo.tools.antcall.MojoLogAdapter;
import org.codehaus.mojo.tools.context.BuildAdvisor;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;
import org.codehaus.plexus.context.Context;

public class BuildRpmMojo
extends AbstractMojo {
    private boolean skipBuild;
    private String platformPostfix;
    private boolean skipPlatformPostfix;
    private String rpmName;
    private MavenProject project;
    private File topDir;
    private String messageLevel;
    private File rpmsDir;
    private String release;
    private MavenSession session;
    private RpmInfoFormatter rpmInfoFormatter;
    private ProjectRpmFileManager projectRpmFileManager;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$ExecTask;

    public void execute() throws MojoExecutionException {
        String string;
        String distro;
        String rpmBaseName;
        if (this.skipBuild) {
            this.getLog().info((CharSequence)"Skipping RPM build (per configuration).");
            return;
        }
        if (BuildAdvisor.isProjectBuildSkipped((MavenProject)this.project, (Context)this.session.getContainer().getContext())) {
            this.getLog().info((CharSequence)"Skipping execution per pre-existing advice.");
            return;
        }
        if (this.rpmName != null && this.rpmName.trim().length() > 0) {
            rpmBaseName = this.rpmName;
        } else {
            try {
                rpmBaseName = this.rpmInfoFormatter.formatRpmName(this.project, this.release, this.platformPostfix, this.skipPlatformPostfix);
            }
            catch (RpmFormattingException e) {
                throw new MojoExecutionException("Failed to format RPM name. Reason: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        File tmpPath = new File(this.topDir, "tmp");
        try {
            this.buildRpmDirectoryStructure();
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Cannot read OS architecture from rpm command.", (Exception)((Object)e));
        }
        Rpm rpm = new Rpm();
        rpm.setTaskName("rpm");
        rpm.setSpecFile(rpmBaseName + ".spec");
        rpm.setCommand("-bb --define \"_tmppath " + tmpPath.getAbsolutePath() + "\"");
        rpm.setFailOnError(true);
        rpm.setTopDir(this.topDir);
        AntCaller antCaller = new AntCaller((AntCallLogger)new MojoLogAdapter(this.getLog()));
        if (this.messageLevel != null) {
            antCaller.setMessageLevel(this.messageLevel);
        }
        antCaller.addTask((Task)rpm);
        Chmod chmod = new Chmod();
        chmod.setTaskName("chmod");
        chmod.setPerm("g+w");
        chmod.setFailonerror(true);
        FileSet fs = new FileSet();
        fs.setDir(this.topDir);
        fs.setIncludes("**/*");
        chmod.addFileset(fs);
        antCaller.addTask((Task)chmod);
        try {
            antCaller.executeTasks(this.project);
        }
        catch (AntExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause.getStackTrace()[0].getClassName().equals((class$org$apache$tools$ant$taskdefs$ExecTask == null ? (class$org$apache$tools$ant$taskdefs$ExecTask = BuildRpmMojo.class$("org.apache.tools.ant.taskdefs.ExecTask")) : class$org$apache$tools$ant$taskdefs$ExecTask).getName())) {
                this.getLog().debug((CharSequence)"Error building RPM", cause);
                throw new MojoExecutionException("Failed to build RPM.");
            }
            throw new MojoExecutionException("Failed to build RPM.", (Exception)((Object)e));
        }
        if (RpmInfoFormatter.getUseRpmFinalName((MavenProject)this.project)) {
            rpmBaseName = rpmBaseName + "-" + this.project.getVersion() + "-" + this.release;
        }
        try {
            distro = "." + this.rpmInfoFormatter.formatPlatformArchitecture();
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Cannot read OS architecture from rpm command.", (Exception)((Object)e));
        }
        if (rpmBaseName.endsWith(distro)) {
            string = rpmBaseName.substring(0, rpmBaseName.length() - distro.length());
        }
        this.getLog().warn((CharSequence)("Just before setting the final RPM project-artifact, release is: " + this.release + "; rpmBaseName is: " + string));
        this.projectRpmFileManager.formatAndSetProjectArtifactFile(this.project, this.topDir, string);
    }

    private void buildRpmDirectoryStructure() throws RpmFormattingException {
        this.topDir.mkdirs();
        File build = new File(this.topDir, "BUILD");
        build.mkdirs();
        this.rpmsDir = new File(this.topDir, "RPMS/" + this.rpmInfoFormatter.formatPlatformArchitecture());
        this.getLog().info((CharSequence)("RPMS Directory: '" + this.rpmsDir.getAbsolutePath() + "'"));
        this.rpmsDir.mkdirs();
        File sources = new File(this.topDir, "SOURCES");
        sources.mkdirs();
        File specs = new File(this.topDir, "SPECS");
        specs.mkdirs();
        File srpms = new File(this.topDir, "SRPMS");
        srpms.mkdirs();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

