/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;

public class Dependency {
    private List includes;
    private List excludes;

    public List getIncludes() {
        return this.includes;
    }

    public void setIncludes(List incls) throws MojoExecutionException {
        this.includes = this.parseList(incls);
    }

    public List getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List excls) throws MojoExecutionException {
        this.excludes = this.parseList(excls);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[dependencies");
        if (this.includes != null) {
            sb.append(" include [" + this.includes + "]");
        }
        if (this.excludes != null) {
            sb.append(" exclude [" + this.excludes + "]");
        }
        sb.append("]");
        return sb.toString();
    }

    private List parseList(List in) throws MojoExecutionException {
        ArrayList<DefaultArtifact> retval = new ArrayList<DefaultArtifact>();
        Iterator it = in.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            int p1 = s.indexOf(":");
            if (p1 == -1) {
                throw new MojoExecutionException("Include and exclude must include both group and artifact IDs.");
            }
            int p2 = s.indexOf(":", p1 + 1);
            VersionRange vr = null;
            if (p2 == -1) {
                p2 = s.length();
                try {
                    vr = VersionRange.createFromVersionSpec((String)"[0,]");
                }
                catch (InvalidVersionSpecificationException ex) {
                    throw new MojoExecutionException("Default version string is invalid!");
                }
            }
            try {
                vr = VersionRange.createFromVersionSpec((String)s.substring(p2 + 1));
            }
            catch (InvalidVersionSpecificationException ex) {
                throw new MojoExecutionException("Version string " + s.substring(p2 + 1) + " is invalid.");
            }
            retval.add(new DefaultArtifact(s.substring(0, p1), s.substring(p1 + 1, p2), vr, null, "", "", null));
        }
        return retval;
    }
}

