/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.rpm.ArtifactMap;
import org.codehaus.mojo.rpm.Dependency;
import org.codehaus.mojo.rpm.Mapping;
import org.codehaus.mojo.rpm.Source;
import org.codehaus.plexus.archiver.dir.DirectoryArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class RPMMojo
extends AbstractMojo {
    private String name;
    private String projversion;
    private String release;
    private boolean needarch;
    private String description;
    private String summary;
    private String copyright;
    private String distribution;
    private File icon;
    private String vendor;
    private String url;
    private String group;
    private String packager;
    private List provides;
    private List requires;
    private List conflicts;
    private String prefix;
    private File workarea;
    private List mappings;
    private String preinstall;
    private File preinstallScript;
    private String postinstall;
    private File postinstallScript;
    private String install;
    private File installScript;
    private String preremove;
    private File preremoveScript;
    private String postremove;
    private File postremoveScript;
    private String verify;
    private File verifyScript;
    private String clean;
    private File cleanScript;
    private DirectoryArchiver copier;
    private Artifact artifact;
    private List attachedArtifacts;
    private MavenProject project;
    private List defineStatements;
    private File buildroot;
    private String version;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkParams();
        this.buildWorkArea();
        this.writeSpecFile();
        this.installFiles();
        this.buildPackage();
    }

    private void buildPackage() throws MojoExecutionException {
        File f = new File(this.workarea, "SPECS");
        Commandline cl = new Commandline();
        cl.setExecutable("rpmbuild");
        cl.setWorkingDirectory(f.getAbsolutePath());
        cl.createArgument().setValue("-bb");
        cl.createArgument().setValue("--define");
        cl.createArgument().setValue("_topdir " + this.workarea.getAbsolutePath());
        if (!this.needarch) {
            cl.createArgument().setValue("--target");
            cl.createArgument().setValue("noarch");
        }
        cl.createArgument().setValue(this.name + ".spec");
        StdoutConsumer stdout = new StdoutConsumer(this.getLog());
        StderrConsumer stderr = new StderrConsumer(this.getLog());
        try {
            int result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
            if (result != 0) {
                throw new MojoExecutionException("RPM build execution returned: '" + result + "'.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to build the RPM", (Exception)((Object)e));
        }
    }

    private void buildWorkArea() throws MojoFailureException {
        String[] topdirs = new String[]{"BUILD", "RPMS", "SOURCES", "SPECS", "SRPMS"};
        if (!this.workarea.exists()) {
            this.getLog().info((CharSequence)("Creating directory " + this.workarea.getAbsolutePath()));
            if (!this.workarea.mkdirs()) {
                throw new MojoFailureException("Unable to create directory " + this.workarea.getAbsolutePath());
            }
        }
        for (int i = 0; i < topdirs.length; ++i) {
            File d = new File(this.workarea, topdirs[i]);
            if (d.exists()) continue;
            this.getLog().info((CharSequence)("Creating directory " + d.getAbsolutePath()));
            if (d.mkdir()) continue;
            throw new MojoFailureException("Unable to create directory " + d.getAbsolutePath());
        }
        this.buildroot = new File(this.workarea, "buildroot");
        if (!this.buildroot.exists()) {
            this.getLog().info((CharSequence)("Creating directory " + this.buildroot.getAbsolutePath()));
            if (!this.buildroot.mkdir()) {
                throw new MojoFailureException("Unable to create directory " + this.buildroot.getAbsolutePath());
            }
        }
    }

    private void checkParams() throws MojoExecutionException, MojoFailureException {
        if (this.projversion.indexOf("-") == -1) {
            this.version = this.projversion;
        } else {
            this.version = this.projversion.substring(0, this.projversion.indexOf("-"));
            this.getLog().warn((CharSequence)("Version string truncated to " + this.version));
        }
        Iterator it = this.mappings.iterator();
        while (it.hasNext()) {
            Mapping map = (Mapping)it.next();
            if (map.getDirectory() == null) {
                throw new MojoFailureException("<mapping> element must contain the destination directory");
            }
            if (map.getSources() == null) continue;
            Iterator sit = map.getSources().iterator();
            while (sit.hasNext()) {
                Source src = (Source)sit.next();
                if (src.getLocation() != null) continue;
                throw new MojoFailureException("<mapping><source> tag must contain the source directory");
            }
        }
        if (this.preinstall == null && this.preinstallScript != null) {
            this.preinstall = this.readFile(this.preinstallScript);
        }
        if (this.install == null && this.installScript != null) {
            this.install = this.readFile(this.installScript);
        }
        if (this.postinstall == null && this.postinstallScript != null) {
            this.postinstall = this.readFile(this.postinstallScript);
        }
        if (this.preremove == null && this.preremoveScript != null) {
            this.preremove = this.readFile(this.preremoveScript);
        }
        if (this.postremove == null && this.postremoveScript != null) {
            this.postremove = this.readFile(this.postremoveScript);
        }
        if (this.verify == null && this.verifyScript != null) {
            this.verify = this.readFile(this.verifyScript);
        }
        if (this.clean == null && this.cleanScript != null) {
            this.clean = this.readFile(this.cleanScript);
        }
    }

    private void copyArtifact(Artifact art, File dest) throws MojoExecutionException {
        if (art.getFile() == null) {
            this.getLog().warn((CharSequence)("Artifact " + art + " requested in configuration."));
            this.getLog().warn((CharSequence)"Plugin must run in standard lifecycle for this to work.");
            return;
        }
        this.copySource(art.getFile(), dest, null, null);
    }

    private void copySource(File src, File dest, List incl, List excl) throws MojoExecutionException {
        try {
            this.copier.setDestFile(dest);
            if (src.isDirectory()) {
                String[] ia = null;
                if (incl != null) {
                    ia = incl.toArray(new String[0]);
                }
                String[] ea = null;
                if (excl != null) {
                    ea = excl.toArray(new String[0]);
                }
                this.copier.addDirectory(src, "", ia, ea);
            } else {
                this.copier.addFile(src, src.getName());
            }
            this.copier.createArchive();
            this.copier.resetArchiver();
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Unable to copy files for packaging: " + t.getMessage(), t);
        }
    }

    private boolean depMatcher(Artifact dep, List list) {
        if (list == null) {
            return false;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Artifact item = (Artifact)it.next();
            this.getLog().debug((CharSequence)("Compare " + dep + " to " + item));
            if (!item.getGroupId().equals(dep.getGroupId())) continue;
            this.getLog().debug((CharSequence)"... Group matches");
            if (!item.getArtifactId().equals(dep.getArtifactId())) continue;
            this.getLog().debug((CharSequence)"... Artifact matches");
            try {
                if (!item.getVersionRange().containsVersion(dep.getSelectedVersion())) continue;
                this.getLog().debug((CharSequence)"... Version matches");
                return true;
            }
            catch (OverConstrainedVersionException ocve) {
                this.getLog().debug((CharSequence)"... caught OverConstrainedVersionException");
            }
        }
        return false;
    }

    private void installFiles() throws MojoExecutionException {
        if (this.icon != null) {
            File icondest = new File(this.workarea, "SOURCES");
            this.copySource(this.icon, icondest, null, null);
        }
        Iterator it = this.mappings.iterator();
        while (it.hasNext()) {
            Dependency dep;
            ArtifactMap art;
            Mapping map = (Mapping)it.next();
            File dest = new File(this.buildroot + map.getDestination());
            if (map.isDirOnly()) {
                if (dest.exists()) continue;
                this.getLog().info((CharSequence)("Creating empty directory " + dest.getAbsolutePath()));
                if (dest.mkdirs()) continue;
                throw new MojoExecutionException("Unable to create " + dest.getAbsolutePath());
            }
            List srcs = map.getSources();
            if (srcs != null) {
                Iterator sit = srcs.iterator();
                while (sit.hasNext()) {
                    Source src = (Source)sit.next();
                    if (src.getLocation().exists()) {
                        ArrayList elist = src.getExcludes();
                        if (!src.getNoDefaultExcludes()) {
                            if (elist == null) {
                                elist = new ArrayList();
                            }
                            elist.addAll(FileUtils.getDefaultExcludesAsList());
                        }
                        this.copySource(src.getLocation(), dest, src.getIncludes(), elist);
                        continue;
                    }
                    throw new MojoExecutionException("Source location " + src.getLocation() + " does not exist");
                }
            }
            if ((art = map.getArtifact()) != null) {
                List artlist = this.selectArtifacts(art);
                Iterator ait = artlist.iterator();
                while (ait.hasNext()) {
                    this.copyArtifact((Artifact)ait.next(), dest);
                }
            }
            if ((dep = map.getDependency()) == null) continue;
            List deplist = this.selectDependencies(dep);
            Iterator dit = deplist.iterator();
            while (dit.hasNext()) {
                this.copyArtifact((Artifact)dit.next(), dest);
            }
        }
    }

    private String readFile(File in) throws MojoExecutionException {
        try {
            StringBuffer sb = new StringBuffer();
            BufferedReader br = new BufferedReader(new FileReader(in));
            while (br.ready()) {
                String line = br.readLine();
                sb.append(line + "\n");
            }
            br.close();
            return sb.toString();
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Unable to read " + in.getAbsolutePath(), t);
        }
    }

    private List selectArtifacts(ArtifactMap am) {
        ArrayList<Artifact> retval = new ArrayList<Artifact>();
        List clist = am.getClassifiers();
        if (clist == null) {
            retval.add(this.artifact);
            retval.addAll(this.attachedArtifacts);
        } else {
            if (clist.contains(null)) {
                retval.add(this.artifact);
            }
            Iterator ait = this.attachedArtifacts.iterator();
            while (ait.hasNext()) {
                Artifact aa = (Artifact)ait.next();
                if (!aa.hasClassifier() || !clist.contains(aa.getClassifier())) continue;
                retval.add(aa);
            }
        }
        return retval;
    }

    private List selectDependencies(Dependency d) {
        ArrayList<Artifact> retval = new ArrayList<Artifact>();
        List inc = d.getIncludes();
        List exc = d.getExcludes();
        List deps = this.project.getRuntimeArtifacts();
        if (deps == null || deps.isEmpty()) {
            return retval;
        }
        Iterator it = deps.iterator();
        while (it.hasNext()) {
            Artifact pdep = (Artifact)it.next();
            this.getLog().debug((CharSequence)("Dependency is " + pdep + " at " + pdep.getFile()));
            if (this.depMatcher(pdep, exc)) continue;
            this.getLog().debug((CharSequence)"--> not excluded");
            if (inc != null && !this.depMatcher(pdep, inc)) continue;
            this.getLog().debug((CharSequence)"--> included");
            retval.add(pdep);
        }
        return retval;
    }

    private void writeSpecFile() throws MojoExecutionException {
        File f = new File(this.workarea, "SPECS");
        File specf = new File(f, this.name + ".spec");
        try {
            Iterator it;
            this.getLog().info((CharSequence)("Creating spec file " + specf.getAbsolutePath()));
            PrintWriter spec = new PrintWriter(new FileWriter(specf));
            if (null != this.defineStatements) {
                Iterator defineIter = this.defineStatements.iterator();
                String defineStatement = (String)defineIter.next();
                spec.println("%define " + defineStatement);
            }
            spec.println("Name: " + this.name);
            spec.println("Version: " + this.version);
            spec.println("Release: " + this.release);
            if (this.summary != null) {
                spec.println("Summary: " + this.summary);
            }
            if (this.copyright != null) {
                spec.println("License: " + this.copyright);
            }
            if (this.distribution != null) {
                spec.println("Distribution: " + this.distribution);
            }
            if (this.icon != null) {
                spec.println("Icon: " + this.icon.getName());
            }
            if (this.vendor != null) {
                spec.println("Vendor: " + this.vendor);
            }
            if (this.url != null) {
                spec.println("URL: " + this.url);
            }
            if (this.group != null) {
                spec.println("Group: " + this.group);
            }
            if (this.packager != null) {
                spec.println("Packager: " + this.packager);
            }
            if (this.provides != null) {
                it = this.provides.iterator();
                while (it.hasNext()) {
                    spec.println("Provides: " + it.next());
                }
            }
            if (this.requires != null) {
                it = this.requires.iterator();
                while (it.hasNext()) {
                    spec.println("Requires: " + it.next());
                }
            }
            if (this.conflicts != null) {
                it = this.conflicts.iterator();
                while (it.hasNext()) {
                    spec.println("Conflicts: " + it.next());
                }
            }
            if (this.prefix != null) {
                spec.println("Prefix: " + this.prefix);
            }
            spec.println("BuildRoot: " + this.buildroot.getAbsolutePath());
            spec.println();
            spec.println("%description");
            if (this.description != null) {
                spec.println(this.description);
            }
            spec.println();
            spec.println("%files");
            it = this.mappings.iterator();
            while (it.hasNext()) {
                Mapping map = (Mapping)it.next();
                spec.println(map.getAttrString() + " " + map.getDestination());
            }
            if (this.preinstall != null) {
                spec.println();
                spec.println("%pre");
                spec.println(this.preinstall);
            }
            if (this.install != null) {
                spec.println();
                spec.println("%install");
                spec.println(this.install);
            }
            if (this.postinstall != null) {
                spec.println();
                spec.println("%post");
                spec.println(this.postinstall);
            }
            if (this.preremove != null) {
                spec.println();
                spec.println("%preun");
                spec.println(this.preremove);
            }
            if (this.postremove != null) {
                spec.println();
                spec.println("%postun");
                spec.println(this.postremove);
            }
            if (this.verify != null) {
                spec.println();
                spec.println("%verifyscript");
                spec.println(this.verify);
            }
            if (this.clean != null) {
                spec.println();
                spec.println("%clean");
                spec.println(this.clean);
            }
            spec.close();
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Unable to write " + specf.getAbsolutePath(), t);
        }
    }

    private class StderrConsumer
    implements StreamConsumer {
        private Log logger;

        public StderrConsumer(Log log) {
            this.logger = log;
        }

        public void consumeLine(String string) {
            this.logger.warn((CharSequence)string);
        }
    }

    private class StdoutConsumer
    implements StreamConsumer {
        private Log logger;

        public StdoutConsumer(Log log) {
            this.logger = log;
        }

        public void consumeLine(String string) {
            this.logger.info((CharSequence)string);
        }
    }
}

