/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.rpm.ArtifactMap;
import org.codehaus.mojo.rpm.Dependency;
import org.codehaus.mojo.rpm.Mapping;
import org.codehaus.mojo.rpm.Source;
import org.codehaus.plexus.archiver.dir.DirectoryArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

abstract class AbstractRPMMojo
extends AbstractMojo {
    private static final String DESTINATION_DIRECTORY_ERROR_MSG = "Source has a destination [{0}], but the location [{1}] does not refer to a file.";
    private String name;
    private String projversion;
    private String release;
    private String needarch;
    private String targetArch;
    private String keyname;
    private String description;
    private String summary;
    private String copyright;
    private String distribution;
    private File icon;
    private String vendor;
    private String url;
    private String group;
    private String packager;
    private List provides;
    private List requires;
    private List conflicts;
    private String prefix;
    private File workarea;
    private List mappings;
    private String preinstall;
    private File preinstallScript;
    private String postinstall;
    private File postinstallScript;
    private String install;
    private File installScript;
    private String preremove;
    private File preremoveScript;
    private String postremove;
    private File postremoveScript;
    private String verify;
    private File verifyScript;
    private String clean;
    private File cleanScript;
    private DirectoryArchiver copier;
    private Artifact artifact;
    private List attachedArtifacts;
    MavenProject project;
    private List defineStatements;
    private String defaultFilemode;
    private String defaultDirmode;
    private String defaultUsername;
    private String defaultGroupname;
    private File buildroot;
    private String version;

    AbstractRPMMojo() {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.checkParams();
        this.buildWorkArea();
        this.installFiles();
        this.writeSpecFile();
        this.buildPackage();
        this.afterExecution();
    }

    protected void afterExecution() throws MojoExecutionException, MojoFailureException {
    }

    protected File getRPMFile() {
        File rpms = new File(this.workarea, "RPMS");
        File archDir = new File(rpms, this.targetArch);
        return new File(archDir, this.name + '-' + this.version + '-' + this.release + '.' + this.targetArch + ".rpm");
    }

    private void buildPackage() throws MojoExecutionException {
        File f = new File(this.workarea, "SPECS");
        Commandline cl = new Commandline();
        cl.setExecutable("rpmbuild");
        cl.setWorkingDirectory(f.getAbsolutePath());
        cl.createArgument().setValue("-bb");
        cl.createArgument().setValue("--buildroot");
        cl.createArgument().setValue(this.buildroot.getAbsolutePath());
        cl.createArgument().setValue("--define");
        cl.createArgument().setValue("_topdir " + this.workarea.getAbsolutePath());
        cl.createArgument().setValue("--target");
        cl.createArgument().setValue(this.targetArch);
        if (this.keyname != null) {
            cl.createArgument().setValue("--define");
            cl.createArgument().setValue("_gpg_name " + this.keyname);
            cl.createArgument().setValue("--sign");
        }
        cl.createArgument().setValue(this.name + ".spec");
        StdoutConsumer stdout = new StdoutConsumer(this.getLog());
        StderrConsumer stderr = new StderrConsumer(this.getLog());
        try {
            int result;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("About to execute '" + cl.toString() + "'"));
            }
            if ((result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr)) != 0) {
                throw new MojoExecutionException("RPM build execution returned: '" + result + "' executing '" + cl.toString() + "'");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to build the RPM", (Exception)((Object)e));
        }
    }

    private void buildWorkArea() throws MojoFailureException {
        String[] topdirs = new String[]{"BUILD", "RPMS", "SOURCES", "SPECS", "SRPMS"};
        if (!this.workarea.exists()) {
            this.getLog().info((CharSequence)("Creating directory " + this.workarea.getAbsolutePath()));
            if (!this.workarea.mkdirs()) {
                throw new MojoFailureException("Unable to create directory " + this.workarea.getAbsolutePath());
            }
        }
        for (int i = 0; i < topdirs.length; ++i) {
            File d = new File(this.workarea, topdirs[i]);
            if (d.exists()) continue;
            this.getLog().info((CharSequence)("Creating directory " + d.getAbsolutePath()));
            if (d.mkdir()) continue;
            throw new MojoFailureException("Unable to create directory " + d.getAbsolutePath());
        }
        this.buildroot = new File(this.workarea, "buildroot");
        if (!this.buildroot.exists()) {
            this.getLog().info((CharSequence)("Creating directory " + this.buildroot.getAbsolutePath()));
            if (!this.buildroot.mkdir()) {
                throw new MojoFailureException("Unable to create directory " + this.buildroot.getAbsolutePath());
            }
        }
    }

    private void checkParams() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.debug((CharSequence)("project version = " + this.projversion));
        int modifierIndex = this.projversion.indexOf(45);
        if (modifierIndex == -1) {
            this.version = this.projversion;
            if (this.release == null || this.release.length() == 0) {
                this.release = "1";
                log.debug((CharSequence)"Release set to: 1");
            }
        } else {
            this.version = this.projversion.substring(0, modifierIndex);
            log.warn((CharSequence)("Version string truncated to " + this.version));
            if (this.release == null || this.release.length() == 0) {
                String modifier = this.projversion.substring(modifierIndex + 1, this.projversion.length());
                log.debug((CharSequence)("version modifier = " + modifier));
                modifier = modifier.replace('-', '_');
                if (modifier.endsWith("SNAPSHOT")) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    modifier = modifier + simpleDateFormat.format(new Date());
                } else {
                    modifier = modifier + "_1";
                }
                this.release = modifier;
                log.debug((CharSequence)("Release set to: " + modifier));
            }
        }
        this.targetArch = this.needarch == null || this.needarch.length() == 0 || "false".equalsIgnoreCase(this.needarch) ? "noarch" : ("true".equalsIgnoreCase(this.needarch) ? System.getProperty("os.arch") : this.needarch);
        log.debug((CharSequence)("targetArch = " + this.targetArch));
        Iterator it = this.mappings.iterator();
        while (it.hasNext()) {
            Mapping map = (Mapping)it.next();
            if (map.getDirectory() == null) {
                throw new MojoFailureException("<mapping> element must contain the destination directory");
            }
            if (map.getSources() == null) continue;
            Iterator sit = map.getSources().iterator();
            while (sit.hasNext()) {
                Source src = (Source)sit.next();
                if (src.getLocation() != null) continue;
                throw new MojoFailureException("<mapping><source> tag must contain the source directory");
            }
        }
        if (this.preinstall == null && this.preinstallScript != null) {
            this.preinstall = this.readFile(this.preinstallScript);
        }
        if (this.install == null && this.installScript != null) {
            this.install = this.readFile(this.installScript);
        }
        if (this.postinstall == null && this.postinstallScript != null) {
            this.postinstall = this.readFile(this.postinstallScript);
        }
        if (this.preremove == null && this.preremoveScript != null) {
            this.preremove = this.readFile(this.preremoveScript);
        }
        if (this.postremove == null && this.postremoveScript != null) {
            this.postremove = this.readFile(this.postremoveScript);
        }
        if (this.verify == null && this.verifyScript != null) {
            this.verify = this.readFile(this.verifyScript);
        }
        if (this.clean == null && this.cleanScript != null) {
            this.clean = this.readFile(this.cleanScript);
        }
    }

    private void copyArtifact(Artifact art, File dest) throws MojoExecutionException {
        if (art.getFile() == null) {
            this.getLog().warn((CharSequence)("Artifact " + art + " requested in configuration."));
            this.getLog().warn((CharSequence)"Plugin must run in standard lifecycle for this to work.");
            return;
        }
        this.copySource(art.getFile(), dest, null, null);
    }

    private List copySource(File src, File dest, List incl, List excl) throws MojoExecutionException {
        try {
            this.copier.setDestFile(dest);
            if (src.isDirectory()) {
                String[] ia = null;
                if (incl != null) {
                    ia = incl.toArray(new String[0]);
                }
                String[] ea = null;
                if (excl != null) {
                    ea = excl.toArray(new String[0]);
                }
                this.copier.addDirectory(src, "", ia, ea);
            } else {
                this.copier.addFile(src, src.getName());
            }
            this.copier.createArchive();
            Map copiedFilesMap = this.copier.getFiles();
            ArrayList<String> copiedFiles = new ArrayList<String>(copiedFilesMap.size());
            Iterator i = copiedFilesMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (key == null || key.length() <= 0) continue;
                copiedFiles.add(key);
            }
            this.copier.resetArchiver();
            return copiedFiles;
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Unable to copy files for packaging: " + t.getMessage(), t);
        }
    }

    private boolean depMatcher(Artifact dep, List list) {
        if (list == null) {
            return false;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Artifact item = (Artifact)it.next();
            this.getLog().debug((CharSequence)("Compare " + dep + " to " + item));
            if (!StringUtils.isEmpty((String)item.getGroupId()) && !item.getGroupId().equals(dep.getGroupId())) continue;
            this.getLog().debug((CharSequence)"... Group matches");
            if (!StringUtils.isEmpty((String)item.getArtifactId()) && !item.getArtifactId().equals(dep.getArtifactId())) continue;
            this.getLog().debug((CharSequence)"... Artifact matches");
            try {
                if (!item.getVersionRange().containsVersion(dep.getSelectedVersion())) continue;
                this.getLog().debug((CharSequence)"... Version matches");
                return true;
            }
            catch (OverConstrainedVersionException ocve) {
                this.getLog().debug((CharSequence)"... caught OverConstrainedVersionException");
            }
        }
        return false;
    }

    private void installFiles() throws MojoExecutionException {
        if (this.icon != null) {
            File icondest = new File(this.workarea, "SOURCES");
            this.copySource(this.icon, icondest, null, null);
        }
        Iterator it = this.mappings.iterator();
        while (it.hasNext()) {
            Dependency dep;
            Mapping map = (Mapping)it.next();
            File dest = new File(this.buildroot + map.getDestination());
            if (map.isDirOnly()) {
                if (dest.exists()) continue;
                this.getLog().info((CharSequence)("Creating empty directory " + dest.getAbsolutePath()));
                if (dest.mkdirs()) continue;
                throw new MojoExecutionException("Unable to create " + dest.getAbsolutePath());
            }
            this.processSources(map, dest);
            ArtifactMap art = map.getArtifact();
            if (art != null) {
                List artlist = this.selectArtifacts(art);
                Iterator ait = artlist.iterator();
                while (ait.hasNext()) {
                    Artifact artifactInstance = (Artifact)ait.next();
                    this.copyArtifact(artifactInstance, dest);
                    map.addCopiedFileNameRelativeToDestination(artifactInstance.getFile().getName());
                }
            }
            if ((dep = map.getDependency()) != null) {
                List deplist = this.selectDependencies(dep);
                Iterator dit = deplist.iterator();
                while (dit.hasNext()) {
                    Artifact artifactInstance = (Artifact)dit.next();
                    this.copyArtifact(artifactInstance, dest);
                    map.addCopiedFileNameRelativeToDestination(artifactInstance.getFile().getName());
                }
            }
            if (!map.getCopiedFileNamesRelativeToDestination().isEmpty()) continue;
            this.getLog().info((CharSequence)("Mapping empty with destination: " + dest.getName()));
            if (dest.exists()) continue;
            this.getLog().info((CharSequence)("Creating empty directory " + dest.getAbsolutePath()));
            if (dest.mkdirs()) continue;
            throw new MojoExecutionException("Unable to create " + dest.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSources(Mapping map, File dest) throws MojoExecutionException {
        List srcs = map.getSources();
        if (srcs != null) {
            Iterator sit = srcs.iterator();
            while (sit.hasNext()) {
                Source src = (Source)sit.next();
                if (!src.matchesArchitecture(this.targetArch)) {
                    this.getLog().debug((CharSequence)("Source does not match target architecture: " + src.toString()));
                    continue;
                }
                File location = src.getLocation();
                if (location.exists()) {
                    String destination = src.getDestination();
                    if (destination == null) {
                        ArrayList elist = src.getExcludes();
                        if (!src.getNoDefaultExcludes()) {
                            if (elist == null) {
                                elist = new ArrayList();
                            }
                            elist.addAll(FileUtils.getDefaultExcludesAsList());
                        }
                        List copiedFiles = this.copySource(src.getLocation(), dest, src.getIncludes(), elist);
                        map.addCopiedFileNamesRelativeToDestination(copiedFiles);
                        continue;
                    }
                    if (!location.isFile()) {
                        throw new MojoExecutionException(MessageFormat.format(DESTINATION_DIRECTORY_ERROR_MSG, destination, location.getName()));
                    }
                    File destFile = new File(dest, destination);
                    try {
                        if (!destFile.createNewFile()) {
                            throw new IOException("Unable to create file: " + destFile.getAbsolutePath());
                        }
                        FileInputStream fis = new FileInputStream(location);
                        try {
                            FileOutputStream fos = new FileOutputStream(destFile);
                            try {
                                fis.getChannel().transferTo(0L, location.length(), fos.getChannel());
                            }
                            finally {
                                fos.close();
                            }
                        }
                        finally {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Unable to copy files", (Exception)e);
                    }
                    map.addCopiedFileNameRelativeToDestination(destination);
                    continue;
                }
                throw new MojoExecutionException("Source location " + location + " does not exist");
            }
        }
    }

    private String readFile(File in) throws MojoExecutionException {
        try {
            StringBuffer sb = new StringBuffer();
            BufferedReader br = new BufferedReader(new FileReader(in));
            while (br.ready()) {
                String line = br.readLine();
                sb.append(line + "\n");
            }
            br.close();
            return sb.toString();
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Unable to read " + in.getAbsolutePath(), t);
        }
    }

    private List selectArtifacts(ArtifactMap am) {
        ArrayList<Artifact> retval = new ArrayList<Artifact>();
        List clist = am.getClassifiers();
        if (clist == null) {
            retval.add(this.artifact);
            retval.addAll(this.attachedArtifacts);
        } else {
            if (clist.contains(null)) {
                retval.add(this.artifact);
            }
            Iterator ait = this.attachedArtifacts.iterator();
            while (ait.hasNext()) {
                Artifact aa = (Artifact)ait.next();
                if (!aa.hasClassifier() || !clist.contains(aa.getClassifier())) continue;
                retval.add(aa);
            }
        }
        return retval;
    }

    private List selectDependencies(Dependency d) {
        ArrayList<Artifact> retval = new ArrayList<Artifact>();
        List inc = d.getIncludes();
        List exc = d.getExcludes();
        Set deps = this.project.getArtifacts();
        if (deps == null || deps.isEmpty()) {
            return retval;
        }
        Iterator it = deps.iterator();
        while (it.hasNext()) {
            Artifact pdep = (Artifact)it.next();
            this.getLog().debug((CharSequence)("Dependency is " + pdep + " at " + pdep.getFile()));
            if (this.depMatcher(pdep, exc)) continue;
            this.getLog().debug((CharSequence)"--> not excluded");
            if (inc != null && !this.depMatcher(pdep, inc)) continue;
            this.getLog().debug((CharSequence)"--> included");
            retval.add(pdep);
        }
        return retval;
    }

    private void writeSpecFile() throws MojoExecutionException {
        File f = new File(this.workarea, "SPECS");
        File specf = new File(f, this.name + ".spec");
        try {
            String copyrightText;
            this.getLog().info((CharSequence)("Creating spec file " + specf.getAbsolutePath()));
            PrintWriter spec = new PrintWriter(new FileWriter(specf));
            AbstractRPMMojo.writeList(spec, this.defineStatements, "%define ");
            spec.println("Name: " + this.name);
            spec.println("Version: " + this.version);
            spec.println("Release: " + this.release);
            if (this.summary != null) {
                spec.println("Summary: " + this.summary);
            }
            if ((copyrightText = this.copyright) == null) {
                copyrightText = this.generateCopyrightText();
            }
            if (copyrightText != null) {
                spec.println("License: " + copyrightText);
            }
            if (this.distribution != null) {
                spec.println("Distribution: " + this.distribution);
            }
            if (this.icon != null) {
                spec.println("Icon: " + this.icon.getName());
            }
            if (this.vendor != null) {
                spec.println("Vendor: " + this.vendor);
            }
            if (this.url != null) {
                spec.println("URL: " + this.url);
            }
            if (this.group != null) {
                spec.println("Group: " + this.group);
            }
            if (this.packager != null) {
                spec.println("Packager: " + this.packager);
            }
            AbstractRPMMojo.writeList(spec, this.provides, "Provides: ");
            AbstractRPMMojo.writeList(spec, this.requires, "Requires: ");
            AbstractRPMMojo.writeList(spec, this.conflicts, "Conflicts: ");
            if (this.prefix != null) {
                spec.println("Prefix: " + this.prefix);
            }
            spec.println("BuildRoot: " + this.buildroot.getAbsolutePath());
            spec.println();
            spec.println("%description");
            if (this.description != null) {
                spec.println(this.description);
            }
            spec.println();
            spec.println("%files");
            spec.println(this.getDefAttrString());
            Iterator it = this.mappings.iterator();
            while (it.hasNext()) {
                Mapping map = (Mapping)it.next();
                List includes = map.getCopiedFileNamesRelativeToDestination();
                DirectoryScanner scanner = new DirectoryScanner();
                String destination = map.getDestination();
                scanner.setBasedir(this.buildroot.getAbsolutePath() + destination);
                scanner.setIncludes(includes.isEmpty() ? null : includes.toArray(new String[includes.size()]));
                scanner.setExcludes(null);
                scanner.scan();
                String attrString = map.getAttrString();
                if (scanner.isEverythingIncluded() && map.isDirectoryIncluded()) {
                    this.getLog().debug((CharSequence)("writing attriute string for directory: " + destination));
                    spec.println(attrString + " " + destination);
                    continue;
                }
                this.getLog().debug((CharSequence)("writing attribute string for identified files in directory: " + destination));
                String[] files = scanner.getIncludedFiles();
                String baseFileString = attrString + " " + destination + File.separatorChar;
                for (int i = 0; i < files.length; ++i) {
                    spec.println(baseFileString + files[i]);
                }
            }
            this.printScripts(spec);
            spec.close();
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Unable to write " + specf.getAbsolutePath(), t);
        }
    }

    private void printScripts(PrintWriter writer) {
        if (this.preinstall != null) {
            writer.println();
            writer.println("%pre");
            writer.println(this.preinstall);
        }
        if (this.install != null) {
            writer.println();
            writer.println("%install");
            writer.println(this.install);
        }
        if (this.postinstall != null) {
            writer.println();
            writer.println("%post");
            writer.println(this.postinstall);
        }
        if (this.preremove != null) {
            writer.println();
            writer.println("%preun");
            writer.println(this.preremove);
        }
        if (this.postremove != null) {
            writer.println();
            writer.println("%postun");
            writer.println(this.postremove);
        }
        if (this.verify != null) {
            writer.println();
            writer.println("%verifyscript");
            writer.println(this.verify);
        }
        if (this.clean != null) {
            writer.println();
            writer.println("%clean");
            writer.println(this.clean);
        }
    }

    private static void writeList(PrintWriter writer, List strings, String prefix) {
        if (strings != null) {
            Iterator it = strings.iterator();
            while (it.hasNext()) {
                writer.print(prefix);
                writer.println(it.next());
            }
        }
    }

    private String generateCopyrightText() {
        String organization;
        String year = this.project.getInceptionYear();
        String string = organization = this.project.getOrganization() == null ? null : this.project.getOrganization().getName();
        String copyrightText = year != null && organization != null ? year + " " + organization : (year == null ? organization : year);
        return copyrightText;
    }

    private String getDefAttrString() {
        if (this.defaultFilemode == null && this.defaultUsername == null && this.defaultGroupname == null && this.defaultDirmode == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.defaultFilemode != null) {
            sb.append("%defattr(").append(this.defaultFilemode).append(",");
        } else {
            sb.append("%defattr(-,");
        }
        if (this.defaultUsername != null) {
            sb.append(this.defaultUsername).append(",");
        } else {
            sb.append("-,");
        }
        if (this.defaultGroupname != null) {
            sb.append(this.defaultGroupname).append(",");
        } else {
            sb.append("-,");
        }
        if (this.defaultDirmode != null) {
            sb.append(this.defaultDirmode).append(")");
        } else {
            sb.append("-)");
        }
        return sb.toString();
    }

    private class StderrConsumer
    implements StreamConsumer {
        private Log logger;

        public StderrConsumer(Log log) {
            this.logger = log;
        }

        public void consumeLine(String string) {
            this.logger.warn((CharSequence)string);
        }
    }

    private class StdoutConsumer
    implements StreamConsumer {
        private Log logger;

        public StdoutConsumer(Log log) {
            this.logger = log;
        }

        public void consumeLine(String string) {
            this.logger.info((CharSequence)string);
        }
    }
}

