/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:rpm-maven-plugin:2.0-beta-2", 0);
        this.append(sb, "", 0);
        this.append(sb, "RPM Maven Plugin 2.0-beta-2", 0);
        this.append(sb, "Maven plugin which assembles files into an RPM package for installation on various target UNIX systems.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "attached-rpm".equals(this.goal)) {
            this.append(sb, "rpm:attached-rpm", 0);
            this.append(sb, "Construct the RPM file and attaches it as a secondary artifact.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "The classifier for the rpm secondary artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "clean", 2);
                this.append(sb, "The clean script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cleanScript", 2);
                this.append(sb, "The location of the clean script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "conflicts", 2);
                this.append(sb, "The list of conflicts for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "copyright", 2);
                this.append(sb, "The one-line copyright information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultDirmode", 2);
                this.append(sb, "The default directory mode (octal string) to assign to directories when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultFilemode", 2);
                this.append(sb, "The default file mode (octal string) to assign to files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultGroupname", 2);
                this.append(sb, "The default group name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultUsername", 2);
                this.append(sb, "The default user name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defineStatements", 2);
                this.append(sb, "A list of %define arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "description", 2);
                this.append(sb, "The long description of the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "distribution", 2);
                this.append(sb, "The distribution containing this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "group", 2);
                this.append(sb, "The package group for the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "icon", 2);
                this.append(sb, "An icon for the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "install", 2);
                this.append(sb, "The installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "installScript", 2);
                this.append(sb, "The location of the installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keyname", 2);
                this.append(sb, "Set to a key name to sign the package using GPG. Note that due to RPM limitations, this always requires input from the terminal even if the key has no passphrase.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mappings", 2);
                this.append(sb, "The list of file mappings.", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name portion of the output file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "needarch", 2);
                this.append(sb, "The target architecture for the rpm. The default value is noarch.\nFor passivity purposes, a value of true or false will indicate whether the architecture of the build machine will be used. Any other value (such as x86_64) will set the architecture of the rpm to x86_64.\n\nThis can also be used in conjunction with Source targetArchitecture to flex the contents of the rpm based on the architecture.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "packager", 2);
                this.append(sb, "The name of the person or group creating the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postinstall", 2);
                this.append(sb, "The post-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postinstallScript", 2);
                this.append(sb, "The location of the post-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postremove", 2);
                this.append(sb, "The post-removal script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postremoveScript", 2);
                this.append(sb, "The location of the post-removal script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prefix", 2);
                this.append(sb, "The relocation prefix for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preinstall", 2);
                this.append(sb, "The pre-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preinstallScript", 2);
                this.append(sb, "The location of the pre-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preremove", 2);
                this.append(sb, "The pre-removal script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preremoveScript", 2);
                this.append(sb, "The location of the pre-removal script. protected", 3);
                this.append(sb, "", 0);
                this.append(sb, "projversion", 2);
                this.append(sb, "The version portion of the RPM file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "provides", 2);
                this.append(sb, "The list of virtual packages provided by this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "release", 2);
                this.append(sb, "The release portion of the RPM file name.\nBeginning with 2.0-beta-2, this is an optional parameter. By default, the release will be generated from the modifier portion of the project version using the following rules:\n\n-\tIf no modifier exists, the release will be 1.\n-\tIf the modifier ends with SNAPSHOT, the timestamp (in UTC) of the build will be appended to end.\n-\tAll instances of '-' in the modifier will be replaced with '_'.\n-\tIf a modifier exists and does not end with SNAPSHOT, '_1' will be appended to end.\n\n\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "requires", 2);
                this.append(sb, "The list of requirements for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "summary", 2);
                this.append(sb, "The one-line description of the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "A URL for the vendor.", 3);
                this.append(sb, "", 0);
                this.append(sb, "vendor", 2);
                this.append(sb, "The vendor supplying the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verify", 2);
                this.append(sb, "The verification script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyScript", 2);
                this.append(sb, "The location of the verification script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workarea", 2);
                this.append(sb, "The area for RPM to use for building the package.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "rpm:help", 0);
            this.append(sb, "Display help information on rpm-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0rpm:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "rpm".equals(this.goal)) {
            this.append(sb, "rpm:rpm", 0);
            this.append(sb, "Construct the RPM file.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "clean", 2);
                this.append(sb, "The clean script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cleanScript", 2);
                this.append(sb, "The location of the clean script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "conflicts", 2);
                this.append(sb, "The list of conflicts for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "copyright", 2);
                this.append(sb, "The one-line copyright information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultDirmode", 2);
                this.append(sb, "The default directory mode (octal string) to assign to directories when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultFilemode", 2);
                this.append(sb, "The default file mode (octal string) to assign to files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultGroupname", 2);
                this.append(sb, "The default group name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultUsername", 2);
                this.append(sb, "The default user name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defineStatements", 2);
                this.append(sb, "A list of %define arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "description", 2);
                this.append(sb, "The long description of the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "distribution", 2);
                this.append(sb, "The distribution containing this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "group", 2);
                this.append(sb, "The package group for the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "icon", 2);
                this.append(sb, "An icon for the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "install", 2);
                this.append(sb, "The installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "installScript", 2);
                this.append(sb, "The location of the installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keyname", 2);
                this.append(sb, "Set to a key name to sign the package using GPG. Note that due to RPM limitations, this always requires input from the terminal even if the key has no passphrase.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mappings", 2);
                this.append(sb, "The list of file mappings.", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name portion of the output file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "needarch", 2);
                this.append(sb, "The target architecture for the rpm. The default value is noarch.\nFor passivity purposes, a value of true or false will indicate whether the architecture of the build machine will be used. Any other value (such as x86_64) will set the architecture of the rpm to x86_64.\n\nThis can also be used in conjunction with Source targetArchitecture to flex the contents of the rpm based on the architecture.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "packager", 2);
                this.append(sb, "The name of the person or group creating the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postinstall", 2);
                this.append(sb, "The post-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postinstallScript", 2);
                this.append(sb, "The location of the post-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postremove", 2);
                this.append(sb, "The post-removal script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postremoveScript", 2);
                this.append(sb, "The location of the post-removal script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prefix", 2);
                this.append(sb, "The relocation prefix for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preinstall", 2);
                this.append(sb, "The pre-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preinstallScript", 2);
                this.append(sb, "The location of the pre-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preremove", 2);
                this.append(sb, "The pre-removal script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preremoveScript", 2);
                this.append(sb, "The location of the pre-removal script. protected", 3);
                this.append(sb, "", 0);
                this.append(sb, "projversion", 2);
                this.append(sb, "The version portion of the RPM file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "provides", 2);
                this.append(sb, "The list of virtual packages provided by this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "release", 2);
                this.append(sb, "The release portion of the RPM file name.\nBeginning with 2.0-beta-2, this is an optional parameter. By default, the release will be generated from the modifier portion of the project version using the following rules:\n\n-\tIf no modifier exists, the release will be 1.\n-\tIf the modifier ends with SNAPSHOT, the timestamp (in UTC) of the build will be appended to end.\n-\tAll instances of '-' in the modifier will be replaced with '_'.\n-\tIf a modifier exists and does not end with SNAPSHOT, '_1' will be appended to end.\n\n\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "requires", 2);
                this.append(sb, "The list of requirements for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "summary", 2);
                this.append(sb, "The one-line description of the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "A URL for the vendor.", 3);
                this.append(sb, "", 0);
                this.append(sb, "vendor", 2);
                this.append(sb, "The vendor supplying the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verify", 2);
                this.append(sb, "The verification script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyScript", 2);
                this.append(sb, "The location of the verification script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workarea", 2);
                this.append(sb, "The area for RPM to use for building the package.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

