/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.mojo.rpm.ArtifactMap;
import org.codehaus.mojo.rpm.Dependency;

public class Mapping {
    private String directory;
    private String configuration;
    private boolean documentation;
    private String filemode;
    private String username;
    private String groupname;
    private List sources;
    private ArtifactMap artifact;
    private Dependency dependency;
    private boolean directoryIncluded = true;
    private List copiedFileNamesRelativeToDestination;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String dir) {
        this.directory = dir;
    }

    public boolean isDirectoryIncluded() {
        return this.directoryIncluded;
    }

    public void setDirectoryIncluded(boolean directoryIncluded) {
        this.directoryIncluded = directoryIncluded;
    }

    public boolean isConfiguration() {
        return this.configuration == null || !"FALSE".equalsIgnoreCase(this.configuration);
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String cfg) {
        this.configuration = cfg;
    }

    public boolean isDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(boolean isDoc) {
        this.documentation = isDoc;
    }

    public String getFilemode() {
        return this.filemode;
    }

    public void setFilemode(String fmode) {
        this.filemode = fmode;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String uname) {
        this.username = uname;
    }

    public String getGroupname() {
        return this.groupname;
    }

    public void setGroupname(String grpname) {
        this.groupname = grpname;
    }

    public List getSources() {
        return this.sources;
    }

    public void setSources(List srclist) {
        this.sources = srclist;
    }

    public ArtifactMap getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ArtifactMap am) {
        this.artifact = am;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency am) {
        this.dependency = am;
    }

    public String getAttrString() {
        StringBuffer sb = new StringBuffer();
        if (this.configuration != null && !"FALSE".equalsIgnoreCase(this.configuration)) {
            sb.append("%config");
            if (this.configuration.length() > 0 && !"TRUE".equalsIgnoreCase(this.configuration)) {
                sb.append('(');
                sb.append(this.configuration);
                sb.append(')');
            }
            sb.append(' ');
        }
        if (this.documentation) {
            sb.append("%doc ");
        }
        if ((this.sources == null || this.sources.size() == 0) && this.dependency == null && this.artifact == null) {
            sb.append("%dir ");
        }
        if (this.filemode != null || this.username != null || this.groupname != null) {
            if (this.filemode != null) {
                sb.append("%attr(" + this.filemode + ",");
            } else {
                sb.append("%attr(-,");
            }
            if (this.username != null) {
                sb.append(this.username + ",");
            } else {
                sb.append("-,");
            }
            if (this.groupname != null) {
                sb.append(this.groupname + ")");
            } else {
                sb.append("-)");
            }
        }
        return sb.toString();
    }

    public String getDestination() {
        if (this.directory == null) {
            return "nowhere";
        }
        return this.directory;
    }

    public boolean isDirOnly() {
        if (this.sources != null && !this.sources.isEmpty()) {
            return false;
        }
        if (this.artifact != null) {
            return false;
        }
        return this.dependency == null;
    }

    List getCopiedFileNamesRelativeToDestination() {
        return this.copiedFileNamesRelativeToDestination != null ? this.copiedFileNamesRelativeToDestination : Collections.EMPTY_LIST;
    }

    void addCopiedFileNamesRelativeToDestination(List copiedFileNamesRelativeToDestination) {
        if (this.copiedFileNamesRelativeToDestination == null) {
            this.copiedFileNamesRelativeToDestination = new ArrayList(copiedFileNamesRelativeToDestination);
        } else {
            this.copiedFileNamesRelativeToDestination.addAll(copiedFileNamesRelativeToDestination);
        }
    }

    void addCopiedFileNameRelativeToDestination(String copiedFileNameRelativeToDestination) {
        if (this.copiedFileNamesRelativeToDestination == null) {
            this.copiedFileNamesRelativeToDestination = new LinkedList();
        }
        this.copiedFileNamesRelativeToDestination.add(copiedFileNameRelativeToDestination);
    }

    public String toString() {
        boolean sourceShown = false;
        StringBuffer sb = new StringBuffer();
        sb.append("[\"" + this.getDestination() + "\" ");
        sb.append("{" + this.getAttrString() + "}");
        if (this.isDirOnly()) {
            sb.append(" (dir only)]");
        } else {
            sb.append(" from ");
            if (this.sources != null) {
                sb.append(this.sources.toString());
                sourceShown = true;
            }
            if (this.artifact != null) {
                if (sourceShown) {
                    sb.append(", ");
                }
                sb.append(this.artifact.toString());
                sourceShown = true;
            }
            if (this.dependency != null) {
                if (sourceShown) {
                    sb.append(", ");
                }
                sb.append(this.dependency.toString());
                sourceShown = true;
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

