/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:rpm-maven-plugin:2.0.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "RPM Maven Plugin", 0);
        this.append(sb, "Maven plugin which assembles files into an RPM package for installation on various target UNIX systems.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "attached-rpm".equals(this.goal)) {
            this.append(sb, "rpm:attached-rpm", 0);
            this.append(sb, "Construct the RPM file and attaches it as a secondary artifact.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "autoProvides (Default: true)", 2);
                this.append(sb, "Automatically add provided shared libraries.", 3);
                this.append(sb, "", 0);
                this.append(sb, "autoRequires (Default: true)", 2);
                this.append(sb, "Automatically add requirements deduced from included shared libraries.", 3);
                this.append(sb, "", 0);
                this.append(sb, "changelogFile", 2);
                this.append(sb, "The changelog file. If the file does not exist, it is ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "The classifier for the rpm secondary artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "clean", 2);
                this.append(sb, "Deprecated. Use cleanScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The clean script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cleanScript", 2);
                this.append(sb, "Deprecated. Use cleanScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the clean script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "cleanScriptlet", 2);
                this.append(sb, "The clean scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "conflicts", 2);
                this.append(sb, "The list of conflicts for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "copyright", 2);
                this.append(sb, "The one-line copyright information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultDirmode", 2);
                this.append(sb, "The default directory mode (octal string) to assign to directories when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultFilemode", 2);
                this.append(sb, "The default file mode (octal string) to assign to files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultGroupname", 2);
                this.append(sb, "The default group name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultUsername", 2);
                this.append(sb, "The default user name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defineStatements", 2);
                this.append(sb, "A list of %define arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "description", 2);
                this.append(sb, "The long description of the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "disabled", 2);
                this.append(sb, "Indicates if the execution should be disabled. If true, nothing will occur during execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "distribution", 2);
                this.append(sb, "The distribution containing this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeString", 2);
                this.append(sb, "Expression preceded with the String won't be interpolated \\${foo} will be replaced with ${foo}", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "Filters (property files) to include during the interpolation of the pom.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "group", 2);
                this.append(sb, "The package group for the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "icon", 2);
                this.append(sb, "An icon for the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "install", 2);
                this.append(sb, "Deprecated. Use installScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "installScript", 2);
                this.append(sb, "Deprecated. Use installScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "installScriptlet", 2);
                this.append(sb, "The installation scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keyname", 2);
                this.append(sb, "Set to a key name to sign the package using GPG. If keyPassphrase is not also provided, this will require the input of the passphrase at the terminal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keyPassphrase", 2);
                this.append(sb, "The passphrase for the keyname to sign the rpm. This utilizes expect and requires that expect be on the PATH.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mappings", 2);
                this.append(sb, "The list of file mappings.", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name portion of the output file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "needarch", 2);
                this.append(sb, "The target architecture for the rpm. The default value is noarch.\nFor passivity purposes, a value of true or false will indicate whether the architecture of the build machine will be used. Any other value (such as x86_64) will set the architecture of the rpm to x86_64.\n\nThis can also be used in conjunction with Source targetArchitecture to flex the contents of the rpm based on the architecture.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "obsoletes", 2);
                this.append(sb, "The list of obsoletes for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packager", 2);
                this.append(sb, "The name of the person or group creating the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postinstall", 2);
                this.append(sb, "Deprecated. Use postinstallScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The post-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postinstallScript", 2);
                this.append(sb, "Deprecated. Use postinstallScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the post-installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "postinstallScriptlet", 2);
                this.append(sb, "The post install scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postremove", 2);
                this.append(sb, "Deprecated. Use postremoveScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The post-removal script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postremoveScript", 2);
                this.append(sb, "Deprecated. Use postremoveScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the post-removal script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "postremoveScriptlet", 2);
                this.append(sb, "The post-removal scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "posttransScriptlet", 2);
                this.append(sb, "The posttrans script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prefix", 2);
                this.append(sb, "The relocation prefix for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preinstall", 2);
                this.append(sb, "Deprecated. Use preinstallScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The pre-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preinstallScript", 2);
                this.append(sb, "Deprecated. Use preinstallScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the pre-installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "preinstallScriptlet", 2);
                this.append(sb, "The pre-installation scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prepare", 2);
                this.append(sb, "Deprecated. Use prepareScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The prepare script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prepareScript", 2);
                this.append(sb, "Deprecated. Use prepareScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the prepare script. A File which does not exist is ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prepareScriptlet", 2);
                this.append(sb, "The prepare scriptlet;", 3);
                this.append(sb, "", 0);
                this.append(sb, "preremove", 2);
                this.append(sb, "Deprecated. Use preremoveScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The pre-removal script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preremoveScript", 2);
                this.append(sb, "Deprecated. Use preremoveScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the pre-removal script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "preremoveScriptlet", 2);
                this.append(sb, "The pre-removal scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prereqs", 2);
                this.append(sb, "The list of prerequisites for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pretransScriptlet", 2);
                this.append(sb, "The pretrans scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "projversion", 2);
                this.append(sb, "The version portion of the RPM file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "provides", 2);
                this.append(sb, "The list of virtual packages provided by this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "release", 2);
                this.append(sb, "The release portion of the RPM file name.\nBeginning with 2.0-beta-2, this is an optional parameter. By default, the release will be generated from the modifier portion of the project version using the following rules:\n\n-\tIf no modifier exists, the release will be 1.\n-\tIf the modifier ends with SNAPSHOT, the timestamp (in UTC) of the build will be appended to end.\n-\tAll instances of '-' in the modifier will be replaced with '_'.\n-\tIf a modifier exists and does not end with SNAPSHOT, '_1' will be appended to end.\n\n\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "requires", 2);
                this.append(sb, "The list of requirements for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "summary", 2);
                this.append(sb, "The one-line description of the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetOS", 2);
                this.append(sb, "The target os for building the RPM. By default, this will be populated to Os.OS_NAME.\nThis can be used in conjunction with Source targetOSName to flex the contents of the rpm based on operating system.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetVendor", 2);
                this.append(sb, "The target vendor for building the RPM. By default, this will be populated to the result of rpm -E %{_host_vendor}.", 3);
                this.append(sb, "", 0);
                this.append(sb, "triggers", 2);
                this.append(sb, "The list of triggers to take place on installation of other packages.\n\u00a0<triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0<installTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<subpackage>optional</subpackage>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<program>program\u00a0to\u00a0execute\u00a0(if\u00a0not\u00a0shell)\u00a0optional</program>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<script>actual\u00a0contents\u00a0of\u00a0script\u00a0-\u00a0optional</script>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<scriptFile>location\u00a0of\u00a0file\u00a0containing\u00a0script\u00a0-\u00a0optional</script>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<fileEncoding>character\u00a0encoding\u00a0for\u00a0script\u00a0file\u00a0-\u00a0recommended</fileEncoding>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<trigger>package/version\u00a0to\u00a0trigger\u00a0on\u00a0(i.e.\u00a0jre\u00a0>\u00a01.5)</trigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0</installTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0<removeTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0</removeTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0<postRemoveTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0</postRemoveTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0</triggers>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "A URL for the vendor.", 3);
                this.append(sb, "", 0);
                this.append(sb, "vendor", 2);
                this.append(sb, "The vendor supplying the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verify", 2);
                this.append(sb, "Deprecated. Use verifyScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The verification script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyScript", 2);
                this.append(sb, "Deprecated. Use verifyScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the verification script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyScriptlet", 2);
                this.append(sb, "The verify scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workarea", 2);
                this.append(sb, "The area for RPM to use for building the package.\nNOTE: The absolute path to the workarea MUST NOT have a space in any of the directory names.\nBeginning with release 2.0-beta-3, sub-directories will be created within the workarea for each execution of the plugin within a life cycle.\nThe pattern will be workarea/name[-classifier].\nThe classifier portion is only applicable for the attached-rpm goal.\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "rpm:help", 0);
            this.append(sb, "Display help information on rpm-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0rpm:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "rpm".equals(this.goal)) {
            this.append(sb, "rpm:rpm", 0);
            this.append(sb, "Construct the RPM file.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "autoProvides (Default: true)", 2);
                this.append(sb, "Automatically add provided shared libraries.", 3);
                this.append(sb, "", 0);
                this.append(sb, "autoRequires (Default: true)", 2);
                this.append(sb, "Automatically add requirements deduced from included shared libraries.", 3);
                this.append(sb, "", 0);
                this.append(sb, "changelogFile", 2);
                this.append(sb, "The changelog file. If the file does not exist, it is ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "clean", 2);
                this.append(sb, "Deprecated. Use cleanScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The clean script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cleanScript", 2);
                this.append(sb, "Deprecated. Use cleanScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the clean script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "cleanScriptlet", 2);
                this.append(sb, "The clean scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "conflicts", 2);
                this.append(sb, "The list of conflicts for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "copyright", 2);
                this.append(sb, "The one-line copyright information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultDirmode", 2);
                this.append(sb, "The default directory mode (octal string) to assign to directories when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultFilemode", 2);
                this.append(sb, "The default file mode (octal string) to assign to files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultGroupname", 2);
                this.append(sb, "The default group name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultUsername", 2);
                this.append(sb, "The default user name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defineStatements", 2);
                this.append(sb, "A list of %define arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "description", 2);
                this.append(sb, "The long description of the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "disabled", 2);
                this.append(sb, "Indicates if the execution should be disabled. If true, nothing will occur during execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "distribution", 2);
                this.append(sb, "The distribution containing this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeString", 2);
                this.append(sb, "Expression preceded with the String won't be interpolated \\${foo} will be replaced with ${foo}", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "Filters (property files) to include during the interpolation of the pom.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "group", 2);
                this.append(sb, "The package group for the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "icon", 2);
                this.append(sb, "An icon for the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "install", 2);
                this.append(sb, "Deprecated. Use installScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "installScript", 2);
                this.append(sb, "Deprecated. Use installScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "installScriptlet", 2);
                this.append(sb, "The installation scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keyname", 2);
                this.append(sb, "Set to a key name to sign the package using GPG. If keyPassphrase is not also provided, this will require the input of the passphrase at the terminal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keyPassphrase", 2);
                this.append(sb, "The passphrase for the keyname to sign the rpm. This utilizes expect and requires that expect be on the PATH.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mappings", 2);
                this.append(sb, "The list of file mappings.", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name portion of the output file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "needarch", 2);
                this.append(sb, "The target architecture for the rpm. The default value is noarch.\nFor passivity purposes, a value of true or false will indicate whether the architecture of the build machine will be used. Any other value (such as x86_64) will set the architecture of the rpm to x86_64.\n\nThis can also be used in conjunction with Source targetArchitecture to flex the contents of the rpm based on the architecture.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "obsoletes", 2);
                this.append(sb, "The list of obsoletes for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packager", 2);
                this.append(sb, "The name of the person or group creating the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postinstall", 2);
                this.append(sb, "Deprecated. Use postinstallScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The post-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postinstallScript", 2);
                this.append(sb, "Deprecated. Use postinstallScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the post-installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "postinstallScriptlet", 2);
                this.append(sb, "The post install scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postremove", 2);
                this.append(sb, "Deprecated. Use postremoveScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The post-removal script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postremoveScript", 2);
                this.append(sb, "Deprecated. Use postremoveScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the post-removal script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "postremoveScriptlet", 2);
                this.append(sb, "The post-removal scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "posttransScriptlet", 2);
                this.append(sb, "The posttrans script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prefix", 2);
                this.append(sb, "The relocation prefix for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preinstall", 2);
                this.append(sb, "Deprecated. Use preinstallScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The pre-installation script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preinstallScript", 2);
                this.append(sb, "Deprecated. Use preinstallScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the pre-installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "preinstallScriptlet", 2);
                this.append(sb, "The pre-installation scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prepare", 2);
                this.append(sb, "Deprecated. Use prepareScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The prepare script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prepareScript", 2);
                this.append(sb, "Deprecated. Use prepareScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the prepare script. A File which does not exist is ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prepareScriptlet", 2);
                this.append(sb, "The prepare scriptlet;", 3);
                this.append(sb, "", 0);
                this.append(sb, "preremove", 2);
                this.append(sb, "Deprecated. Use preremoveScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The pre-removal script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "preremoveScript", 2);
                this.append(sb, "Deprecated. Use preremoveScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the pre-removal script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "preremoveScriptlet", 2);
                this.append(sb, "The pre-removal scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "prereqs", 2);
                this.append(sb, "The list of prerequisites for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pretransScriptlet", 2);
                this.append(sb, "The pretrans scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "projversion", 2);
                this.append(sb, "The version portion of the RPM file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "provides", 2);
                this.append(sb, "The list of virtual packages provided by this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "release", 2);
                this.append(sb, "The release portion of the RPM file name.\nBeginning with 2.0-beta-2, this is an optional parameter. By default, the release will be generated from the modifier portion of the project version using the following rules:\n\n-\tIf no modifier exists, the release will be 1.\n-\tIf the modifier ends with SNAPSHOT, the timestamp (in UTC) of the build will be appended to end.\n-\tAll instances of '-' in the modifier will be replaced with '_'.\n-\tIf a modifier exists and does not end with SNAPSHOT, '_1' will be appended to end.\n\n\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "requires", 2);
                this.append(sb, "The list of requirements for this package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "summary", 2);
                this.append(sb, "The one-line description of the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetOS", 2);
                this.append(sb, "The target os for building the RPM. By default, this will be populated to Os.OS_NAME.\nThis can be used in conjunction with Source targetOSName to flex the contents of the rpm based on operating system.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetVendor", 2);
                this.append(sb, "The target vendor for building the RPM. By default, this will be populated to the result of rpm -E %{_host_vendor}.", 3);
                this.append(sb, "", 0);
                this.append(sb, "triggers", 2);
                this.append(sb, "The list of triggers to take place on installation of other packages.\n\u00a0<triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0<installTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<subpackage>optional</subpackage>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<program>program\u00a0to\u00a0execute\u00a0(if\u00a0not\u00a0shell)\u00a0optional</program>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<script>actual\u00a0contents\u00a0of\u00a0script\u00a0-\u00a0optional</script>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<scriptFile>location\u00a0of\u00a0file\u00a0containing\u00a0script\u00a0-\u00a0optional</script>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<fileEncoding>character\u00a0encoding\u00a0for\u00a0script\u00a0file\u00a0-\u00a0recommended</fileEncoding>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<trigger>package/version\u00a0to\u00a0trigger\u00a0on\u00a0(i.e.\u00a0jre\u00a0>\u00a01.5)</trigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0</installTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0<removeTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0</removeTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0<postRemoveTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0</postRemoveTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0</triggers>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "A URL for the vendor.", 3);
                this.append(sb, "", 0);
                this.append(sb, "vendor", 2);
                this.append(sb, "The vendor supplying the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verify", 2);
                this.append(sb, "Deprecated. Use verifyScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The verification script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyScript", 2);
                this.append(sb, "Deprecated. Use verifyScriplet", 3);
                this.append(sb, "", 0);
                this.append(sb, "The location of the verification script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "verifyScriptlet", 2);
                this.append(sb, "The verify scriptlet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workarea", 2);
                this.append(sb, "The area for RPM to use for building the package.\nNOTE: The absolute path to the workarea MUST NOT have a space in any of the directory names.\nBeginning with release 2.0-beta-3, sub-directories will be created within the workarea for each execution of the plugin within a life cycle.\nThe pattern will be workarea/name[-classifier].\nThe classifier portion is only applicable for the attached-rpm goal.\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "version".equals(this.goal)) {
            this.append(sb, "rpm:version", 0);
            this.append(sb, "Makes the rpm version and release attributes available as properties.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "projversion", 2);
                this.append(sb, "The version portion of the RPM file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "release", 2);
                this.append(sb, "The release portion of the RPM file name.\nThis is an optional parameter. By default, the release will be generated from the modifier portion of the project version using the following rules:\n\n-\tIf no modifier exists, the release will be 1.\n-\tIf the modifier ends with SNAPSHOT, the timestamp (in UTC) of the build will be appended to end.\n-\tAll instances of '-' in the modifier will be replaced with '_'.\n-\tIf a modifier exists and does not end with SNAPSHOT, '_1' will be appended to end.\n\n\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "releaseProperty (Default: rpm.release)", 2);
                this.append(sb, "The system property to set the calculated release to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "versionProperty (Default: rpm.version)", 2);
                this.append(sb, "The system property to set the calculated version to.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

