/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.maven.plugin.Mojo;

final class VersionHelper {
    private final RPMVersionableMojo mojo;

    public VersionHelper(RPMVersionableMojo mojo) {
        this.mojo = mojo;
    }

    Version calculateVersion() {
        Version response = new Version();
        String version = this.mojo.getVersion();
        String release = this.mojo.getRelease();
        int modifierIndex = version.indexOf(45);
        if (modifierIndex == -1) {
            response.version = version;
            if (release == null || release.length() == 0) {
                response.release = "1";
            }
        } else {
            response.version = version.substring(0, modifierIndex);
            this.mojo.getLog().warn((CharSequence)("rpm version string truncated to " + version));
            if (release == null || release.length() == 0) {
                String modifier = version.substring(modifierIndex + 1, version.length());
                if ((modifier = modifier.replace('-', '_')).endsWith("SNAPSHOT")) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    modifier = modifier + simpleDateFormat.format(new Date());
                } else {
                    modifier = modifier + "_1";
                }
                response.release = modifier;
            }
        }
        return response;
    }

    static interface RPMVersionableMojo
    extends Mojo {
        public String getVersion();

        public String getRelease();
    }

    static final class Version {
        String version;
        String release;

        Version() {
        }

        public String toString() {
            return this.version + '-' + this.release;
        }
    }
}

