package org.codehaus.mojo.rpm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on rpm-maven-plugin.<br/> Call <pre>  mvn rpm:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Aug 23 15:31:21 CEST 2012
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.9)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:rpm-maven-plugin:2.1-alpha-2", 0 );
        append( sb, "", 0 );

        append( sb, "RPM Maven Plugin", 0 );
        append( sb, "Maven plugin which assembles files into an RPM package for installation on various target UNIX systems.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 4 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "attached-rpm".equals( goal ) )
        {
            append( sb, "rpm:attached-rpm", 0 );
            append( sb, "Construct the RPM file and attaches it as a secondary artifact.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "autoProvides (Default: true)", 2 );
                append( sb, "Automatically add provided shared libraries.", 3 );
                append( sb, "", 0 );

                append( sb, "autoRequires (Default: true)", 2 );
                append( sb, "Automatically add requirements deduced from included shared libraries.", 3 );
                append( sb, "", 0 );

                append( sb, "changelogFile", 2 );
                append( sb, "The changelog file. If the file does not exist, it is ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "The classifier for the rpm secondary artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "clean", 2 );
                append( sb, "Deprecated. Use cleanScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The clean script.", 3 );
                append( sb, "", 0 );

                append( sb, "cleanScript", 2 );
                append( sb, "Deprecated. Use cleanScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the clean script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "cleanScriptlet", 2 );
                append( sb, "The clean scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "conflicts", 2 );
                append( sb, "The list of conflicts for this package.", 3 );
                append( sb, "", 0 );

                append( sb, "copyright", 2 );
                append( sb, "The one-line copyright information.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultDirmode", 2 );
                append( sb, "The default directory mode (octal string) to assign to directories when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultFilemode", 2 );
                append( sb, "The default file mode (octal string) to assign to files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultGroupname", 2 );
                append( sb, "The default group name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultUsername", 2 );
                append( sb, "The default user name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3 );
                append( sb, "", 0 );

                append( sb, "defineStatements", 2 );
                append( sb, "A list of %define arguments", 3 );
                append( sb, "", 0 );

                append( sb, "description", 2 );
                append( sb, "The long description of the package.", 3 );
                append( sb, "Expression: ${project.description}", 3 );
                append( sb, "", 0 );

                append( sb, "disabled", 2 );
                append( sb, "Indicates if the execution should be disabled. If true, nothing will occur during execution.", 3 );
                append( sb, "", 0 );

                append( sb, "distribution", 2 );
                append( sb, "The distribution containing this package.", 3 );
                append( sb, "", 0 );

                append( sb, "escapeString", 2 );
                append( sb, "Expression preceded with the String won\'t be interpolated \\${foo} will be replaced with ${foo}", 3 );
                append( sb, "Expression: ${maven.rpm.escapeString}", 3 );
                append( sb, "", 0 );

                append( sb, "filters", 2 );
                append( sb, "Filters (property files) to include during the interpolation of the pom.xml.", 3 );
                append( sb, "", 0 );

                append( sb, "group", 2 );
                append( sb, "The package group for the package.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "icon", 2 );
                append( sb, "An icon for the package.", 3 );
                append( sb, "", 0 );

                append( sb, "install", 2 );
                append( sb, "Deprecated. Use installScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "installScript", 2 );
                append( sb, "Deprecated. Use installScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "installScriptlet", 2 );
                append( sb, "The installation scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "keyname", 2 );
                append( sb, "Set to a key name to sign the package using GPG. If keyPassphrase is not also provided, this will require the input of the passphrase at the terminal.", 3 );
                append( sb, "Expression: ${gpg.keyname}", 3 );
                append( sb, "", 0 );

                append( sb, "keyPassphrase", 2 );
                append( sb, "The passphrase for the keyname to sign the rpm. This utilizes expect and requires that expect be on the PATH.\nNote that the data type used is NOT String.\n\n<configuration>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0<keyPassphrase>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<passphrase>password</passphrase>\n\u00a0\u00a0\u00a0\u00a0</keyPassphrase>\n\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "mappings", 2 );
                append( sb, "The list of file mappings.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "name", 2 );
                append( sb, "The name portion of the output file name.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.artifactId}", 3 );
                append( sb, "", 0 );

                append( sb, "needarch", 2 );
                append( sb, "The target architecture for the rpm. The default value is noarch.\nFor passivity purposes, a value of true or false will indicate whether the architecture of the build machine will be used. Any other value (such as x86_64) will set the architecture of the rpm to x86_64.\n\nThis can also be used in conjunction with Source targetArchitecture to flex the contents of the rpm based on the architecture.\n", 3 );
                append( sb, "", 0 );

                append( sb, "obsoletes", 2 );
                append( sb, "The list of obsoletes for this package.", 3 );
                append( sb, "", 0 );

                append( sb, "packager", 2 );
                append( sb, "The name of the person or group creating the package.", 3 );
                append( sb, "Expression: ${project.organization.name}", 3 );
                append( sb, "", 0 );

                append( sb, "postinstall", 2 );
                append( sb, "Deprecated. Use postinstallScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The post-installation script.", 3 );
                append( sb, "", 0 );

                append( sb, "postinstallScript", 2 );
                append( sb, "Deprecated. Use postinstallScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the post-installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "postinstallScriptlet", 2 );
                append( sb, "The post install scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "postremove", 2 );
                append( sb, "Deprecated. Use postremoveScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The post-removal script.", 3 );
                append( sb, "", 0 );

                append( sb, "postremoveScript", 2 );
                append( sb, "Deprecated. Use postremoveScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the post-removal script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "postremoveScriptlet", 2 );
                append( sb, "The post-removal scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "posttransScriptlet", 2 );
                append( sb, "The posttrans script.", 3 );
                append( sb, "", 0 );

                append( sb, "prefix", 2 );
                append( sb, "The relocation prefix for this package.", 3 );
                append( sb, "", 0 );

                append( sb, "preinstall", 2 );
                append( sb, "Deprecated. Use preinstallScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The pre-installation script.", 3 );
                append( sb, "", 0 );

                append( sb, "preinstallScript", 2 );
                append( sb, "Deprecated. Use preinstallScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the pre-installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "preinstallScriptlet", 2 );
                append( sb, "The pre-installation scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "prepare", 2 );
                append( sb, "Deprecated. Use prepareScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The prepare script.", 3 );
                append( sb, "", 0 );

                append( sb, "prepareScript", 2 );
                append( sb, "Deprecated. Use prepareScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the prepare script. A File which does not exist is ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "prepareScriptlet", 2 );
                append( sb, "The prepare scriptlet;", 3 );
                append( sb, "", 0 );

                append( sb, "preremove", 2 );
                append( sb, "Deprecated. Use preremoveScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The pre-removal script.", 3 );
                append( sb, "", 0 );

                append( sb, "preremoveScript", 2 );
                append( sb, "Deprecated. Use preremoveScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the pre-removal script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "preremoveScriptlet", 2 );
                append( sb, "The pre-removal scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "prereqs", 2 );
                append( sb, "The list of prerequisites for this package.", 3 );
                append( sb, "", 0 );

                append( sb, "pretransScriptlet", 2 );
                append( sb, "The pretrans scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "projversion", 2 );
                append( sb, "The version portion of the RPM file name.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.version}", 3 );
                append( sb, "", 0 );

                append( sb, "provides", 2 );
                append( sb, "The list of virtual packages provided by this package.", 3 );
                append( sb, "", 0 );

                append( sb, "release", 2 );
                append( sb, "The release portion of the RPM file name.\nBeginning with 2.0-beta-2, this is an optional parameter. By default, the release will be generated from the modifier portion of the project version using the following rules:\n\n-\tIf no modifier exists, the release will be 1.\n-\tIf the modifier ends with SNAPSHOT, the timestamp (in UTC) of the build will be appended to end.\n-\tAll instances of \'-\' in the modifier will be replaced with \'_\'.\n-\tIf a modifier exists and does not end with SNAPSHOT, \'_1\' will be appended to end.\n\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "releaseProperty (Default: rpm.release)", 2 );
                append( sb, "The system property to read the calculated release from, normally set by the version mojo.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "requires", 2 );
                append( sb, "The list of requirements for this package.", 3 );
                append( sb, "", 0 );

                append( sb, "summary", 2 );
                append( sb, "The one-line description of the package.", 3 );
                append( sb, "Expression: ${project.name}", 3 );
                append( sb, "", 0 );

                append( sb, "targetOS", 2 );
                append( sb, "The target os for building the RPM. By default, this will be populated to Os.OS_NAME.\nThis can be used in conjunction with Source targetOSName to flex the contents of the rpm based on operating system.\n", 3 );
                append( sb, "", 0 );

                append( sb, "targetVendor", 2 );
                append( sb, "The target vendor for building the RPM. By default, this will be populated to the result of rpm -E %{_host_vendor}.", 3 );
                append( sb, "", 0 );

                append( sb, "triggers", 2 );
                append( sb, "The list of triggers to take place on installation of other packages.\n\u00a0<triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0<installTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<subpackage>optional</subpackage>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<program>program\u00a0to\u00a0execute\u00a0(if\u00a0not\u00a0shell)\u00a0optional</program>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<script>actual\u00a0contents\u00a0of\u00a0script\u00a0-\u00a0optional</script>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<scriptFile>location\u00a0of\u00a0file\u00a0containing\u00a0script\u00a0-\u00a0optional</script>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<fileEncoding>character\u00a0encoding\u00a0for\u00a0script\u00a0file\u00a0-\u00a0recommended</fileEncoding>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<trigger>package/version\u00a0to\u00a0trigger\u00a0on\u00a0(i.e.\u00a0jre\u00a0>\u00a01.5)</trigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0</installTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0<removeTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0</removeTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0<postRemoveTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0</postRemoveTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0</triggers>\n", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "A URL for the vendor.", 3 );
                append( sb, "Expression: ${project.organization.url}", 3 );
                append( sb, "", 0 );

                append( sb, "vendor", 2 );
                append( sb, "The vendor supplying the package.", 3 );
                append( sb, "Expression: ${project.organization.name}", 3 );
                append( sb, "", 0 );

                append( sb, "verify", 2 );
                append( sb, "Deprecated. Use verifyScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The verification script.", 3 );
                append( sb, "", 0 );

                append( sb, "verifyScript", 2 );
                append( sb, "Deprecated. Use verifyScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the verification script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "verifyScriptlet", 2 );
                append( sb, "The verify scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "versionProperty (Default: rpm.version)", 2 );
                append( sb, "The system property to read the calculated version from, normally set by the version mojo.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "workarea", 2 );
                append( sb, "The area for RPM to use for building the package.\nNOTE: The absolute path to the workarea MUST NOT have a space in any of the directory names.\nBeginning with release 2.0-beta-3, sub-directories will be created within the workarea for each execution of the plugin within a life cycle.\nThe pattern will be workarea/name[-classifier].\nThe classifier portion is only applicable for the attached-rpm goal.\n", 3 );
                append( sb, "Expression: ${project.build.directory}/rpm", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "rpm:help", 0 );
            append( sb, "Display help information on rpm-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0rpm:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "rpm".equals( goal ) )
        {
            append( sb, "rpm:rpm", 0 );
            append( sb, "Construct the RPM file.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "autoProvides (Default: true)", 2 );
                append( sb, "Automatically add provided shared libraries.", 3 );
                append( sb, "", 0 );

                append( sb, "autoRequires (Default: true)", 2 );
                append( sb, "Automatically add requirements deduced from included shared libraries.", 3 );
                append( sb, "", 0 );

                append( sb, "changelogFile", 2 );
                append( sb, "The changelog file. If the file does not exist, it is ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "clean", 2 );
                append( sb, "Deprecated. Use cleanScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The clean script.", 3 );
                append( sb, "", 0 );

                append( sb, "cleanScript", 2 );
                append( sb, "Deprecated. Use cleanScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the clean script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "cleanScriptlet", 2 );
                append( sb, "The clean scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "conflicts", 2 );
                append( sb, "The list of conflicts for this package.", 3 );
                append( sb, "", 0 );

                append( sb, "copyright", 2 );
                append( sb, "The one-line copyright information.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultDirmode", 2 );
                append( sb, "The default directory mode (octal string) to assign to directories when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultFilemode", 2 );
                append( sb, "The default file mode (octal string) to assign to files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultGroupname", 2 );
                append( sb, "The default group name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultUsername", 2 );
                append( sb, "The default user name for files when installed.\nOnly applicable to a Mapping if filemode, username, AND groupname are NOT populated.", 3 );
                append( sb, "", 0 );

                append( sb, "defineStatements", 2 );
                append( sb, "A list of %define arguments", 3 );
                append( sb, "", 0 );

                append( sb, "description", 2 );
                append( sb, "The long description of the package.", 3 );
                append( sb, "Expression: ${project.description}", 3 );
                append( sb, "", 0 );

                append( sb, "disabled", 2 );
                append( sb, "Indicates if the execution should be disabled. If true, nothing will occur during execution.", 3 );
                append( sb, "", 0 );

                append( sb, "distribution", 2 );
                append( sb, "The distribution containing this package.", 3 );
                append( sb, "", 0 );

                append( sb, "escapeString", 2 );
                append( sb, "Expression preceded with the String won\'t be interpolated \\${foo} will be replaced with ${foo}", 3 );
                append( sb, "Expression: ${maven.rpm.escapeString}", 3 );
                append( sb, "", 0 );

                append( sb, "filters", 2 );
                append( sb, "Filters (property files) to include during the interpolation of the pom.xml.", 3 );
                append( sb, "", 0 );

                append( sb, "group", 2 );
                append( sb, "The package group for the package.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "icon", 2 );
                append( sb, "An icon for the package.", 3 );
                append( sb, "", 0 );

                append( sb, "install", 2 );
                append( sb, "Deprecated. Use installScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "installScript", 2 );
                append( sb, "Deprecated. Use installScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "installScriptlet", 2 );
                append( sb, "The installation scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "keyname", 2 );
                append( sb, "Set to a key name to sign the package using GPG. If keyPassphrase is not also provided, this will require the input of the passphrase at the terminal.", 3 );
                append( sb, "Expression: ${gpg.keyname}", 3 );
                append( sb, "", 0 );

                append( sb, "keyPassphrase", 2 );
                append( sb, "The passphrase for the keyname to sign the rpm. This utilizes expect and requires that expect be on the PATH.\nNote that the data type used is NOT String.\n\n<configuration>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0<keyPassphrase>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<passphrase>password</passphrase>\n\u00a0\u00a0\u00a0\u00a0</keyPassphrase>\n\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "mappings", 2 );
                append( sb, "The list of file mappings.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "name", 2 );
                append( sb, "The name portion of the output file name.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.artifactId}", 3 );
                append( sb, "", 0 );

                append( sb, "needarch", 2 );
                append( sb, "The target architecture for the rpm. The default value is noarch.\nFor passivity purposes, a value of true or false will indicate whether the architecture of the build machine will be used. Any other value (such as x86_64) will set the architecture of the rpm to x86_64.\n\nThis can also be used in conjunction with Source targetArchitecture to flex the contents of the rpm based on the architecture.\n", 3 );
                append( sb, "", 0 );

                append( sb, "obsoletes", 2 );
                append( sb, "The list of obsoletes for this package.", 3 );
                append( sb, "", 0 );

                append( sb, "packager", 2 );
                append( sb, "The name of the person or group creating the package.", 3 );
                append( sb, "Expression: ${project.organization.name}", 3 );
                append( sb, "", 0 );

                append( sb, "postinstall", 2 );
                append( sb, "Deprecated. Use postinstallScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The post-installation script.", 3 );
                append( sb, "", 0 );

                append( sb, "postinstallScript", 2 );
                append( sb, "Deprecated. Use postinstallScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the post-installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "postinstallScriptlet", 2 );
                append( sb, "The post install scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "postremove", 2 );
                append( sb, "Deprecated. Use postremoveScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The post-removal script.", 3 );
                append( sb, "", 0 );

                append( sb, "postremoveScript", 2 );
                append( sb, "Deprecated. Use postremoveScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the post-removal script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "postremoveScriptlet", 2 );
                append( sb, "The post-removal scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "posttransScriptlet", 2 );
                append( sb, "The posttrans script.", 3 );
                append( sb, "", 0 );

                append( sb, "prefix", 2 );
                append( sb, "The relocation prefix for this package.", 3 );
                append( sb, "", 0 );

                append( sb, "preinstall", 2 );
                append( sb, "Deprecated. Use preinstallScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The pre-installation script.", 3 );
                append( sb, "", 0 );

                append( sb, "preinstallScript", 2 );
                append( sb, "Deprecated. Use preinstallScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the pre-installation script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "preinstallScriptlet", 2 );
                append( sb, "The pre-installation scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "prepare", 2 );
                append( sb, "Deprecated. Use prepareScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The prepare script.", 3 );
                append( sb, "", 0 );

                append( sb, "prepareScript", 2 );
                append( sb, "Deprecated. Use prepareScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the prepare script. A File which does not exist is ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "prepareScriptlet", 2 );
                append( sb, "The prepare scriptlet;", 3 );
                append( sb, "", 0 );

                append( sb, "preremove", 2 );
                append( sb, "Deprecated. Use preremoveScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The pre-removal script.", 3 );
                append( sb, "", 0 );

                append( sb, "preremoveScript", 2 );
                append( sb, "Deprecated. Use preremoveScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the pre-removal script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "preremoveScriptlet", 2 );
                append( sb, "The pre-removal scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "prereqs", 2 );
                append( sb, "The list of prerequisites for this package.", 3 );
                append( sb, "", 0 );

                append( sb, "pretransScriptlet", 2 );
                append( sb, "The pretrans scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "projversion", 2 );
                append( sb, "The version portion of the RPM file name.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.version}", 3 );
                append( sb, "", 0 );

                append( sb, "provides", 2 );
                append( sb, "The list of virtual packages provided by this package.", 3 );
                append( sb, "", 0 );

                append( sb, "release", 2 );
                append( sb, "The release portion of the RPM file name.\nBeginning with 2.0-beta-2, this is an optional parameter. By default, the release will be generated from the modifier portion of the project version using the following rules:\n\n-\tIf no modifier exists, the release will be 1.\n-\tIf the modifier ends with SNAPSHOT, the timestamp (in UTC) of the build will be appended to end.\n-\tAll instances of \'-\' in the modifier will be replaced with \'_\'.\n-\tIf a modifier exists and does not end with SNAPSHOT, \'_1\' will be appended to end.\n\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "releaseProperty (Default: rpm.release)", 2 );
                append( sb, "The system property to read the calculated release from, normally set by the version mojo.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "requires", 2 );
                append( sb, "The list of requirements for this package.", 3 );
                append( sb, "", 0 );

                append( sb, "summary", 2 );
                append( sb, "The one-line description of the package.", 3 );
                append( sb, "Expression: ${project.name}", 3 );
                append( sb, "", 0 );

                append( sb, "targetOS", 2 );
                append( sb, "The target os for building the RPM. By default, this will be populated to Os.OS_NAME.\nThis can be used in conjunction with Source targetOSName to flex the contents of the rpm based on operating system.\n", 3 );
                append( sb, "", 0 );

                append( sb, "targetVendor", 2 );
                append( sb, "The target vendor for building the RPM. By default, this will be populated to the result of rpm -E %{_host_vendor}.", 3 );
                append( sb, "", 0 );

                append( sb, "triggers", 2 );
                append( sb, "The list of triggers to take place on installation of other packages.\n\u00a0<triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0<installTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<subpackage>optional</subpackage>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<program>program\u00a0to\u00a0execute\u00a0(if\u00a0not\u00a0shell)\u00a0optional</program>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<script>actual\u00a0contents\u00a0of\u00a0script\u00a0-\u00a0optional</script>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<scriptFile>location\u00a0of\u00a0file\u00a0containing\u00a0script\u00a0-\u00a0optional</script>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<fileEncoding>character\u00a0encoding\u00a0for\u00a0script\u00a0file\u00a0-\u00a0recommended</fileEncoding>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<trigger>package/version\u00a0to\u00a0trigger\u00a0on\u00a0(i.e.\u00a0jre\u00a0>\u00a01.5)</trigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</triggers>\n\u00a0\u00a0\u00a0\u00a0\u00a0</installTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0<removeTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0</removeTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0<postRemoveTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0</postRemoveTrigger>\n\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0</triggers>\n", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "A URL for the vendor.", 3 );
                append( sb, "Expression: ${project.organization.url}", 3 );
                append( sb, "", 0 );

                append( sb, "vendor", 2 );
                append( sb, "The vendor supplying the package.", 3 );
                append( sb, "Expression: ${project.organization.name}", 3 );
                append( sb, "", 0 );

                append( sb, "verify", 2 );
                append( sb, "Deprecated. Use verifyScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The verification script.", 3 );
                append( sb, "", 0 );

                append( sb, "verifyScript", 2 );
                append( sb, "Deprecated. Use verifyScriplet", 3 );
                append( sb, "", 0 );
                append( sb, "The location of the verification script.\nBeginning with release 2.0-beta-3, a File which does not exist is ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "verifyScriptlet", 2 );
                append( sb, "The verify scriptlet.", 3 );
                append( sb, "", 0 );

                append( sb, "versionProperty (Default: rpm.version)", 2 );
                append( sb, "The system property to read the calculated version from, normally set by the version mojo.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "workarea", 2 );
                append( sb, "The area for RPM to use for building the package.\nNOTE: The absolute path to the workarea MUST NOT have a space in any of the directory names.\nBeginning with release 2.0-beta-3, sub-directories will be created within the workarea for each execution of the plugin within a life cycle.\nThe pattern will be workarea/name[-classifier].\nThe classifier portion is only applicable for the attached-rpm goal.\n", 3 );
                append( sb, "Expression: ${project.build.directory}/rpm", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "version".equals( goal ) )
        {
            append( sb, "rpm:version", 0 );
            append( sb, "Makes the rpm version and release attributes available as properties.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "projversion", 2 );
                append( sb, "The version portion of the RPM file name.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.version}", 3 );
                append( sb, "", 0 );

                append( sb, "release", 2 );
                append( sb, "The release portion of the RPM file name.\nThis is an optional parameter. By default, the release will be generated from the modifier portion of the project version using the following rules:\n\n-\tIf no modifier exists, the release will be 1.\n-\tIf the modifier ends with SNAPSHOT, the timestamp (in UTC) of the build will be appended to end.\n-\tAll instances of \'-\' in the modifier will be replaced with \'_\'.\n-\tIf a modifier exists and does not end with SNAPSHOT, \'_1\' will be appended to end.\n\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "releaseProperty (Default: rpm.release)", 2 );
                append( sb, "The system property to set the calculated release to.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "versionProperty (Default: rpm.version)", 2 );
                append( sb, "The system property to set the calculated version to.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
