/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.codehaus.mojo.rpm.FileHelper;
import org.codehaus.mojo.rpm.FilteringDirectoryArchiver;
import org.codehaus.mojo.rpm.Mapping;
import org.codehaus.mojo.rpm.Passphrase;
import org.codehaus.mojo.rpm.RPMHelper;
import org.codehaus.mojo.rpm.Scriptlet;
import org.codehaus.mojo.rpm.Source;
import org.codehaus.mojo.rpm.SpecWriter;
import org.codehaus.mojo.rpm.VersionHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;

abstract class AbstractRPMMojo
extends AbstractMojo
implements VersionHelper.RPMVersionableMojo {
    private final Map macroKeyToValue = new HashMap();
    private final Map linkTargetToSources = new LinkedHashMap();
    private String name;
    private String projversion;
    private String release;
    private String needarch;
    private String targetArch;
    private String targetOS;
    private String targetVendor;
    private String keyname;
    private Passphrase keyPassphrase;
    private String description;
    private String summary;
    private String copyright;
    private String distribution;
    private File icon;
    private String vendor;
    private String url;
    private String group;
    private String packager;
    private boolean autoProvides;
    private boolean autoRequires;
    private LinkedHashSet provides;
    private LinkedHashSet requires;
    private LinkedHashSet prereqs;
    private LinkedHashSet obsoletes;
    private LinkedHashSet conflicts;
    private String prefix;
    private File workarea;
    private List mappings;
    private String prepare;
    private File prepareScript;
    private Scriptlet prepareScriptlet;
    private String preinstall;
    private File preinstallScript;
    private Scriptlet preinstallScriptlet;
    private String postinstall;
    private File postinstallScript;
    private Scriptlet postinstallScriptlet;
    private String install;
    private File installScript;
    private Scriptlet installScriptlet;
    private String preremove;
    private File preremoveScript;
    private Scriptlet preremoveScriptlet;
    private String postremove;
    private File postremoveScript;
    private Scriptlet postremoveScriptlet;
    private String verify;
    private File verifyScript;
    private Scriptlet verifyScriptlet;
    private String clean;
    private File cleanScript;
    private Scriptlet cleanScriptlet;
    private Scriptlet pretransScriptlet;
    private Scriptlet posttransScriptlet;
    private List triggers;
    private List filters;
    private String escapeString;
    private MavenSession session;
    private MavenFileFilter mavenFileFilter;
    private List defaultFilterWrappers;
    private Artifact artifact;
    private List attachedArtifacts;
    protected MavenProject project;
    private List defineStatements;
    private String defaultFilemode;
    private String defaultDirmode;
    private String defaultUsername;
    private String defaultGroupname;
    private boolean disabled;
    private File buildroot;
    private File rpmBuildroot;
    private String changelog;
    private File changelogFile;
    private RPMHelper helper;
    private String versionProperty;
    private String releaseProperty;

    AbstractRPMMojo() {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.disabled) {
            this.getLog().info((CharSequence)"MOJO is disabled. Doing nothing.");
            return;
        }
        this.helper = new RPMHelper(this);
        this.checkParams(this.helper);
        String classifier = this.getClassifier();
        this.workarea = classifier != null ? new File(this.workarea, this.name + '-' + classifier) : new File(this.workarea, this.name);
        this.buildWorkArea();
        this.setDefaultWrappers();
        FilteringDirectoryArchiver copier = new FilteringDirectoryArchiver();
        copier.setMavenFileFilter(this.mavenFileFilter);
        new FileHelper(this, copier).installFiles();
        this.writeSpecFile();
        this.helper.buildPackage();
        this.afterExecution();
    }

    protected void afterExecution() throws MojoExecutionException, MojoFailureException {
    }

    String getClassifier() {
        return null;
    }

    protected File getRPMFile() {
        File rpms = new File(this.workarea, "RPMS");
        File archDir = new File(rpms, this.targetArch);
        return new File(archDir, this.name + '-' + this.projversion + '-' + this.release + '.' + this.targetArch + ".rpm");
    }

    private void setDefaultWrappers() throws MojoExecutionException {
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
        mavenResourcesExecution.setEscapeString(this.escapeString);
        try {
            this.defaultFilterWrappers = this.mavenFileFilter.getDefaultFilterWrappers(this.project, this.filters, false, this.session, mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            this.getLog().error((CharSequence)("fail to build filering wrappers " + e.getMessage()));
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void buildWorkArea() throws MojoFailureException, MojoExecutionException {
        String[] topdirs = new String[]{"BUILD", "RPMS", "SOURCES", "SPECS", "SRPMS", "tmp-buildroot", "buildroot"};
        if (!this.workarea.exists()) {
            this.getLog().info((CharSequence)("Creating directory " + this.workarea.getAbsolutePath()));
            if (!this.workarea.mkdirs()) {
                throw new MojoFailureException("Unable to create directory " + this.workarea.getAbsolutePath());
            }
        }
        this.validateWorkarea();
        for (int i = 0; i < topdirs.length; ++i) {
            File d = new File(this.workarea, topdirs[i]);
            if (d.exists()) {
                this.getLog().info((CharSequence)("Directory " + d.getAbsolutePath() + " already exists. Deleting all contents."));
                try {
                    FileUtils.cleanDirectory((File)d);
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to clear directory: " + d.getName(), (Exception)e);
                }
            }
            this.getLog().info((CharSequence)("Creating directory " + d.getAbsolutePath()));
            if (d.mkdir()) continue;
            throw new MojoFailureException("Unable to create directory " + d.getAbsolutePath());
        }
        this.buildroot = new File(this.workarea, "tmp-buildroot");
        this.rpmBuildroot = new File(this.workarea, "buildroot");
    }

    private void checkParams(RPMHelper helper) throws MojoExecutionException, MojoFailureException {
        String release;
        Log log = this.getLog();
        String projversion = this.project.getProperties().getProperty(this.versionProperty);
        if (projversion != null) {
            this.projversion = projversion;
        }
        if ((release = this.project.getProperties().getProperty(this.releaseProperty)) != null) {
            this.release = release;
        }
        if (this.projversion == null || this.release == null) {
            VersionHelper.Version version = new VersionHelper(this).calculateVersion();
            this.projversion = version.version;
            this.release = version.release;
        }
        log.debug((CharSequence)("project version = " + this.projversion));
        log.debug((CharSequence)("project release = " + this.release));
        this.targetArch = this.needarch == null || this.needarch.length() == 0 || "false".equalsIgnoreCase(this.needarch) ? "noarch" : ("true".equalsIgnoreCase(this.needarch) ? Os.OS_ARCH : this.needarch);
        log.debug((CharSequence)("targetArch = " + this.targetArch));
        if (this.targetOS == null || this.targetOS.length() == 0) {
            this.targetOS = Os.OS_NAME;
        }
        log.debug((CharSequence)("targetOS = " + this.targetOS));
        if (this.targetVendor == null || this.targetVendor.length() == 0) {
            this.targetVendor = helper.getHostVendor();
        }
        log.debug((CharSequence)("targetVendor = " + this.targetVendor));
        for (Mapping map : this.mappings) {
            if (map.getDirectory() == null) {
                throw new MojoFailureException("<mapping> element must contain the destination directory");
            }
            if (map.getSources() == null) continue;
            for (Source src : map.getSources()) {
                if (src.getLocation() != null) continue;
                throw new MojoFailureException("<mapping><source> tag must contain the source directory");
            }
        }
        this.prepareScriptlet = this.passiveScripts("prepare", this.prepareScriptlet, this.prepare, this.prepareScript);
        this.preinstallScriptlet = this.passiveScripts("preinstall", this.preinstallScriptlet, this.preinstall, this.preinstallScript);
        this.installScriptlet = this.passiveScripts("install", this.installScriptlet, this.install, this.installScript);
        this.postinstallScriptlet = this.passiveScripts("postinstall", this.postinstallScriptlet, this.postinstall, this.postinstallScript);
        this.preremoveScriptlet = this.passiveScripts("preremove", this.preremoveScriptlet, this.preremove, this.preremoveScript);
        this.postremoveScriptlet = this.passiveScripts("postremove", this.postremoveScriptlet, this.postremove, this.postremoveScript);
        this.verifyScriptlet = this.passiveScripts("verify", this.verifyScriptlet, this.verify, this.verifyScript);
        this.cleanScriptlet = this.passiveScripts("clean", this.cleanScriptlet, this.clean, this.cleanScript);
        if (this.changelog == null && this.changelogFile != null) {
            if (!this.changelogFile.exists()) {
                log.debug((CharSequence)(this.changelogFile.getAbsolutePath() + " does not exist - ignoring"));
            } else {
                try {
                    StringBuffer sb = new StringBuffer();
                    BufferedReader br = new BufferedReader(new FileReader(this.changelogFile));
                    while (br.ready()) {
                        String line = br.readLine();
                        sb.append(line);
                        sb.append('\n');
                    }
                    br.close();
                    this.changelog = sb.toString();
                }
                catch (Throwable t) {
                    throw new MojoExecutionException("Unable to read " + this.changelogFile.getAbsolutePath(), t);
                }
            }
        }
        if (this.copyright == null) {
            this.copyright = this.generateCopyrightText();
        }
        if (this.obsoletes != null) {
            if (this.provides == null) {
                this.provides = this.obsoletes;
            } else {
                this.provides.addAll(this.obsoletes);
            }
        }
        this.processDefineStatements();
    }

    private void processDefineStatements() {
        if (this.defineStatements == null) {
            return;
        }
        for (String define : this.defineStatements) {
            String[] parts = define.split(" ");
            if (parts.length != 2) continue;
            this.macroKeyToValue.put(parts[0], parts[1]);
        }
    }

    private void validateWorkarea() throws MojoExecutionException {
        if (!this.workarea.isDirectory()) {
            throw new MojoExecutionException(this.workarea + " is not a directory");
        }
        if (this.workarea.getAbsolutePath().trim().indexOf(" ") != -1) {
            throw new MojoExecutionException(this.workarea + " contains a space in path");
        }
    }

    private Scriptlet passiveScripts(String name, Scriptlet scriptlet, String script, File file) {
        if (scriptlet == null && (script != null || file != null)) {
            scriptlet = new Scriptlet();
            scriptlet.setScript(script);
            scriptlet.setScriptFile(file);
            this.getLog().warn((CharSequence)("Deprecated <" + name + "> and/or <" + name + "Script> used - should use <" + name + "Scriptlet>"));
        }
        return scriptlet;
    }

    String evaluateMacro(String macro) throws MojoExecutionException {
        if (this.macroKeyToValue.containsKey(macro)) {
            return (String)this.macroKeyToValue.get(macro);
        }
        String value = this.helper.evaluateMacro(macro);
        this.macroKeyToValue.put(macro, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSpecFile() throws MojoExecutionException {
        File f = new File(this.workarea, "SPECS");
        File specf = new File(f, this.name + ".spec");
        try {
            this.getLog().info((CharSequence)("Creating spec file " + specf.getAbsolutePath()));
            PrintWriter spec = new PrintWriter(new FileWriter(specf));
            try {
                new SpecWriter(this, spec).writeSpecFile();
            }
            finally {
                spec.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write " + specf.getAbsolutePath(), (Exception)e);
        }
    }

    private String generateCopyrightText() {
        String organization;
        String year = this.project.getInceptionYear();
        String string = organization = this.project.getOrganization() == null ? null : this.project.getOrganization().getName();
        String copyrightText = year != null && organization != null ? year + " " + organization : (year == null ? organization : year);
        return copyrightText;
    }

    final Map getLinkTargetToSources() {
        return this.linkTargetToSources;
    }

    final String getName() {
        return this.name;
    }

    public final String getRelease() {
        return this.release;
    }

    final String getDescription() {
        return this.description;
    }

    final String getSummary() {
        return this.summary;
    }

    final String getCopyright() {
        return this.copyright;
    }

    final String getDistribution() {
        return this.distribution;
    }

    final File getIcon() {
        return this.icon;
    }

    final String getVendor() {
        return this.vendor;
    }

    final String getUrl() {
        return this.url;
    }

    final String getGroup() {
        return this.group;
    }

    final String getPackager() {
        return this.packager;
    }

    final boolean isAutoProvides() {
        return this.autoProvides;
    }

    final boolean isAutoRequires() {
        return this.autoRequires;
    }

    final LinkedHashSet getProvides() {
        return this.provides;
    }

    final LinkedHashSet getRequires() {
        return this.requires;
    }

    final LinkedHashSet getPrereqs() {
        return this.prereqs;
    }

    final LinkedHashSet getObsoletes() {
        return this.obsoletes;
    }

    final LinkedHashSet getConflicts() {
        return this.conflicts;
    }

    final String getPrefix() {
        return this.prefix;
    }

    final List getMappings() {
        return this.mappings;
    }

    final Scriptlet getPrepareScriptlet() {
        return this.prepareScriptlet;
    }

    final Scriptlet getPreinstallScriptlet() {
        return this.preinstallScriptlet;
    }

    final Scriptlet getPostinstallScriptlet() {
        return this.postinstallScriptlet;
    }

    final Scriptlet getInstallScriptlet() {
        return this.installScriptlet;
    }

    final Scriptlet getPreremoveScriptlet() {
        return this.preremoveScriptlet;
    }

    final Scriptlet getPostremoveScriptlet() {
        return this.postremoveScriptlet;
    }

    final Scriptlet getVerifyScriptlet() {
        return this.verifyScriptlet;
    }

    final Scriptlet getCleanScriptlet() {
        return this.cleanScriptlet;
    }

    final Scriptlet getPretransScriptlet() {
        return this.pretransScriptlet;
    }

    final Scriptlet getPosttransScriptlet() {
        return this.posttransScriptlet;
    }

    final List getTriggers() {
        return this.triggers;
    }

    final List getDefineStatements() {
        return this.defineStatements;
    }

    final String getDefaultFilemode() {
        return this.defaultFilemode;
    }

    final String getDefaultDirmode() {
        return this.defaultDirmode;
    }

    final String getDefaultUsername() {
        return this.defaultUsername;
    }

    final String getDefaultGroupname() {
        return this.defaultGroupname;
    }

    final File getBuildroot() {
        return this.buildroot;
    }

    final File getRPMBuildroot() {
        return this.rpmBuildroot;
    }

    public final String getVersion() {
        return this.projversion;
    }

    final String getChangelog() {
        return this.changelog;
    }

    final String getTargetArch() {
        return this.targetArch;
    }

    final String getTargetOS() {
        return this.targetOS;
    }

    final String getTargetVendor() {
        return this.targetVendor;
    }

    final String getKeyname() {
        return this.keyname;
    }

    final Passphrase getKeyPassphrase() {
        return this.keyPassphrase;
    }

    final File getWorkarea() {
        return this.workarea;
    }

    final Artifact getArtifact() {
        return this.artifact;
    }

    final List getAttachedArtifacts() {
        return this.attachedArtifacts;
    }

    final List getFilterWrappers() {
        return this.defaultFilterWrappers;
    }
}

