/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;

public class Dependency {
    private List<Artifact> includes;
    private List<Artifact> excludes;
    private boolean stripVersion = false;

    public List<Artifact> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> incls) throws MojoExecutionException {
        this.includes = this.parseList(incls);
    }

    public List<Artifact> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excls) throws MojoExecutionException {
        this.excludes = this.parseList(excls);
    }

    public boolean getStripVersion() {
        return this.stripVersion;
    }

    public void setStripVersion(boolean stripVersion) throws MojoExecutionException {
        this.stripVersion = stripVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[dependencies");
        if (this.includes != null) {
            sb.append(" include [" + this.includes + "]");
        }
        if (this.excludes != null) {
            sb.append(" exclude [" + this.excludes + "]");
        }
        sb.append(" stripVersion (" + this.stripVersion + ")");
        sb.append("]");
        return sb.toString();
    }

    private List parseList(List<String> in) throws MojoExecutionException {
        ArrayList<DefaultArtifact> retval = new ArrayList<DefaultArtifact>();
        for (String s : in) {
            int p1 = s.indexOf(":");
            if (p1 == -1) {
                throw new MojoExecutionException("Include and exclude must include both group and artifact IDs.");
            }
            int p2 = s.indexOf(":", p1 + 1);
            VersionRange vr = null;
            if (p2 == -1) {
                p2 = s.length();
                try {
                    vr = VersionRange.createFromVersionSpec((String)"[0,]");
                }
                catch (InvalidVersionSpecificationException ex) {
                    throw new MojoExecutionException("Default version string is invalid!");
                }
            }
            try {
                vr = VersionRange.createFromVersionSpec((String)s.substring(p2 + 1));
            }
            catch (InvalidVersionSpecificationException ex) {
                throw new MojoExecutionException("Version string " + s.substring(p2 + 1) + " is invalid.");
            }
            retval.add(new DefaultArtifact(s.substring(0, p1), s.substring(p1 + 1, p2), vr, null, "", "", null));
        }
        return retval;
    }
}

