/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;

public class Dependency {
    private List<Artifact> includes;
    private List<Artifact> excludes;
    private boolean stripVersion = false;

    public List<Artifact> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> incls) throws MojoExecutionException {
        this.includes = this.parseList(incls);
    }

    public List<Artifact> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excls) throws MojoExecutionException {
        this.excludes = this.parseList(excls);
    }

    public boolean getStripVersion() {
        return this.stripVersion;
    }

    public void setStripVersion(boolean stripVersion) throws MojoExecutionException {
        this.stripVersion = stripVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[dependencies");
        if (this.includes != null) {
            sb.append(" include [" + this.includes + "]");
        }
        if (this.excludes != null) {
            sb.append(" exclude [" + this.excludes + "]");
        }
        sb.append(" stripVersion (" + this.stripVersion + ")");
        sb.append("]");
        return sb.toString();
    }

    private List<Artifact> parseList(List<String> in) throws MojoExecutionException {
        ArrayList<Artifact> retval = new ArrayList<Artifact>();
        for (String s : in) {
            String[] parts = s.split(":");
            if (parts.length == 0) {
                throw new MojoExecutionException("Include and exclude must include both group and artifact IDs.");
            }
            String groupId = parts[0];
            String artifactId = parts[1];
            String versionStr = null;
            String type = "";
            String classifier = "";
            VersionRange vr = null;
            if (parts.length > 2) {
                versionStr = parts[2];
                if (parts.length > 3) {
                    type = parts[3];
                }
                if (parts.length > 4) {
                    classifier = parts[4];
                }
            } else {
                versionStr = "[0,]";
            }
            try {
                vr = VersionRange.createFromVersionSpec((String)versionStr);
            }
            catch (InvalidVersionSpecificationException ex) {
                throw new MojoExecutionException("Default version string is invalid!");
            }
            retval.add((Artifact)new DefaultArtifact(groupId, artifactId, vr, null, type, classifier, null));
        }
        return retval;
    }
}

