/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.mojo.rpm.ArtifactMap;
import org.codehaus.mojo.rpm.Dependency;
import org.codehaus.mojo.rpm.Source;

public class Mapping {
    private String directory;
    private String configuration;
    private boolean documentation;
    private String filemode;
    private String username;
    private String groupname;
    private List<Source> sources;
    private ArtifactMap artifact;
    private Dependency dependency;
    private boolean directoryIncluded = true;
    private boolean recurseDirectories = false;
    private List<String> copiedFileNamesRelativeToDestination;
    private List<String> linkedFileNamesRelativeToDestination;
    private boolean hasSoftLinks = false;
    private File absoluteDestination;
    private static final List<String> EMPTY_STRING_LIST = new ArrayList<String>();

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String dir) {
        this.directory = dir;
    }

    public boolean isDirectoryIncluded() {
        return this.directoryIncluded;
    }

    public void setDirectoryIncluded(boolean directoryIncluded) {
        this.directoryIncluded = directoryIncluded;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String cfg) {
        this.configuration = cfg;
    }

    public boolean isDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(boolean isDoc) {
        this.documentation = isDoc;
    }

    public String getFilemode() {
        return this.filemode;
    }

    public void setFilemode(String fmode) {
        this.filemode = fmode;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String uname) {
        this.username = uname;
    }

    public String getGroupname() {
        return this.groupname;
    }

    public void setGroupname(String grpname) {
        this.groupname = grpname;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(List<Source> srclist) {
        this.sources = srclist;
    }

    public ArtifactMap getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ArtifactMap am) {
        this.artifact = am;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency am) {
        this.dependency = am;
    }

    public final boolean isRecurseDirectories() {
        return this.recurseDirectories;
    }

    public final void setRecurseDirectories(boolean recurseDirectories) {
        this.recurseDirectories = recurseDirectories;
    }

    public String getAttrString(String defaultFileMode, String defaultGrp, String defaultUsr) {
        defaultFileMode = defaultFileMode == null ? "-" : defaultFileMode;
        defaultGrp = defaultGrp == null ? "-" : defaultGrp;
        defaultUsr = defaultUsr == null ? "-" : defaultUsr;
        StringBuilder sb = new StringBuilder();
        if (this.configuration != null && !"FALSE".equalsIgnoreCase(this.configuration)) {
            sb.append("%config");
            if (this.configuration.length() > 0 && !"TRUE".equalsIgnoreCase(this.configuration)) {
                sb.append('(');
                sb.append(this.configuration);
                sb.append(')');
            }
            sb.append(' ');
        }
        if (this.documentation) {
            sb.append("%doc ");
        }
        if ((this.sources == null || this.sources.size() == 0) && this.dependency == null && this.artifact == null) {
            sb.append("%dir ");
        }
        if (this.filemode != null || this.username != null || this.groupname != null) {
            sb.append("%attr(");
            sb.append(this.filemode != null ? this.filemode : defaultFileMode);
            sb.append(',');
            sb.append(this.username != null ? this.username : defaultUsr);
            sb.append(',');
            sb.append(this.groupname != null ? this.groupname : defaultGrp);
            sb.append(')');
        }
        return sb.toString();
    }

    public String getDestination() {
        if (this.directory == null) {
            return "nowhere";
        }
        return this.directory;
    }

    public boolean isDirOnly() {
        if (this.sources != null && !this.sources.isEmpty()) {
            return false;
        }
        if (this.artifact != null) {
            return false;
        }
        return this.dependency == null;
    }

    List<String> getCopiedFileNamesRelativeToDestination() {
        return this.copiedFileNamesRelativeToDestination != null ? this.copiedFileNamesRelativeToDestination : EMPTY_STRING_LIST;
    }

    void addCopiedFileNamesRelativeToDestination(List<String> copiedFileNamesRelativeToDestination) {
        if (this.copiedFileNamesRelativeToDestination == null) {
            this.copiedFileNamesRelativeToDestination = new ArrayList<String>(copiedFileNamesRelativeToDestination);
        } else {
            this.copiedFileNamesRelativeToDestination.addAll(copiedFileNamesRelativeToDestination);
        }
    }

    void addCopiedFileNameRelativeToDestination(String copiedFileNameRelativeToDestination) {
        if (this.copiedFileNamesRelativeToDestination == null) {
            this.copiedFileNamesRelativeToDestination = new LinkedList<String>();
        }
        this.copiedFileNamesRelativeToDestination.add(copiedFileNameRelativeToDestination);
    }

    List<String> getLinkedFileNamesRelativeToDestination() {
        return this.linkedFileNamesRelativeToDestination != null ? this.linkedFileNamesRelativeToDestination : EMPTY_STRING_LIST;
    }

    void addLinkedFileNameRelativeToDestination(String linkedFileNameRelativeToDestination) {
        if (this.linkedFileNamesRelativeToDestination == null) {
            this.linkedFileNamesRelativeToDestination = new LinkedList<String>();
        }
        this.linkedFileNamesRelativeToDestination.add(linkedFileNameRelativeToDestination);
    }

    boolean hasSoftLinks() {
        return this.hasSoftLinks;
    }

    void setHasSoftLinks(boolean hasSoftLinks) {
        this.hasSoftLinks = hasSoftLinks;
    }

    final File getAbsoluteDestination() {
        return this.absoluteDestination;
    }

    final void setAbsoluteDestination(File absoluteDestination) {
        this.absoluteDestination = absoluteDestination;
    }

    public String toString() {
        boolean sourceShown = false;
        StringBuilder sb = new StringBuilder();
        sb.append("[\"" + this.getDestination() + "\" ");
        sb.append("{" + this.getAttrString(null, null, null) + "}");
        if (this.isDirOnly()) {
            sb.append(" (dir only)]");
        } else {
            sb.append(" from ");
            if (this.sources != null) {
                sb.append(this.sources.toString());
                sourceShown = true;
            }
            if (this.artifact != null) {
                if (sourceShown) {
                    sb.append(", ");
                }
                sb.append(this.artifact.toString());
                sourceShown = true;
            }
            if (this.dependency != null) {
                if (sourceShown) {
                    sb.append(", ");
                }
                sb.append(this.dependency.toString());
                sourceShown = true;
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

