/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rspec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.rspec.RSpecScriptFactory;
import org.codehaus.mojo.rspec.ScriptFactory;
import org.codehaus.mojo.rspec.ShellScriptFactory;

public class RspecRunnerMojo
extends AbstractMojo {
    protected String basedir;
    protected List<String> classpathElements;
    protected String sourceDirectory;
    protected String outputDirectory;
    protected String reportName;
    protected String jrubyHome;
    protected boolean ignoreFailure;
    protected boolean skipTests;
    protected Properties systemProperties;
    private RSpecScriptFactory rspecScriptFactory = new RSpecScriptFactory();
    private ShellScriptFactory shellScriptFactory = new ShellScriptFactory();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            this.getLog().info((CharSequence)"Skipping RSpec tests");
            return;
        }
        this.getLog().info((CharSequence)("Running RSpec tests from " + this.sourceDirectory));
        String reportPath = this.outputDirectory + "/" + this.reportName;
        this.initScriptFactory(this.rspecScriptFactory, reportPath);
        this.initScriptFactory(this.shellScriptFactory, reportPath);
        try {
            this.rspecScriptFactory.emit();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"error emitting .rb", (Throwable)e);
        }
        try {
            this.shellScriptFactory.emit();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"error emitting .sh", (Throwable)e);
        }
        try {
            this.runScript(this.rspecScriptFactory.getScript());
        }
        catch (MalformedURLException e) {
            this.getLog().error((CharSequence)"error running script", (Throwable)e);
        }
    }

    private void initScriptFactory(ScriptFactory factory, String reportPath) {
        factory.setBaseDir(this.basedir);
        factory.setClasspathElements(this.classpathElements);
        factory.setOutputDir(new File(this.outputDirectory));
        factory.setReportPath(reportPath);
        factory.setSourceDir(this.sourceDirectory);
        factory.setSystemProperties(this.systemProperties);
    }

    private void runScript(String script) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(this.jrubyHome + "/bin/jruby");
        cmdLine.add("-J-Dbasedir=" + this.basedir);
        for (Object propName : this.systemProperties.keySet()) {
            String propValue = this.systemProperties.getProperty(propName.toString());
            cmdLine.add("-J-D" + propName + "=" + propValue);
        }
        StringBuilder classpath = new StringBuilder();
        boolean first = true;
        for (String element : this.classpathElements) {
            if (first) {
                first = false;
            } else {
                classpath.append(":");
            }
            classpath.append(element);
        }
        ProcessBuilder builder = new ProcessBuilder(cmdLine);
        builder.environment().put("JRUBY_HOME", this.jrubyHome);
        builder.environment().put("CLASSPATH", classpath.toString());
        try {
            Process process = builder.start();
            new InputConsumer(process.getInputStream(), System.out).start();
            new InputConsumer(process.getErrorStream(), System.err).start();
            OutputStream out = process.getOutputStream();
            out.write(script.getBytes());
            out.close();
            process.waitFor();
            System.err.println("exit: " + process.exitValue());
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        catch (InterruptedException e) {
            this.getLog().error((Throwable)e);
        }
    }

    private class InputConsumer
    extends Thread {
        private InputStream input;
        private OutputStream sink;

        public InputConsumer(InputStream input, OutputStream sink) {
            this.input = input;
            this.sink = sink;
        }

        public void run() {
            byte[] buf = new byte[128];
            int len = 0;
            try {
                while ((len = this.input.read(buf)) >= 0) {
                    this.sink.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

