/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog.scm.svn;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xmlbeans.XmlException;
import org.codehaus.mojo.scmchangelog.AbstractBufferedConsumer;
import org.codehaus.mojo.scmchangelog.scm.svn.xml.CommitDocument;
import org.codehaus.mojo.scmchangelog.scm.svn.xml.EntryDocument;
import org.codehaus.mojo.scmchangelog.scm.svn.xml.ListDocument;
import org.codehaus.mojo.scmchangelog.scm.svn.xml.ListsDocument;
import org.codehaus.mojo.scmchangelog.tags.Tag;

public class SvnListConsumer
extends AbstractBufferedConsumer {
    private List elements = new ArrayList();
    private Pattern filter;

    public SvnListConsumer(Pattern filter) {
        this.filter = filter;
    }

    public List analyse() {
        this.getLogger().debug("Receiving this line " + this.getOutput());
        try {
            ListsDocument doc = ListsDocument.Factory.parse(new StringReader(this.getOutput()));
            for (int i = 0; i < doc.getLists().getListArray().length; ++i) {
                ListDocument.List list = doc.getLists().getListArray()[i];
                for (int j = 0; j < list.getEntryArray().length; ++j) {
                    EntryDocument.Entry entry = list.getEntryArray()[j];
                    this.getLogger().debug(entry.getName());
                    if (!this.isTagAccepted(entry.getName())) continue;
                    this.getLogger().debug("Creating new Tag");
                    Tag tag = new Tag(entry.getName());
                    CommitDocument.Commit commit = entry.getCommit();
                    tag.setDate(commit.getDate().getTime());
                    tag.setEndRevision(commit.getRevision().toString());
                    tag.setAuthor(commit.getAuthor());
                    this.elements.add(tag);
                }
            }
            Collections.sort(this.elements);
            Tag oldTag = new Tag("");
            oldTag.setEndRevision("0");
            Iterator iter = this.elements.iterator();
            while (iter.hasNext()) {
                Tag tag = (Tag)iter.next();
                tag.setStartRevision(oldTag.getEndRevision());
                oldTag = tag;
            }
            return this.elements;
        }
        catch (XmlException ex) {
            this.getLogger().error(this.getOutput(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (IOException ioe) {
            this.getLogger().error(this.getOutput(), (Throwable)ioe);
            throw new RuntimeException(ioe);
        }
    }

    protected boolean isTagAccepted(String title) {
        if ("tags".equalsIgnoreCase(title)) {
            return false;
        }
        if (this.filter != null) {
            Matcher matcher = this.filter.matcher(title);
            this.getLogger().debug("Filtering " + title + " against " + this.filter.pattern() + " : " + matcher.matches());
            return matcher.matches();
        }
        return true;
    }
}

