/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar.bootstrap;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.codehaus.mojo.sonar.ServerMetadata;
import org.codehaus.mojo.sonar.bootstrap.DependencyCollector;
import org.codehaus.mojo.sonar.bootstrap.ExceptionHandling;
import org.codehaus.mojo.sonar.bootstrap.MavenProjectConverter;
import org.sonar.runner.api.EmbeddedRunner;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class RunnerBootstraper {
    private final RuntimeInformation runtimeInformation;
    private final Log log;
    private final MavenSession session;
    private final LifecycleExecutor lifecycleExecutor;
    private final ArtifactFactory artifactFactory;
    private final ArtifactRepository localRepository;
    private final ArtifactMetadataSource artifactMetadataSource;
    private final ArtifactCollector artifactCollector;
    private final DependencyTreeBuilder dependencyTreeBuilder;
    private final MavenProjectBuilder projectBuilder;
    private final SecDispatcher securityDispatcher;
    private ServerMetadata server;

    public RunnerBootstraper(RuntimeInformation runtimeInformation, Log log, MavenSession session, LifecycleExecutor lifecycleExecutor, ArtifactFactory artifactFactory, ArtifactRepository localRepository, ArtifactMetadataSource artifactMetadataSource, ArtifactCollector artifactCollector, DependencyTreeBuilder dependencyTreeBuilder, MavenProjectBuilder projectBuilder, SecDispatcher securityDispatcher, ServerMetadata server) {
        this.runtimeInformation = runtimeInformation;
        this.log = log;
        this.session = session;
        this.lifecycleExecutor = lifecycleExecutor;
        this.artifactFactory = artifactFactory;
        this.localRepository = localRepository;
        this.artifactMetadataSource = artifactMetadataSource;
        this.artifactCollector = artifactCollector;
        this.dependencyTreeBuilder = dependencyTreeBuilder;
        this.projectBuilder = projectBuilder;
        this.securityDispatcher = securityDispatcher;
        this.server = server;
    }

    public void execute() throws IOException, MojoExecutionException {
        try {
            EmbeddedRunner runner = (EmbeddedRunner)((EmbeddedRunner)EmbeddedRunner.create().setApp("Maven", this.runtimeInformation.getMavenVersion())).addProperties(this.session.getSystemProperties());
            runner.mask("org.slf4j.LoggerFactory").unmask("org.slf4j.Logger").unmask("org.slf4j.ILoggerFactory").mask("org.slf4j.").mask("ch.qos.logback.").mask("org.sonar.").mask("com.google.common").unmask("");
            runner.addExtensions(new Object[]{this.session, this.log, this.lifecycleExecutor, this.projectBuilder});
            if (!this.server.supportsNewDependencyProperty()) {
                runner.addExtensions(new Object[]{this.artifactFactory, this.localRepository, this.artifactMetadataSource, this.artifactCollector, this.dependencyTreeBuilder});
            }
            if (this.log.isDebugEnabled()) {
                runner.setProperty("sonar.verbose", "true");
            }
            runner.addProperties(this.collectProperties());
            runner.setProperty("sonar.mojoUseRunner", "true");
            runner.execute();
        }
        catch (Exception e) {
            throw ExceptionHandling.handle(e, this.log);
        }
    }

    private Properties collectProperties() throws MojoExecutionException {
        Properties props = new MavenProjectConverter(this.log, this.server.supportsFilesAsSources(), new DependencyCollector(this.dependencyTreeBuilder, this.artifactFactory, this.localRepository, this.artifactMetadataSource, this.artifactCollector)).configure(this.session.getProjects(), this.session.getTopLevelProject(), this.session.getUserProperties());
        props.putAll((Map<?, ?>)this.decryptProperties(props));
        return props;
    }

    public Properties decryptProperties(Properties properties) {
        Properties newProperties = new Properties();
        try {
            for (String key : properties.stringPropertyNames()) {
                if (!key.contains(".password")) continue;
                this.decrypt(properties, newProperties, key);
            }
        }
        catch (Exception e) {
            this.log.warn((CharSequence)"Unable to decrypt properties", (Throwable)e);
        }
        return newProperties;
    }

    private void decrypt(Properties properties, Properties newProperties, String key) {
        try {
            String decrypted = this.securityDispatcher.decrypt(properties.getProperty(key));
            newProperties.setProperty(key, decrypted);
        }
        catch (SecDispatcherException e) {
            this.log.debug((CharSequence)("Unable to decrypt property " + key), (Throwable)e);
        }
    }
}

