/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sysdeo.ide;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.sysdeo.ide.IdeDependency;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;

public class ReadWorkspaceLocations {
    private static final String BINARY_LOCATION_FILE = ".location";
    private static final String METADATA_PLUGINS_ORG_ECLIPSE_CORE_RESOURCES_PROJECTS = ".metadata/.plugins/org.eclipse.core.resources/.projects";
    private static final String[] PARENT_VERSION = new String[]{"parent", "version"};
    private static final String[] PARENT_GROUP_ID = new String[]{"parent", "groupId"};
    private static final String[] PACKAGING = new String[]{"packaging"};
    private static final String[] VERSION = new String[]{"version"};
    private static final String[] GROUP_ID = new String[]{"groupId"};
    private static final String[] ARTEFACT_ID = new String[]{"artifactId"};

    private String getProjectLocation(File workspaceLocation, File project) {
        File projectBase;
        String projectLocation = null;
        File location = new File(project, BINARY_LOCATION_FILE);
        if (location.exists()) {
            try {
                SafeChunkyInputStream fileInputStream = new SafeChunkyInputStream(location);
                DataInputStream dataInputStream = new DataInputStream((InputStream)fileInputStream);
                String file = dataInputStream.readUTF().trim();
                if (file.length() > 0) {
                    file = file.substring(file.indexOf(58) + 1);
                    while (!Character.isLetterOrDigit(file.charAt(0))) {
                        file = file.substring(1);
                    }
                    if (file.indexOf(58) < 0) {
                        file = File.separator + file;
                    }
                    projectLocation = file;
                }
            }
            catch (FileNotFoundException e) {
                projectLocation = "unknown";
            }
            catch (IOException e) {
                projectLocation = "unknown";
            }
        }
        if (projectLocation == null && (projectBase = new File(workspaceLocation, project.getName())).isDirectory()) {
            projectLocation = projectBase.getAbsolutePath();
        }
        return projectLocation;
    }

    private String getValue(Xpp3Dom element, String[] elementNames, String defaultValue) {
        String value = null;
        Xpp3Dom dom = element;
        for (int index = 0; dom != null && index < elementNames.length; dom = dom.getChild(elementNames[index]), ++index) {
        }
        if (dom != null) {
            value = dom.getValue();
        }
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return value;
    }

    private IdeDependency readArtefact(String projectLocation, Log logger) throws XmlPullParserException, IOException {
        File pomFile;
        File baseDir = new File(projectLocation);
        File projectFile = new File(baseDir, ".project");
        String eclipseProjectName = baseDir.getName();
        if (projectFile.exists()) {
            Xpp3Dom project = Xpp3DomBuilder.build((Reader)new FileReader(projectFile));
            eclipseProjectName = this.getValue(project, new String[]{"name"}, eclipseProjectName);
        }
        if ((pomFile = new File(baseDir, "pom.xml")).exists()) {
            Xpp3Dom pom = Xpp3DomBuilder.build((Reader)new FileReader(pomFile));
            String artifact = this.getValue(pom, ARTEFACT_ID, null);
            String group = this.getValue(pom, GROUP_ID, this.getValue(pom, PARENT_GROUP_ID, null));
            String version = this.getValue(pom, VERSION, this.getValue(pom, PARENT_VERSION, null));
            String packaging = this.getValue(pom, PACKAGING, "jar");
            logger.debug((CharSequence)("found workspace artefact " + group + ":" + artifact + ":" + version + " " + packaging + " (" + eclipseProjectName + ")" + " -> " + projectLocation));
            String output = ReadWorkspaceLocations.getOutputDirectory(baseDir);
            return new IdeDependency(group, artifact, version, true, false, false, false, false, null, packaging, output, null);
        }
        logger.debug((CharSequence)("ignored workspace project NO pom available " + projectLocation));
        return null;
    }

    public static String getOutputDirectory(File baseDir) {
        String output;
        block3: {
            output = null;
            try {
                File dotClasspath = new File(baseDir, ".classpath");
                if (!dotClasspath.exists()) break block3;
                Xpp3Dom cp = Xpp3DomBuilder.build((Reader)new FileReader(dotClasspath));
                int count = cp.getChildCount();
                for (int i = 0; i < count; ++i) {
                    Xpp3Dom entry = cp.getChild(i);
                    if (!"output".equals(entry.getAttribute("kind"))) continue;
                    output = entry.getAttribute("path");
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return output;
    }

    public List readWorkspace(File workspacePath, Log logger) {
        ArrayList<IdeDependency> dependencys = new ArrayList<IdeDependency>();
        if (workspacePath != null) {
            File workspace = new File(workspacePath, METADATA_PLUGINS_ORG_ECLIPSE_CORE_RESOURCES_PROJECTS);
            File[] directories = workspace.listFiles();
            for (int index = 0; directories != null && index < directories.length; ++index) {
                File project = directories[index];
                if (!project.isDirectory()) continue;
                try {
                    IdeDependency ideDependency;
                    String projectLocation = this.getProjectLocation(workspacePath, project);
                    if (projectLocation == null || (ideDependency = this.readArtefact(projectLocation, logger)) == null) continue;
                    dependencys.add(ideDependency);
                    continue;
                }
                catch (Exception e) {
                    logger.warn((CharSequence)("could not read workspace project:" + project), (Throwable)e);
                }
            }
        }
        return dependencys;
    }
}

