/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.templating;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

@Mojo(name="filter-test-sources", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class FilterTestSourcesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/src/test/java-templates")
    private File testSourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/java-templates")
    private File testTargetDirectory;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="maven.resources.escapeString")
    protected String escapeString;
    @Parameter
    protected List<String> delimiters;
    @Parameter(defaultValue="true")
    protected boolean useDefaultDelimiters;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Component(hint="default")
    private MavenResourcesFiltering mavenResourcesFiltering;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("source=" + this.testSourceDirectory + " target=" + this.testTargetDirectory));
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource resource = new Resource();
        resource.setFiltering(true);
        this.getLog().debug((CharSequence)this.testSourceDirectory.getAbsolutePath());
        resource.setDirectory(this.testSourceDirectory.getAbsolutePath());
        resources.add(resource);
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, this.testTargetDirectory, this.project, this.encoding, Collections.emptyList(), Collections.emptyList(), this.session);
        mavenResourcesExecution.setInjectProjectBuildFilters(false);
        mavenResourcesExecution.setEscapeString(this.escapeString);
        if (this.delimiters != null && !this.delimiters.isEmpty()) {
            LinkedHashSet<String> delims = new LinkedHashSet<String>();
            if (this.useDefaultDelimiters) {
                delims.addAll(mavenResourcesExecution.getDelimiters());
            }
            for (String delim : this.delimiters) {
                if (delim == null) {
                    delims.add("${*}");
                    continue;
                }
                delims.add(delim);
            }
            mavenResourcesExecution.setDelimiters(delims);
        }
        try {
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.project.addTestCompileSourceRoot(this.testTargetDirectory.getAbsolutePath());
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Source directory: " + this.testTargetDirectory + " added."));
        }
    }
}

