/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.truezip.util.TrueZip;
import org.codehaus.mojo.truezip.util.TrueZipFileSet;
import org.codehaus.mojo.truezip.util.TrueZipFileSetManager;
import org.codehaus.plexus.util.StringUtils;

public class DefaultTrueZip
implements TrueZip {
    public List list(TrueZipFileSet fileSet, boolean verbose, Log logger) {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager(logger, verbose);
        return this.list(fileSet, fileSetManager);
    }

    public List list(TrueZipFileSet fileSet) {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager();
        return this.list(fileSet, fileSetManager);
    }

    private List list(TrueZipFileSet fileSet, TrueZipFileSetManager fileSetManager) {
        if (StringUtils.isBlank((String)fileSet.getDirectory())) {
            fileSet.setDirectory(".");
        }
        String[] files = fileSetManager.getIncludedFiles(fileSet);
        ArrayList<de.schlichtherle.io.File> fileLists = new ArrayList<de.schlichtherle.io.File>();
        for (int i = 0; i < files.length; ++i) {
            de.schlichtherle.io.File source = new de.schlichtherle.io.File(fileSet.getDirectory(), files[i]);
            fileLists.add(source);
        }
        return fileLists;
    }

    public void copy(TrueZipFileSet fileSet, boolean verbose, Log logger) throws IOException {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager(logger, verbose);
        this.copy(fileSet, fileSetManager);
    }

    public void copy(TrueZipFileSet fileSet) throws IOException {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager();
        this.copy(fileSet, fileSetManager);
    }

    public void copy(TrueZipFileSet oneFileSet, TrueZipFileSetManager fileSetManager) throws IOException {
        if (StringUtils.isBlank((String)oneFileSet.getDirectory())) {
            oneFileSet.setDirectory(".");
        }
        String[] files = fileSetManager.getIncludedFiles(oneFileSet);
        for (int i = 0; i < files.length; ++i) {
            String relativeDestPath = files[i];
            if (!StringUtils.isBlank((String)oneFileSet.getOutputDirectory())) {
                relativeDestPath = oneFileSet.getOutputDirectory() + "/" + relativeDestPath;
            }
            de.schlichtherle.io.File dest = new de.schlichtherle.io.File(relativeDestPath);
            de.schlichtherle.io.File source = new de.schlichtherle.io.File(oneFileSet.getDirectory(), files[i]);
            this.copyFile(source, dest);
        }
    }

    public void copyFile(de.schlichtherle.io.File source, de.schlichtherle.io.File dest) throws IOException {
        de.schlichtherle.io.File destParent = (de.schlichtherle.io.File)dest.getParentFile();
        if (!destParent.isDirectory() && !destParent.mkdirs()) {
            throw new IOException("Unable to create " + destParent);
        }
        if (source.isArchive()) {
            if (dest.isArchive() ? !source.archiveCopyAllTo((File)dest) : !source.copyAllTo((File)dest)) {
                throw new IOException("Unable to copy: " + source + " to " + dest);
            }
        } else if (source.isDirectory()) {
            if (!source.copyAllTo((File)dest)) {
                throw new IOException("Unable to copy: " + source + " to " + dest);
            }
        } else {
            de.schlichtherle.io.File.cp_p((File)source, (File)dest);
        }
    }

    public void moveFile(de.schlichtherle.io.File source, de.schlichtherle.io.File dest) {
        de.schlichtherle.io.File file = new de.schlichtherle.io.File((File)source);
        de.schlichtherle.io.File tofile = new de.schlichtherle.io.File((File)dest);
        file.renameTo((File)tofile);
    }

    public void remove(TrueZipFileSet fileSet, boolean verbose, Log logger) throws IOException {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager(logger, verbose);
        this.remove(fileSet, fileSetManager);
    }

    public void remove(TrueZipFileSet fileSet) throws IOException {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager();
        this.remove(fileSet, fileSetManager);
    }

    private void remove(TrueZipFileSet oneFileSet, TrueZipFileSetManager fileSetManager) throws IOException {
        if (StringUtils.isBlank((String)oneFileSet.getDirectory())) {
            throw new IOException("FileSet's directory is required.");
        }
        de.schlichtherle.io.File directory = new de.schlichtherle.io.File(oneFileSet.getDirectory());
        if (!directory.isDirectory()) {
            throw new IOException("FileSet's directory: " + directory + " not found.");
        }
        fileSetManager.delete(oneFileSet, true);
    }
}

