/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip;

import de.schlichtherle.truezip.file.TFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.mojo.truezip.AbstractManipulateArchiveMojo;
import org.codehaus.mojo.truezip.Fileset;
import org.codehaus.mojo.truezip.TrueZipFileSet;
import org.codehaus.plexus.util.StringUtils;

public class MoveMojo
extends AbstractManipulateArchiveMojo {
    private String from;
    private String to;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.intitializeArchiveDectector();
        if (!StringUtils.isBlank((String)this.from)) {
            TFile file = new TFile(this.resolveRelativePath(this.from));
            if (StringUtils.isBlank((String)this.from)) {
                throw new MojoExecutionException("You have specified 'from' configuration to perform the move, but 'to' configuration is not available. ");
            }
            TFile tofile = new TFile(this.resolveRelativePath(this.to));
            try {
                this.truezip.moveFile(file, tofile);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Move file fails", e);
            }
        }
        if (this.fileset != null) {
            this.filesets.add(this.fileset);
            this.fileset = null;
        }
        for (Fileset oneFileSet : this.filesets) {
            try {
                this.resolveRelativePath((FileSet)oneFileSet);
                this.truezip.move((TrueZipFileSet)oneFileSet, this.verbose, this.getLog());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Move fileset fails", e);
            }
        }
        this.tryImmediateUpdate();
    }
}

