/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:versions-maven-plugin:1.0-alpha-2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Versions Maven Plugin 1.0-alpha-2", 0);
        this.append(sb, "Versions Plugin for Maven 2. The Versions Plugin updates the versions of components in the POM.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "display-dependency-updates".equals(this.goal)) {
            this.append(sb, "versions:display-dependency-updates", 0);
            this.append(sb, "Displays all dependencies that have newer versions available.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allowSnapshots (Default: false)", 2);
                this.append(sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonMethod (Default: maven)", 2);
                this.append(sb, "The versioning rule to use when comparing versions. Valid values are maven or numeric which will handle long version numbers provided all components are numeric.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "display-plugin-updates".equals(this.goal)) {
            this.append(sb, "versions:display-plugin-updates", 0);
            this.append(sb, "Displays all plugins that have newer versions available.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allowSnapshots (Default: false)", 2);
                this.append(sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonMethod (Default: maven)", 2);
                this.append(sb, "The versioning rule to use when comparing versions. Valid values are maven or numeric which will handle long version numbers provided all components are numeric.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "versions:help", 0);
            this.append(sb, "Display help information on versions-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0versions:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-child-modules".equals(this.goal)) {
            this.append(sb, "versions:update-child-modules", 0);
            this.append(sb, "Scans the current projects child modules, updating the versions of any which use the current project to the version of the current project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allowSnapshots (Default: false)", 2);
                this.append(sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonMethod (Default: maven)", 2);
                this.append(sb, "The versioning rule to use when comparing versions. Valid values are maven or numeric which will handle long version numbers provided all components are numeric.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-parent".equals(this.goal)) {
            this.append(sb, "versions:update-parent", 0);
            this.append(sb, "Sets the parent version to the latest parent version.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allowSnapshots (Default: false)", 2);
                this.append(sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonMethod (Default: maven)", 2);
                this.append(sb, "The versioning rule to use when comparing versions. Valid values are maven or numeric which will handle long version numbers provided all components are numeric.", 3);
                this.append(sb, "", 0);
                this.append(sb, "parentVersion", 2);
                this.append(sb, "Version specification to control artifact resolution.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-properties".equals(this.goal)) {
            this.append(sb, "versions:update-properties", 0);
            this.append(sb, "Sets properties to the latest versions of specific artifacts.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allowSnapshots (Default: false)", 2);
                this.append(sb, "Whether to allow snapshots when searching for the latest version of an artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "autoLinkItems", 2);
                this.append(sb, "Whether properties linking versions should be auto-detected or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonMethod (Default: maven)", 2);
                this.append(sb, "The versioning rule to use when comparing versions. Valid values are maven or numeric which will handle long version numbers provided all components are numeric.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeProperties", 2);
                this.append(sb, "A comma separated list of properties to not update.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeProperties", 2);
                this.append(sb, "A comma separated list of properties to update.", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkItems", 2);
                this.append(sb, "The properties to update and the artifact coordinates that they are to be updated from.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

